/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.AutoConnectionCloser;
import org.jboss.ejb.client.remoting.EJBClientContextConnectionReconnectHandler;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class ConfigBasedEJBClientContextSelector
implements ContextSelector<EJBClientContext> {
    private static final Logger logger = Logger.getLogger(ConfigBasedEJBClientContextSelector.class);
    private final EJBClientConfiguration ejbClientConfiguration;
    private final EJBClientContext ejbClientContext;

    public ConfigBasedEJBClientContextSelector(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.ejbClientContext = EJBClientContext.create(this.ejbClientConfiguration);
        if (this.ejbClientConfiguration == null) {
            logger.debug("EJB client context " + this.ejbClientContext + " will have no EJB receivers associated with it since there was no " + "EJB client configuration available to create the receivers");
            return;
        }
        try {
            this.setupEJBReceivers();
        }
        catch (IOException ioe) {
            logger.warn((Object)("EJB client context " + this.ejbClientContext + " will have no EJB receivers due to an error setting up EJB receivers"), ioe);
        }
    }

    @Override
    public EJBClientContext getCurrent() {
        return this.ejbClientContext;
    }

    private void setupEJBReceivers() throws IOException {
        if (!this.ejbClientConfiguration.getConnectionConfigurations().hasNext()) {
            return;
        }
        Endpoint endpoint = Remoting.createEndpoint(this.ejbClientConfiguration.getEndpointName(), this.ejbClientConfiguration.getEndpointCreationOptions());
        AutoConnectionCloser.INSTANCE.addEndpoint(endpoint);
        OptionMap remoteConnectionProviderOptions = this.ejbClientConfiguration.getRemoteConnectionProviderCreationOptions();
        endpoint.addConnectionProvider("remote", new RemoteConnectionProviderFactory(), remoteConnectionProviderOptions);
        Iterator<EJBClientConfiguration.RemotingConnectionConfiguration> connectionConfigurations = this.ejbClientConfiguration.getConnectionConfigurations();
        ArrayList connections = new ArrayList();
        int successfulEJBReceiverRegistrations = 0;
        while (connectionConfigurations.hasNext()) {
            EJBClientContextConnectionReconnectHandler reconnectHandler = null;
            EJBClientConfiguration.RemotingConnectionConfiguration connectionConfiguration = connectionConfigurations.next();
            String host = connectionConfiguration.getHost();
            int port = connectionConfiguration.getPort();
            try {
                URI connectionURI = new URI("remote://" + NetworkUtil.formatPossibleIpv6Address(host) + ":" + port);
                OptionMap connectionCreationOptions = connectionConfiguration.getConnectionCreationOptions();
                CallbackHandler callbackHandler = connectionConfiguration.getCallbackHandler();
                int MAX_RECONNECT_ATTEMPTS = 65535;
                reconnectHandler = new EJBClientContextConnectionReconnectHandler(this.ejbClientContext, endpoint, connectionURI, connectionCreationOptions, callbackHandler, connectionConfiguration.getChannelCreationOptions(), 65535);
                IoFuture<Connection> futureConnection = endpoint.connect(connectionURI, connectionCreationOptions, callbackHandler);
                Connection connection = IoFutureHelper.get(futureConnection, connectionConfiguration.getConnectionTimeout(), TimeUnit.MILLISECONDS);
                AutoConnectionCloser.INSTANCE.addConnection(connection);
                RemotingConnectionEJBReceiver remotingEJBReceiver = new RemotingConnectionEJBReceiver(connection, reconnectHandler, connectionConfiguration.getChannelCreationOptions());
                this.ejbClientContext.registerEJBReceiver(remotingEJBReceiver);
                ++successfulEJBReceiverRegistrations;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not register a EJB receiver for connection to remote://" + host + ":" + port), e);
                if (reconnectHandler == null) continue;
                this.ejbClientContext.registerReconnectHandler(reconnectHandler);
                logger.debug("Registered a reconnect handler in EJB client context " + this.ejbClientContext + " for remote://" + host + ":" + port);
            }
        }
        logger.debug("Registered " + successfulEJBReceiverRegistrations + " remoting EJB receivers for EJB client context " + this.ejbClientContext);
    }
}

