/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MockSOAPBody
implements InvocationHandler {
    Element body;
    private static DocumentBuilder BUILDER;

    public MockSOAPBody(Element body) {
        this.body = body;
    }

    public static SOAPBody newInstance(String body) throws IOException {
        return (SOAPBody)Proxy.newProxyInstance(MockSOAPBody.class.getClassLoader(), new Class[]{SOAPBody.class}, (InvocationHandler)new MockSOAPBody(MockSOAPBody.parse(body)));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.body, args);
    }

    private static Element parse(String elementAsString) throws IOException {
        try {
            Document doc = BUILDER.parse(new ByteArrayInputStream(elementAsString.getBytes("UTF-8")));
            return doc.getDocumentElement();
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            BUILDER = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            BUILDER = null;
        }
    }
}

