/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.handler.InitParamResourceResolver;
import org.apache.cxf.jaxws.javaee.ParamValueType;
import org.apache.cxf.jaxws.javaee.PortComponentHandlerType;
import org.apache.cxf.resource.ResourceManager;

public class HandlerChainBuilder {
    static final Logger LOG = LogUtils.getL7dLogger(HandlerChainBuilder.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Bus bus;
    private boolean handlerInitEnabled = true;

    public HandlerChainBuilder(Bus aBus) {
        this.bus = aBus;
    }

    public HandlerChainBuilder() {
        this(null);
    }

    public List<Handler> buildHandlerChainFromConfiguration(PortComponentHandlerType hc) {
        if (null == hc) {
            return null;
        }
        return this.sortHandlers(this.buildHandlerChain(hc, this.getHandlerClassLoader()));
    }

    public List<Handler> buildHandlerChainFromConfiguration(List<PortComponentHandlerType> hc) {
        if (null == hc || hc.size() == 0) {
            return null;
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (PortComponentHandlerType pt : hc) {
            handlers.addAll(this.buildHandlerChain(pt, this.getHandlerClassLoader()));
        }
        return this.sortHandlers(handlers);
    }

    public void setHandlerInitEnabled(boolean b) {
        this.handlerInitEnabled = b;
    }

    public boolean isHandlerInitEnabled() {
        return this.handlerInitEnabled;
    }

    public List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        for (Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }

    protected ClassLoader getHandlerClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected List<Handler> buildHandlerChain(PortComponentHandlerType ht, ClassLoader classLoader) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        try {
            LOG.log(Level.FINE, "loading handler", this.trimString(ht.getHandlerName().getValue()));
            Class<Handler> handlerClass = Class.forName(this.trimString(ht.getHandlerClass().getValue()), true, classLoader).asSubclass(Handler.class);
            Handler handler = handlerClass.newInstance();
            LOG.fine("adding handler to chain: " + handler);
            this.configureHandler(handler, ht);
            handlerChain.add(handler);
        }
        catch (Exception e) {
            throw new WebServiceException(BUNDLE.getString("HANDLER_INSTANTIATION_EXC"), (Throwable)e);
        }
        return handlerChain;
    }

    protected URL resolveHandlerChainFile(Class clz, String filename) {
        URL handlerFile = clz.getResource(filename);
        if (handlerFile == null) {
            try {
                handlerFile = new URL(filename);
                handlerFile.openStream();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return handlerFile;
    }

    private void configureHandler(Handler handler, PortComponentHandlerType h) {
        if (!this.handlerInitEnabled) {
            return;
        }
        if (h.getInitParam().size() == 0) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (ParamValueType param : h.getInitParam()) {
            params.put(this.trimString(param.getParamName() == null ? null : param.getParamName().getValue()), this.trimString(param.getParamValue() == null ? null : param.getParamValue().getValue()));
        }
        Method initMethod = this.getInitMethod(handler);
        if (initMethod != null) {
            this.initializeViaInitMethod(handler, params, initMethod);
        } else {
            this.initializeViaInjection(handler, params);
        }
    }

    private void initializeViaInjection(Handler handler, Map<String, String> params) {
        if (this.bus != null) {
            ResourceManager resMgr = (ResourceManager)this.bus.getExtension(ResourceManager.class);
            List resolvers = resMgr.getResourceResolvers();
            resolvers.add(new InitParamResourceResolver(params));
            ResourceInjector resInj = new ResourceInjector(resMgr, resolvers);
            resInj.inject((Object)handler);
            resInj.construct((Object)handler);
        }
    }

    private void initializeViaInitMethod(Handler handler, Map<String, String> params, Method init) {
        try {
            init.invoke((Object)handler, params);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause() != null ? ex.getCause() : ex;
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"INIT_METHOD_THREW_EXCEPTION", (Throwable)t, handler.getClass());
        }
        catch (IllegalAccessException ex) {
            LOG.log(Level.SEVERE, "CANNOT_ACCESS_INIT", handler.getClass());
        }
    }

    private Method getInitMethod(Handler handler) {
        Method m = null;
        try {
            m = handler.getClass().getMethod("init", Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    private String trimString(String str) {
        return str != null ? str.trim() : null;
    }
}

