/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerGroupDescription {
    private static final String RESOURCE_NAME = ServerGroupDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getServerGroupDescription(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("server-group"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "profile", "description"}).set(bundle2.getString("server-group.profile"));
        root.get(new String[]{"attributes", "profile", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "profile", "required"}).set(true);
        root.get(new String[]{"attributes", "profile", "min-length"}).set(1);
        root.get(new String[]{"attributes", "socket-binding-group", "description"}).set(bundle2.getString("server-group.socket-binding-group"));
        root.get(new String[]{"attributes", "socket-binding-group", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "socket-binding-group", "required"}).set(true);
        root.get(new String[]{"attributes", "socket-binding-port-offset", "description"}).set(bundle2.getString("server-group.socket-binding-port-offset"));
        root.get(new String[]{"attributes", "socket-binding-port-offset", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "socket-binding-port-offset", "required"}).set(false);
        root.get(new String[]{"attributes", "management-subsystem-endpoint", "description"}).set(bundle2.getString("server-group.management-subsystem-endpoint"));
        root.get(new String[]{"attributes", "management-subsystem-endpoint", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"attributes", "management-subsystem-endpoint", "required"}).set(false);
        root.get(new String[]{"attributes", "management-subsystem-endpoint", "default"}).set(false);
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "deployment", "description"}).set(bundle2.getString("server-group.deployment"));
        root.get(new String[]{"children", "deployment", "min-occurs"}).set(0);
        root.get(new String[]{"children", "deployment", "model-description"});
        root.get(new String[]{"children", "jvm", "description"}).set(bundle2.getString("server-group.jvm"));
        root.get(new String[]{"children", "jvm", "min-occurs"}).set(0);
        root.get(new String[]{"children", "jvm", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "jvm", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "system-property", "description"}).set(bundle2.getString("server-group.system-property"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "system-property", "model-description"}).setEmptyObject();
        return root;
    }

    public static ModelNode getServerGroupAdd(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("server-group.add"));
        root.get(new String[]{"request-properties", "profile", "description"}).set(bundle2.getString("server-group.profile"));
        root.get(new String[]{"request-properties", "profile", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "profile", "required"}).set(true);
        root.get(new String[]{"request-properties", "profile", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "socket-binding-group", "description"}).set(bundle2.getString("server-group.socket-binding-group"));
        root.get(new String[]{"request-properties", "socket-binding-group", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "socket-binding-group", "required"}).set(true);
        root.get(new String[]{"request-properties", "socket-binding-port-offset", "description"}).set(bundle2.getString("server-group.socket-binding-port-offset"));
        root.get(new String[]{"request-properties", "socket-binding-port-offset", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "socket-binding-port-offset", "required"}).set(false);
        root.get(new String[]{"request-properties", "jvm", "description"}).set(bundle2.getString("server-group.add.jvm"));
        root.get(new String[]{"request-properties", "jvm", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "jvm", "required"}).set(false);
        root.get(new String[]{"request-properties", "management-subsystem-endpoint", "description"}).set(bundle2.getString("server-group.management-subsystem-endpoint"));
        root.get(new String[]{"request-properties", "management-subsystem-endpoint", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"request-properties", "management-subsystem-endpoint", "required"}).set(false);
        root.get(new String[]{"request-properties", "management-subsystem-endpoint", "default"}).set(false);
        return root;
    }

    public static ModelNode getServerGroupRemove(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("server-group.remove"));
        return root;
    }

    public static ModelNode getDeploymentRemoveOperation(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("server-group.deployment.remove"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRestartServersOperation(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("restart-servers");
        root.get("description").set(bundle2.getString("server-group.servers.restart"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getStopServersOperation(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("stop-servers");
        root.get("description").set(bundle2.getString("server-group.servers.stop"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getStartServersOperation(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("start-servers");
        root.get("description").set(bundle2.getString("server-group.servers.start"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSystemPropertiesDescription(Locale locale) {
        ResourceBundle bundle2 = ServerGroupDescription.getResourceBundle(locale);
        return CommonDescriptions.getSystemPropertyDescription((Locale)locale, (String)bundle2.getString("server-group.system-property"), (boolean)true);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

