/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;

public class HostControllerBootstrap {
    private final ServiceContainer serviceContainer = ServiceContainer.Factory.create((String)"host-controller");
    private final HostControllerEnvironment environment;
    private final byte[] authCode;

    public HostControllerBootstrap(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
    }

    public void bootstrap() throws Exception {
        HostRunningModeControl runningModeControl = new HostRunningModeControl(this.environment.getInitialRunningMode(), RestartMode.SERVERS);
        ControlledProcessState processState = new ControlledProcessState(false);
        ServiceTarget target = this.serviceContainer.subTarget();
        ControlledProcessStateService.addService((ServiceTarget)target, (ControlledProcessState)processState);
        HostControllerService hcs = new HostControllerService(this.environment, runningModeControl, this.authCode, processState);
        target.addService(HostControllerService.HC_SERVICE_NAME, (Service)hcs).install();
    }
}

