/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.dmr.ModelNode;

public class RemoteDomainControllerRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove-remote-domain-controller";
    public static final RemoteDomainControllerRemoveHandler INSTANCE = new RemoteDomainControllerRemoveHandler();

    private RemoteDomainControllerRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        model.get("domain-controller").setEmptyObject();
        context.reloadRequired();
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                context.revertReloadRequired();
            }
        });
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getRemoteDomainControllerRemove(locale);
    }
}

