/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.EJBIdentifierBasedMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.SecurityActions;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.IoUtils;

class MethodInvocationMessageHandler
extends EJBIdentifierBasedMessageHandler {
    private static final char METHOD_PARAM_TYPE_SEPARATOR = ',';
    private static final byte HEADER_METHOD_INVOCATION_RESPONSE = 5;
    private static final byte HEADER_ASYNC_METHOD_NOTIFICATION = 14;
    private final ExecutorService executorService;
    private final MarshallerFactory marshallerFactory;
    private final RemoteAsyncInvocationCancelStatusService remoteAsyncInvocationCancelStatus;

    MethodInvocationMessageHandler(DeploymentRepository deploymentRepository, MarshallerFactory marshallerFactory, ExecutorService executorService, RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatus) {
        super(deploymentRepository);
        this.marshallerFactory = marshallerFactory;
        this.executorService = executorService;
        this.remoteAsyncInvocationCancelStatus = asyncInvocationCancelStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(final ChannelAssociation channelAssociation, MessageInputStream messageInputStream) throws IOException {
        String beanName;
        String distinctName;
        String moduleName;
        String appName;
        DataInputStream input = new DataInputStream((InputStream)messageInputStream);
        final short invocationId = input.readShort();
        String methodName = input.readUTF();
        String[] methodParamTypes = null;
        String signature = input.readUTF();
        methodParamTypes = signature.isEmpty() ? new String[]{} : signature.split(String.valueOf(','));
        ClassLoaderSwitchingClassResolver classResolver = new ClassLoaderSwitchingClassResolver(Thread.currentThread().getContextClassLoader());
        Unmarshaller unmarshaller = this.prepareForUnMarshalling(this.marshallerFactory, (ClassResolver)classResolver, input);
        try {
            appName = (String)unmarshaller.readObject();
            moduleName = (String)unmarshaller.readObject();
            distinctName = (String)unmarshaller.readObject();
            beanName = (String)unmarshaller.readObject();
        }
        catch (ClassNotFoundException e) {
            throw EjbMessages.MESSAGES.classNotFoundException(e);
        }
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName, distinctName, beanName);
        if (ejbDeploymentInformation == null) {
            this.writeNoSuchEJBFailureMessage(channelAssociation, invocationId, appName, moduleName, distinctName, beanName, null);
            return;
        }
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        Runnable runnable = null;
        try {
            Map<String, Object> attachments;
            EJBLocator locator;
            SecurityActions.setContextClassLoader(ejbDeploymentInformation.getDeploymentClassLoader());
            classResolver.switchClassLoader(ejbDeploymentInformation.getDeploymentClassLoader());
            try {
                locator = (EJBLocator)unmarshaller.readObject();
            }
            catch (ClassNotFoundException e) {
                throw EjbMessages.MESSAGES.classNotFoundException(e);
            }
            String viewClassName = locator.getViewType().getName();
            if (!ejbDeploymentInformation.isRemoteView(viewClassName)) {
                this.writeNoSuchEJBFailureMessage(channelAssociation, invocationId, appName, moduleName, distinctName, beanName, viewClassName);
                return;
            }
            final ComponentView componentView = ejbDeploymentInformation.getView(viewClassName);
            final Method invokedMethod = this.findMethod(componentView, methodName, methodParamTypes);
            if (invokedMethod == null) {
                this.writeNoSuchEJBMethodFailureMessage(channelAssociation, invocationId, appName, moduleName, distinctName, beanName, viewClassName, methodName, methodParamTypes);
                return;
            }
            final Object[] methodParams = new Object[methodParamTypes.length];
            if (methodParamTypes.length > 0) {
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    try {
                        methodParams[i] = unmarshaller.readObject();
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.writeException(channelAssociation, this.marshallerFactory, invocationId, cnfe, null);
                        SecurityActions.setContextClassLoader(tccl);
                        return;
                    }
                }
            }
            try {
                attachments = this.readAttachments((ObjectInput)unmarshaller);
            }
            catch (ClassNotFoundException cnfe) {
                this.writeException(channelAssociation, this.marshallerFactory, invocationId, cnfe, null);
                SecurityActions.setContextClassLoader(tccl);
                return;
            }
            unmarshaller.finish();
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (componentView.isAsynchronous(invokedMethod)) {
                        try {
                            MethodInvocationMessageHandler.this.writeAsyncMethodNotification(channelAssociation, invocationId);
                        }
                        catch (Throwable t) {
                            EjbLogger.EJB3_LOGGER.failedToSendAsyncMethodIndicatorToClient(t, invokedMethod);
                        }
                    }
                    Object result = null;
                    RemotingContext.setConnection((Connection)channelAssociation.getChannel().getConnection());
                    try {
                        result = MethodInvocationMessageHandler.this.invokeMethod(invocationId, componentView, invokedMethod, methodParams, locator, attachments);
                    }
                    catch (Throwable throwable) {
                        try {
                            MethodInvocationMessageHandler.this.writeException(channelAssociation, MethodInvocationMessageHandler.this.marshallerFactory, invocationId, throwable, attachments);
                        }
                        catch (IOException ioe) {
                            EjbLogger.ROOT_LOGGER.errorInvokingMethod(throwable, invokedMethod, beanName, appName, moduleName, distinctName);
                            EjbLogger.ROOT_LOGGER.couldNotWriteMethodInvocation(ioe, invokedMethod, beanName, appName, moduleName, distinctName);
                            if (!(ioe instanceof ObjectStreamException)) {
                                IoUtils.safeClose((Closeable)channelAssociation.getChannel());
                            }
                            return;
                        }
                    }
                    finally {
                        RemotingContext.clear();
                    }
                    try {
                        Affinity weakAffinity = null;
                        if (locator instanceof StatefulEJBLocator && componentView.getComponent() instanceof StatefulSessionComponent) {
                            StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)componentView.getComponent();
                            weakAffinity = MethodInvocationMessageHandler.this.getWeakAffinity(statefulSessionComponent, (StatefulEJBLocator)locator);
                        } else if (componentView.getComponent() instanceof StatelessSessionComponent) {
                            StatelessSessionComponent statelessSessionComponent = (StatelessSessionComponent)componentView.getComponent();
                            weakAffinity = statelessSessionComponent.getWeakAffinity();
                        }
                        if (weakAffinity != null) {
                            attachments.put("jboss.ejb.weak.affinity", weakAffinity);
                        }
                        MethodInvocationMessageHandler.this.writeMethodInvocationResponse(channelAssociation, invocationId, result, attachments);
                    }
                    catch (IOException ioe) {
                        EjbLogger.ROOT_LOGGER.couldNotWriteMethodInvocation(ioe, invokedMethod, beanName, appName, moduleName, distinctName);
                        if (!(ioe instanceof ObjectStreamException)) {
                            IoUtils.safeClose((Closeable)channelAssociation.getChannel());
                        }
                        return;
                    }
                }
            };
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
        this.executorService.submit(runnable);
    }

    private Affinity getWeakAffinity(StatefulSessionComponent statefulSessionComponent, StatefulEJBLocator<?> statefulEJBLocator) {
        SessionID sessionID = statefulEJBLocator.getSessionId();
        return statefulSessionComponent.getCache().getWeakAffinity(sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(short invocationId, ComponentView componentView, Method method, Object[] args, EJBLocator<?> ejbLocator, Map<String, Object> attachments) throws Throwable {
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setParameters(args);
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)componentView.getComponent());
        interceptorContext.putPrivateData(ComponentView.class, (Object)componentView);
        interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.REMOTE);
        HashMap<String, Object> invocationContextData = new HashMap<String, Object>();
        interceptorContext.setContextData(invocationContextData);
        if (attachments != null) {
            for (Map.Entry<String, Object> attachment : attachments.entrySet()) {
                if (attachment == null) continue;
                String key = attachment.getKey();
                Object value = attachment.getValue();
                if ("org.jboss.ejb.client.invocation.attachments".equals(key)) {
                    Map privateAttachments = (Map)value;
                    for (Map.Entry privateAttachment : privateAttachments.entrySet()) {
                        interceptorContext.putPrivateData(privateAttachment.getKey(), privateAttachment.getValue());
                    }
                    continue;
                }
                invocationContextData.put(key, value);
            }
        }
        if (ejbLocator instanceof StatefulEJBLocator) {
            interceptorContext.putPrivateData(SessionID.class, (Object)((StatefulEJBLocator)ejbLocator).getSessionId());
        } else if (ejbLocator instanceof EntityEJBLocator) {
            Object primaryKey = ((EntityEJBLocator)ejbLocator).getPrimaryKey();
            interceptorContext.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKey);
        }
        if (componentView.isAsynchronous(method)) {
            Component component = componentView.getComponent();
            if (!(component instanceof SessionBeanComponent)) {
                EjbLogger.EJB3_LOGGER.asyncMethodSupportedOnlyForSessionBeans(component.getComponentClass(), method);
                return componentView.invoke(interceptorContext);
            }
            CancellationFlag asyncInvocationCancellationFlag = new CancellationFlag();
            interceptorContext.putPrivateData(CancellationFlag.class, (Object)asyncInvocationCancellationFlag);
            this.remoteAsyncInvocationCancelStatus.registerAsyncInvocation(invocationId, asyncInvocationCancellationFlag);
            try {
                Object v = ((Future)componentView.invoke(interceptorContext)).get();
                return v;
            }
            finally {
                this.remoteAsyncInvocationCancelStatus.asyncInvocationDone(invocationId);
            }
        }
        return componentView.invoke(interceptorContext);
    }

    private Method findMethod(ComponentView componentView, String methodName, String[] paramTypes) {
        Set viewMethods = componentView.getViewMethods();
        for (Method method : viewMethods) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(methodName) || (methodParamTypes = method.getParameterTypes()).length != paramTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (methodParamTypes[i].getName().equals(paramTypes[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodInvocationResponse(ChannelAssociation channelAssociation, short invocationId, Object result, Map<String, Object> attachments) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        try {
            outputStream.write(5);
            outputStream.writeShort(invocationId);
            Marshaller marshaller = this.prepareForMarshalling(this.marshallerFactory, outputStream);
            marshaller.writeObject(result);
            this.writeAttachments((ObjectOutput)marshaller, attachments);
            marshaller.finish();
        }
        finally {
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAsyncMethodNotification(ChannelAssociation channelAssociation, short invocationId) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        try {
            outputStream.write(14);
            outputStream.writeShort(invocationId);
        }
        finally {
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    private class ClassLoaderSwitchingClassResolver
    extends AbstractClassResolver {
        private ClassLoader currentClassLoader;

        ClassLoaderSwitchingClassResolver(ClassLoader classLoader) {
            this.currentClassLoader = classLoader;
        }

        void switchClassLoader(ClassLoader newCL) {
            this.currentClassLoader = newCL;
        }

        protected ClassLoader getClassLoader() {
            return this.currentClassLoader;
        }
    }
}

