/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TimerAttributeDefinition
extends ListAttributeDefinition {
    public static final TimerAttributeDefinition INSTANCE = new TimerAttributeDefinition();
    public static final String TIME_REMAINING = "time-remaining";
    public static final String NEXT_TIMEOUT = "next-timeout";
    public static final String CALENDAR_TIMER = "calendar-timer";
    public static final String PERSISTENT = "persistent";
    public static final String SCHEDULE = "schedule";
    public static final String DAY_OF_MONTH = "day-of-month";
    public static final String DAY_OF_WEEK = "day-of-week";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String SECOND = "second";
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    public static final String TIMEZONE = "timezone";
    public static final String START = "start";
    public static final String END = "end";

    private TimerAttributeDefinition() {
        super("timers", false, (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT), new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME});
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        throw EjbMessages.MESSAGES.resourceBundleDescriptionsNotSupported(this.getName());
    }

    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.addValueTypeDescription(node, resolver, locale, bundle2);
    }

    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.addValueTypeDescription(node, resolver, locale, bundle2);
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        throw EjbMessages.MESSAGES.runtimeAttributeNotMarshallable(this.getName());
    }

    private void addValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueTypeNode = node.get("value-type");
        this.addAttributeDescription(resolver, locale, bundle2, valueTypeNode, ModelType.LONG, true, MeasurementUnit.MILLISECONDS, TIME_REMAINING);
        this.addAttributeDescription(resolver, locale, bundle2, valueTypeNode, ModelType.LONG, true, MeasurementUnit.EPOCH_MILLISECONDS, NEXT_TIMEOUT);
        this.addAttributeDescription(resolver, locale, bundle2, valueTypeNode, ModelType.BOOLEAN, true, null, CALENDAR_TIMER);
        this.addAttributeDescription(resolver, locale, bundle2, valueTypeNode, ModelType.BOOLEAN, true, null, PERSISTENT);
        ModelNode sched = this.addAttributeDescription(resolver, locale, bundle2, valueTypeNode, ModelType.OBJECT, true, null, SCHEDULE);
        ModelNode schedValType = sched.get("value-type");
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, YEAR);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, MONTH);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, DAY_OF_MONTH);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, DAY_OF_WEEK);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, HOUR);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, MINUTE);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, SECOND);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.STRING, true, null, SCHEDULE, TIMEZONE);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.LONG, true, MeasurementUnit.EPOCH_MILLISECONDS, SCHEDULE, START);
        this.addAttributeDescription(resolver, locale, bundle2, schedValType, ModelType.LONG, true, MeasurementUnit.EPOCH_MILLISECONDS, SCHEDULE, END);
    }

    private ModelNode addAttributeDescription(ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2, ModelNode node, ModelType type, boolean nillable, MeasurementUnit measurementUnit, String ... suffixes) {
        ModelNode valNode = node.get(suffixes[suffixes.length - 1]);
        valNode.get("description").set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, suffixes));
        valNode.get("type").set(type);
        valNode.get("nillable").set(nillable);
        if (measurementUnit != null) {
            valNode.get("unit").set(measurementUnit.getName());
        }
        return valNode;
    }

    public static void addTimers(EJBComponent ejb, ModelNode response) {
        response.setEmptyList();
        String name = ejb.getComponentName();
        TimerService ts = ejb.getTimerService();
        if (ts != null) {
            for (Timer timer : ts.getTimers()) {
                ModelNode timerNode = response.add();
                TimerAttributeDefinition.addTimeRemaining(timer, timerNode, name);
                TimerAttributeDefinition.addNextTimeout(timer, timerNode, name);
                TimerAttributeDefinition.addCalendarTimer(timer, timerNode, name);
                TimerAttributeDefinition.addPersistent(timer, timerNode, name);
                TimerAttributeDefinition.addSchedule(timer, timerNode, name);
            }
        }
    }

    private static void addTimeRemaining(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(TIME_REMAINING);
            long time = timer.getTimeRemaining();
            detailNode.set(time);
        }
        catch (IllegalStateException e) {
        }
        catch (NoSuchObjectLocalException e) {
        }
        catch (EJBException e) {
            TimerAttributeDefinition.logTimerFailure(componentName, e);
        }
    }

    private static void addNextTimeout(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(NEXT_TIMEOUT);
            Date d = timer.getNextTimeout();
            if (d != null) {
                detailNode.set(d.getTime());
            }
        }
        catch (IllegalStateException e) {
        }
        catch (NoSuchObjectLocalException e) {
        }
        catch (EJBException e) {
            TimerAttributeDefinition.logTimerFailure(componentName, e);
        }
    }

    private static void addSchedule(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode schedNode = timerNode.get(SCHEDULE);
            ScheduleExpression sched = timer.getSchedule();
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getYear(), YEAR);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getMonth(), MONTH);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getDayOfMonth(), DAY_OF_MONTH);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getDayOfWeek(), DAY_OF_WEEK);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getHour(), HOUR);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getMinute(), MINUTE);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getSecond(), SECOND);
            TimerAttributeDefinition.addScheduleDetailString(schedNode, sched.getTimezone(), TIMEZONE);
            TimerAttributeDefinition.addScheduleDetailDate(schedNode, sched.getStart(), START);
            TimerAttributeDefinition.addScheduleDetailDate(schedNode, sched.getEnd(), END);
        }
        catch (IllegalStateException e) {
        }
        catch (NoSuchObjectLocalException e) {
        }
        catch (EJBException e) {
            TimerAttributeDefinition.logTimerFailure(componentName, e);
        }
    }

    private static void addCalendarTimer(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(CALENDAR_TIMER);
            boolean b = timer.isCalendarTimer();
            detailNode.set(b);
        }
        catch (IllegalStateException e) {
        }
        catch (NoSuchObjectLocalException e) {
        }
        catch (EJBException e) {
            TimerAttributeDefinition.logTimerFailure(componentName, e);
        }
    }

    private static void addPersistent(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(PERSISTENT);
            boolean b = timer.isPersistent();
            detailNode.set(b);
        }
        catch (IllegalStateException e) {
        }
        catch (NoSuchObjectLocalException e) {
        }
        catch (EJBException e) {
            TimerAttributeDefinition.logTimerFailure(componentName, e);
        }
    }

    private static void addScheduleDetailString(ModelNode schedNode, String value, String detailName) {
        ModelNode node = schedNode.get(detailName);
        if (value != null) {
            node.set(value);
        }
    }

    private static void addScheduleDetailDate(ModelNode schedNode, Date value, String detailName) {
        ModelNode node = schedNode.get(detailName);
        if (value != null) {
            node.set(value.getTime());
        }
    }

    private static void logTimerFailure(String componentName, EJBException e) {
        EjbLogger.ROOT_LOGGER.failToReadTimerInformation(componentName);
    }
}

