/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.security.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.RealmUser;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.as.domain.management.security.SubjectSupplemental;

public class AuthenticationProvider {
    private final SecurityRealm securityRealm;

    public AuthenticationProvider(SecurityRealm securityRealm) {
        this.securityRealm = securityRealm;
    }

    AuthorizingCallbackHandler getCallbackHandler() {
        final DomainCallbackHandler callbackHandler = this.securityRealm.getCallbackHandler();
        return new AuthorizingCallbackHandler(){
            Subject subject;

            public Class<Callback>[] getSupportedCallbacks() {
                return callbackHandler.getSupportedCallbacks();
            }

            public boolean isReady() {
                return callbackHandler.isReady();
            }

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (AuthenticationProvider.contains(SubjectCallback.class, callbackHandler.getSupportedCallbacks())) {
                    Callback[] newCallbacks = new Callback[callbacks.length + 1];
                    System.arraycopy(callbacks, 0, newCallbacks, 0, callbacks.length);
                    SubjectCallback subjectCallBack = new SubjectCallback();
                    newCallbacks[newCallbacks.length - 1] = subjectCallBack;
                    callbackHandler.handle(newCallbacks);
                    this.subject = subjectCallBack.getSubject();
                } else {
                    callbackHandler.handle(callbacks);
                }
            }

            @Override
            public SubjectUserInfo createSubjectUserInfo(Principal userPrincipal) throws IOException {
                Subject subject = this.subject == null ? new Subject() : this.subject;
                Set<Principal> allPrincipals = subject.getPrincipals();
                allPrincipals.add(userPrincipal);
                allPrincipals.add((Principal)new RealmUser(AuthenticationProvider.this.securityRealm.getName(), userPrincipal.getName()));
                SubjectSupplemental subjectSupplemental = AuthenticationProvider.this.securityRealm.getSubjectSupplemental();
                if (subjectSupplemental != null) {
                    subjectSupplemental.supplementSubject(subject);
                }
                return new HttpSubjectUserInfo(subject);
            }
        };
    }

    private static boolean contains(Class clazz, Class<Callback>[] classes) {
        for (Class<Callback> current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static class HttpSubjectUserInfo
    implements SubjectUserInfo {
        private final String userName;
        private final Subject subject;

        private HttpSubjectUserInfo(Subject subject) {
            this.subject = subject;
            Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
            this.userName = users.isEmpty() ? null : users.iterator().next().getName();
        }

        public String getUserName() {
            return this.userName;
        }

        public Collection<Principal> getPrincipals() {
            return this.subject.getPrincipals();
        }

        public Subject getSubject() {
            return this.subject;
        }
    }
}

