/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.management.persistence.ExchangeData;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class PersistInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public PersistInInterceptor() {
        super("receive");
    }

    private void getSoapRequest(Message soapMessage, ExchangeData exchange) {
        InputStream is = (InputStream)soapMessage.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
                is.close();
                soapMessage.setContent(InputStream.class, (Object)bos.getInputStream());
                StringBuilder builder = new StringBuilder();
                bos.writeCacheTo(builder, bos.size());
                bos.close();
                exchange.setRequest(builder.toString());
                exchange.setRequestSize(bos.size());
            }
            catch (IOException e) {
                throw new Fault((Throwable)e);
            }
        }
    }

    public void handleMessage(Message message) throws Fault {
        ExchangeData soapExchange = new ExchangeData();
        soapExchange.setInDate(new Date());
        message.setContent(ExchangeData.class, (Object)soapExchange);
        this.getSoapRequest(message, soapExchange);
    }
}

