/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.picketlink.idm.test.support.NoSuchElementException;
import org.picketlink.idm.test.support.TooManyElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLTools {
    public static final String XML_LANG_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    private static final DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Properties DEFAULT_FORMAT = XMLTools.createFormat(true, false, true, "utf-8");
    public static final String PARAM_YES = "yes";
    public static final String PARAM_NO = "no";
    public static final String ATTRIB_OMIT_XML_DECLARATION = "omit-xml-declaration";
    public static final String ATTRIB_CDATA_SECTION_ELEMENTS = "cdata-section-elements";
    public static final String ATTRIB_METHOD = "method";
    public static final String ATTRIB_INDENT = "indent";
    public static final String ATTRIB_HREF = "href";
    public static final String DIRECTIVE_IMPORT = "xsl:import";
    public static final String DIRECTIVE_INCLUDE = "xsl:include";
    public static final boolean DEFAULT_NAMESPACE_AWARE = true;
    public static final boolean DEFAULT_VALIDATION = false;

    private XMLTools() {
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return buildFactory;
    }

    private static Properties createFormat(boolean omitXMLDeclaration, boolean standalone, boolean indented, String encoding) {
        Properties format = new Properties();
        format.setProperty(ATTRIB_OMIT_XML_DECLARATION, omitXMLDeclaration ? PARAM_YES : PARAM_NO);
        format.setProperty("standalone", standalone ? PARAM_YES : PARAM_NO);
        format.setProperty(ATTRIB_INDENT, indented ? PARAM_YES : PARAM_NO);
        format.setProperty("encoding", encoding);
        return format;
    }

    public static String toString(Document doc, boolean omitXMLDeclaration, boolean standalone, boolean indented, String encoding) throws TransformerException {
        Properties format = XMLTools.createFormat(omitXMLDeclaration, standalone, indented, encoding);
        return XMLTools.toString(doc, format);
    }

    public static String toString(Document doc) throws TransformerException {
        return XMLTools.toString(doc, DEFAULT_FORMAT);
    }

    public static String toString(Element element) throws ParserConfigurationException, TransformerException {
        return XMLTools.toString(element, DEFAULT_FORMAT);
    }

    private static String toString(Element element, Properties properties) throws ParserConfigurationException, TransformerException {
        Document doc = buildFactory.newDocumentBuilder().newDocument();
        element = (Element)doc.importNode(element, true);
        doc.appendChild(element);
        return XMLTools.toString(doc, properties);
    }

    private static String toString(Document doc, Properties format) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperties(format);
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    public static Document toDocument(String text) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = buildFactory.newDocumentBuilder();
        StringReader reader = new StringReader(text);
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return builder.parse(source);
    }

    public static Element toElement(String text) throws ParserConfigurationException, SAXException, IOException {
        Document doc = XMLTools.toDocument(text);
        return doc.getDocumentElement();
    }

    public static Document toDocument(Element element) throws ParserConfigurationException, SAXException, IOException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Document doc = buildFactory.newDocumentBuilder().newDocument();
        element = (Element)doc.importNode(element, true);
        doc.appendChild(element);
        return doc;
    }

    public static String asString(Element element) throws IllegalArgumentException {
        return XMLTools.asString(element, true);
    }

    public static String asString(Element element, boolean trim) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("No null element allowed");
        }
        StringBuffer buffer = new StringBuffer();
        NodeList children = element.getChildNodes();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    buffer.append(((Text)child).getData());
                    continue block4;
                }
                case 1: {
                    throw new IllegalArgumentException("Mixed content not allowed");
                }
            }
        }
        String result = buffer.toString();
        if (trim) {
            result = result.trim();
        }
        return result;
    }

    public static Element getUniqueChild(Element element, boolean strict) throws IllegalArgumentException, NoSuchElementException, TooManyElementException {
        if (element == null) {
            throw new IllegalArgumentException("No element specified");
        }
        Element childElt = null;
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (!(childNode instanceof Element)) continue;
            if (childElt == null) {
                childElt = (Element)childNode;
                continue;
            }
            throw new TooManyElementException("More than one child element for element " + element.getNodeName());
        }
        if (strict && childElt == null) {
            throw new NoSuchElementException("No child element for element " + element.getNodeName());
        }
        return childElt;
    }

    public static Element getUniqueChild(Element element, String name, boolean strict) throws IllegalArgumentException, NoSuchElementException, TooManyElementException {
        return XMLTools.getUniqueChild(element, null, name, strict);
    }

    public static Element getUniqueChild(Element element, String uri, String name, boolean strict) throws IllegalArgumentException, NoSuchElementException, TooManyElementException {
        List<Element> list = XMLTools.getChildren(element, uri, name);
        switch (list.size()) {
            case 0: {
                if (strict) {
                    throw new NoSuchElementException("Missing child " + name + " of element " + element.getNodeName());
                }
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new TooManyElementException("Too many children for element " + element.getNodeName());
    }

    public static Iterator<Element> getChildrenIterator(Element element, String name) throws IllegalArgumentException {
        return XMLTools.getChildren(element, name).iterator();
    }

    public static Iterator<Element> getChildrenIterator(Element element, String uri, String name) throws IllegalArgumentException {
        return XMLTools.getChildren(element, uri, name).iterator();
    }

    public static List<Element> getChildren(Element element, String name) throws IllegalArgumentException {
        return XMLTools.getChildren(element, null, name);
    }

    public static List<Element> getChildren(Element element, String uri, String name) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("No element found");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElt = (Element)node;
            if (uri == null) {
                if (!childElt.getTagName().equals(name)) continue;
                result.add(childElt);
                continue;
            }
            if (!uri.equals(childElt.getNamespaceURI()) || !childElt.getLocalName().equals(name)) continue;
            result.add(childElt);
        }
        return result;
    }

    public static Properties loadXMLProperties(Element propertiesElt) {
        if (propertiesElt == null) {
            throw new IllegalArgumentException();
        }
        Properties props = new Properties();
        for (Element entryElt : XMLTools.getChildren(propertiesElt, "entry")) {
            String key = entryElt.getAttribute("key");
            String value = XMLTools.asString(entryElt);
            props.put(key, value);
        }
        return props;
    }

    public static Properties loadXMLProperties(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        return XMLTools.loadXMLProperties(doc.getDocumentElement());
    }
}

