/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.Attachable;
import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachedDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentPhaseContextImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.ListAttachmentKey;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.RegisteredDeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.DelegatingServiceRegistry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class DeploymentUnitPhaseService<T>
implements Service<T> {
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private final DeploymentUnit deploymentUnit;
    private final Phase phase;
    private final AttachmentKey<T> valueKey;
    private final List<AttachedDependency> injectedAttachedDependencies = new ArrayList<AttachedDependency>();

    private DeploymentUnitPhaseService(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        this.deploymentUnit = deploymentUnit;
        this.phase = phase;
        this.valueKey = valueKey;
    }

    private static <T> DeploymentUnitPhaseService<T> create(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        return new DeploymentUnitPhaseService<T>(deploymentUnit, phase, valueKey);
    }

    static DeploymentUnitPhaseService<?> create(DeploymentUnit deploymentUnit, Phase phase) {
        return DeploymentUnitPhaseService.create(deploymentUnit, phase, phase.getPhaseKey());
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceBuilder phaseServiceBuilder;
        DeploymentUnitPhaseService<?> phaseService;
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        DeploymentUnit deploymentUnit = this.deploymentUnit;
        List<RegisteredDeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<RegisteredDeploymentUnitProcessor> iterator = list.listIterator();
        ServiceContainer container = context.getController().getServiceContainer();
        ServiceTarget serviceTarget = context.getChildTarget().subTarget();
        Phase nextPhase = this.phase.next();
        String name = deploymentUnit.getName();
        DeploymentUnit parent = deploymentUnit.getParent();
        if (nextPhase != null) {
            ServiceName serviceName = parent == null ? Services.deploymentUnitName(name, nextPhase) : Services.deploymentUnitName(parent.getName(), name, nextPhase);
            phaseService = DeploymentUnitPhaseService.create(deploymentUnit, nextPhase);
            phaseServiceBuilder = serviceTarget.addService(serviceName, phaseService);
        } else {
            phaseServiceBuilder = null;
            phaseService = null;
        }
        DeploymentPhaseContextImpl processorContext = new DeploymentPhaseContextImpl(serviceTarget, (ServiceRegistry)new DelegatingServiceRegistry((ServiceRegistry)container), phaseServiceBuilder, deploymentUnit, this.phase);
        for (AttachedDependency attachedDependency : this.injectedAttachedDependencies) {
            Attachable target = attachedDependency.isDeploymentUnit() ? deploymentUnit : processorContext;
            if (attachedDependency.getAttachmentKey() instanceof ListAttachmentKey) {
                target.addToAttachmentList(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
                continue;
            }
            target.putAttachment(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
        }
        while (iterator.hasNext()) {
            RegisteredDeploymentUnitProcessor processor = iterator.next();
            try {
                if (!DeploymentUnitPhaseService.shouldRun(deploymentUnit, processor)) continue;
                processor.getProcessor().deploy(processorContext);
            }
            catch (Throwable e) {
                while (iterator.hasPrevious()) {
                    RegisteredDeploymentUnitProcessor prev = iterator.previous();
                    DeploymentUnitPhaseService.safeUndeploy(deploymentUnit, this.phase, prev);
                }
                throw ServerMessages.MESSAGES.deploymentPhaseFailed(this.phase, deploymentUnit, e);
            }
        }
        if (nextPhase != null) {
            List nextPhaseAttachableDeps;
            phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
            phaseServiceBuilder.addDependency(context.getController().getName());
            List nextPhaseDeps = processorContext.getAttachment(Attachments.NEXT_PHASE_DEPS);
            if (nextPhaseDeps != null) {
                phaseServiceBuilder.addDependencies((Iterable)nextPhaseDeps);
            }
            if ((nextPhaseAttachableDeps = (List)processorContext.getAttachment(Attachments.NEXT_PHASE_ATTACHABLE_DEPS)) != null) {
                for (AttachableDependency attachableDep : nextPhaseAttachableDeps) {
                    AttachedDependency result = new AttachedDependency(attachableDep.getAttachmentKey(), attachableDep.isDeploymentUnit());
                    phaseServiceBuilder.addDependency(attachableDep.getServiceName(), result.getValue());
                    phaseService.injectedAttachedDependencies.add(result);
                }
            }
            if (deploymentUnit.getParent() != null) {
                phaseServiceBuilder.addDependencies(new ServiceName[]{Services.deploymentUnitName(deploymentUnit.getParent().getName(), nextPhase)});
            }
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit du : subDeployments) {
                phaseServiceBuilder.addDependencies(new ServiceName[]{du.getServiceName().append(new String[]{this.phase.name()})});
            }
            phaseServiceBuilder.install();
        }
    }

    public synchronized void stop(StopContext context) {
        DeploymentUnit deploymentUnitContext = this.deploymentUnit;
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        List<RegisteredDeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<RegisteredDeploymentUnitProcessor> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            RegisteredDeploymentUnitProcessor prev = iterator.previous();
            DeploymentUnitPhaseService.safeUndeploy(deploymentUnitContext, this.phase, prev);
        }
    }

    private static void safeUndeploy(DeploymentUnit deploymentUnit, Phase phase, RegisteredDeploymentUnitProcessor prev) {
        try {
            if (DeploymentUnitPhaseService.shouldRun(deploymentUnit, prev)) {
                prev.getProcessor().undeploy(deploymentUnit);
            }
        }
        catch (Throwable t) {
            ServerLogger.DEPLOYMENT_LOGGER.caughtExceptionUndeploying(t, prev.getProcessor(), phase, deploymentUnit);
        }
    }

    public synchronized T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit.getAttachment(this.valueKey);
    }

    InjectedValue<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }

    private static boolean shouldRun(DeploymentUnit unit, RegisteredDeploymentUnitProcessor deployer) {
        Set<String> shouldNotRun = unit.getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
        if (shouldNotRun == null) {
            if (unit.getParent() != null) {
                shouldNotRun = unit.getParent().getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
            }
            if (shouldNotRun == null) {
                return true;
            }
        }
        return !shouldNotRun.contains(deployer.getSubsystemName());
    }
}

