/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b) {
        return this.putByte(b ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public final Hasher putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public Hasher putString(CharSequence charSequence) {
        return this.putString(charSequence, Charsets.UTF_16LE);
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        try {
            return this.putBytes(((Object)charSequence).toString().getBytes(charset.name()));
        }
        catch (UnsupportedEncodingException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }
}

