/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public abstract class AbstractLogoutFilter
extends AbstractSSOInterceptor {
    protected String logoutUrl;
    private static final String fileEncoding = System.getProperty("file.encoding");
    protected static final String SSO_LOGOUT_FLAG = "SSO_LOGOUT_FLAG";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void initImpl() {
        this.logoutUrl = this.getInitParameter("LOGOUT_URL");
        this.log.info((Object)("Reading filter configuration: logoutUrl=" + this.logoutUrl));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean redirectionSent;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isLogoutInProgress = this.isLogoutInProgress(httpRequest);
        if (isLogoutInProgress && (redirectionSent = this.handleLogout(httpRequest, httpResponse))) {
            return;
        }
        chain.doFilter(request, response);
    }

    protected boolean isLogoutInProgress(HttpServletRequest request) throws UnsupportedEncodingException {
        String action;
        if (fileEncoding != null) {
            request.setCharacterEncoding(fileEncoding);
        }
        return (action = request.getParameter("portal:action")) != null && action.equals("Logout");
    }

    protected boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (httpRequest.getSession().getAttribute(SSO_LOGOUT_FLAG) == null) {
            httpRequest.getSession().setAttribute(SSO_LOGOUT_FLAG, (Object)Boolean.TRUE);
            String redirectUrl = this.getRedirectUrl(httpRequest);
            redirectUrl = httpResponse.encodeRedirectURL(redirectUrl);
            httpResponse.sendRedirect(redirectUrl);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Redirecting to SSO logout URL: " + redirectUrl));
            }
            return true;
        }
        httpRequest.getSession().removeAttribute(SSO_LOGOUT_FLAG);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"SSO logout performed and SSO_LOGOUT_FLAG removed from session. Continue with portal logout");
        }
        return false;
    }

    protected abstract String getRedirectUrl(HttpServletRequest var1);
}

