/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.remoting.AbstractMessageWriter;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;

class MethodInvocationMessageWriter
extends AbstractMessageWriter {
    private static final byte METHOD_INVOCATION_HEADER = 3;
    private static final char METHOD_PARAM_TYPE_SEPARATOR = ',';
    private final MarshallerFactory marshallerFactory;

    MethodInvocationMessageWriter(MarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    void writeMessage(DataOutput output, short invocationId, EJBClientInvocationContext invocationContext) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null output");
        }
        Method invokedMethod = invocationContext.getInvokedMethod();
        Object[] methodParams = invocationContext.getParameters();
        output.writeByte(3);
        output.writeShort(invocationId);
        output.writeUTF(invokedMethod.getName());
        Class<?>[] methodParamTypes = invokedMethod.getParameterTypes();
        StringBuilder methodSignature = new StringBuilder();
        for (int i = 0; i < methodParamTypes.length; ++i) {
            methodSignature.append(methodParamTypes[i].getName());
            if (i == methodParamTypes.length - 1) continue;
            methodSignature.append(',');
        }
        output.writeUTF(methodSignature.toString());
        Marshaller marshaller = this.prepareForMarshalling(this.marshallerFactory, output);
        EJBLocator<?> locator = invocationContext.getLocator();
        marshaller.writeObject(locator.getAppName());
        marshaller.writeObject(locator.getModuleName());
        marshaller.writeObject(locator.getDistinctName());
        marshaller.writeObject(locator.getBeanName());
        marshaller.writeObject(locator);
        if (methodParams != null && methodParams.length > 0) {
            for (Object methodParam : methodParams) {
                marshaller.writeObject(methodParam);
            }
        }
        this.writeAttachments(marshaller, invocationContext);
        marshaller.finish();
    }

    @Override
    byte getHeader() {
        return 3;
    }
}

