/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedChannel;

public final class ChannelListeners {
    private static final ChannelListener<Channel> NULL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
        }
    };
    private static final ChannelListener.Setter<?> NULL_SETTER = new ChannelListener.Setter<Channel>(){

        @Override
        public void set(ChannelListener<? super Channel> channelListener) {
        }
    };
    private static final Logger listenerLog = Logger.getLogger("org.xnio.listener");
    private static ChannelListener<Channel> CLOSING_CHANNEL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            IoUtils.safeClose(channel);
        }
    };

    private ChannelListeners() {
    }

    public static <T extends Channel> boolean invokeChannelListener(T channel, ChannelListener<? super T> channelListener) {
        if (channelListener != null) {
            try {
                listenerLog.tracef("Invoking listener %s on channel %s", (Object)channelListener, (Object)channel);
                channelListener.handleEvent(channel);
            }
            catch (Throwable t) {
                listenerLog.errorf(t, "A channel event listener threw an exception", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public static <T extends Channel> void invokeChannelListener(Executor executor, T channel, ChannelListener<? super T> channelListener) {
        try {
            executor.execute(ChannelListeners.getChannelListenerTask(channel, channelListener));
        }
        catch (RejectedExecutionException ree) {
            ChannelListeners.invokeChannelListener(channel, channelListener);
        }
    }

    public static <T extends Channel> Runnable getChannelListenerTask(final T channel, final ChannelListener<? super T> channelListener) {
        return new Runnable(){

            @Override
            public void run() {
                ChannelListeners.invokeChannelListener(channel, channelListener);
            }
        };
    }

    public static ChannelListener<Channel> closingChannelListener() {
        return CLOSING_CHANNEL_LISTENER;
    }

    public static ChannelListener<Channel> nullChannelListener() {
        return NULL_LISTENER;
    }

    public static <C extends ConnectedChannel> ChannelListener<AcceptingChannel<C>> openListenerAdapter(final ChannelListener<? super C> openListener) {
        if (openListener == null) {
            throw new IllegalArgumentException("openListener is null");
        }
        return new ChannelListener<AcceptingChannel<C>>(){

            @Override
            public void handleEvent(AcceptingChannel<C> channel) {
                try {
                    Object accepted = channel.accept();
                    if (accepted != null) {
                        ChannelListeners.invokeChannelListener(accepted, openListener);
                    }
                }
                catch (IOException e) {
                    listenerLog.errorf("Failed to accept a connection on %s: %s", (Object)channel, (Object)e);
                }
            }

            public String toString() {
                return "Accepting listener for " + openListener;
            }
        };
    }

    public static <T extends Channel, C> ChannelListener.Setter<T> getSetter(final C channel, final AtomicReferenceFieldUpdater<C, ChannelListener> updater) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                updater.set(channel, channelListener);
            }
        };
    }

    public static <T extends Channel> ChannelListener.Setter<T> getSetter(final AtomicReference<ChannelListener<? super T>> atomicReference) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                atomicReference.set(channelListener);
            }
        };
    }

    public static <T extends Channel> ChannelListener.Setter<T> getDelegatingSetter(ChannelListener.Setter<? extends Channel> target, T realChannel) {
        return target == null ? null : ChannelListeners.delegatingSetter(target, realChannel);
    }

    private static <T extends Channel, O extends Channel> DelegatingSetter<T, O> delegatingSetter(ChannelListener.Setter<O> setter, T realChannel) {
        return new DelegatingSetter<T, O>(setter, realChannel);
    }

    public static <T extends Channel> ChannelListener.Setter<T> nullSetter() {
        return NULL_SETTER;
    }

    public static <T extends Channel> ChannelListener<T> executorChannelListener(final ChannelListener<T> listener, final Executor executor) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                try {
                    executor.execute(ChannelListeners.getChannelListenerTask(channel, listener));
                }
                catch (RejectedExecutionException e) {
                    listenerLog.errorf("Failed to submit task to executor: %s (closing %s)", (Object)e, channel);
                    IoUtils.safeClose(channel);
                }
            }
        };
    }

    private static class DelegatingChannelListener<T extends Channel, O extends Channel>
    implements ChannelListener<O> {
        private final ChannelListener<? super T> channelListener;
        private final T realChannel;

        public DelegatingChannelListener(ChannelListener<? super T> channelListener, T realChannel) {
            this.channelListener = channelListener;
            this.realChannel = realChannel;
        }

        @Override
        public void handleEvent(Channel channel) {
            this.channelListener.handleEvent(this.realChannel);
        }
    }

    private static class DelegatingSetter<T extends Channel, O extends Channel>
    implements ChannelListener.Setter<T> {
        private final ChannelListener.Setter<O> setter;
        private final T realChannel;

        DelegatingSetter(ChannelListener.Setter<O> setter, T realChannel) {
            this.setter = setter;
            this.realChannel = realChannel;
        }

        @Override
        public void set(ChannelListener<? super T> channelListener) {
            this.setter.set(channelListener == null ? null : new DelegatingChannelListener(channelListener, this.realChannel));
        }
    }
}

