/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.cot.COTException;
import com.sun.identity.workflow.AddProviderToCOT;
import com.sun.identity.workflow.ExportSAML2MetaData;
import com.sun.identity.workflow.FedletMetaData;
import com.sun.identity.workflow.ImportSAML2MetaData;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;

public class CreateFedlet
extends Task {
    private static Map fedletBits = new HashMap();
    private static Map FedConfigTagSwap = new HashMap();
    private static List FedConfigTagSwapOrder = new ArrayList();
    private static Map jarExtracts = new HashMap();

    public String execute(Locale locale, Map params) throws WorkflowException {
        this.validateParameters(params);
        String entityId = this.getString(params, "entityId");
        Pattern patern = Pattern.compile("[/:\\.?|*]");
        Matcher match = patern.matcher(entityId);
        String folderName = match.replaceAll("");
        String workDir = SystemProperties.get((String)"com.iplanet.services.configpath") + "/myfedlets/" + folderName;
        File dir = new File(workDir);
        if (dir.exists()) {
            Object[] param = new Object[]{workDir};
            throw new WorkflowException("directory.already.exist", param);
        }
        if (!dir.getParentFile().exists()) {
            dir.getParentFile().mkdir();
        }
        dir.mkdir();
        String warDir = workDir + "/war";
        dir = new File(warDir);
        dir.mkdir();
        String confDir = warDir + "/conf";
        dir = new File(confDir);
        dir.mkdir();
        this.loadMetaData(params, confDir);
        this.exportIDPMetaData(params, confDir);
        this.createCOTProperties(params, confDir);
        ServletContext servletCtx = (ServletContext)params.get("_servlet_context_");
        this.copyBits(servletCtx, workDir);
        this.extractJars(servletCtx, warDir);
        this.createFederationConfigProperties(servletCtx, confDir);
        this.createWar(workDir);
        String zipFileName = this.createZip(workDir);
        Object[] param = new Object[]{zipFileName};
        return MessageFormat.format(CreateFedlet.getMessage("Fedlet.created", locale), param);
    }

    private void copyBits(ServletContext servletCtx, String workDir) throws WorkflowException {
        String dir = workDir + "/war";
        new File(dir).mkdir();
        this.copyFile(servletCtx, "/WEB-INF/fedlet/README", workDir + "/README");
        for (String file : fedletBits.keySet()) {
            String target = (String)fedletBits.get(file);
            if (target == null || target.trim().length() == 0) {
                target = file;
            }
            this.copyFile(servletCtx, file, dir + "/" + target);
        }
    }

    private void extractJars(ServletContext servletCtx, String workDir) throws WorkflowException {
        Iterator i = jarExtracts.keySet().iterator();
        while (i.hasNext()) {
            ZipInputStream jis = null;
            ZipOutputStream zipOutputStream = null;
            try {
                String fileName = (String)i.next();
                Set pkgNames = (Set)jarExtracts.get(fileName);
                InputStream is = servletCtx.getResourceAsStream(fileName);
                jis = new JarInputStream(is);
                FileOutputStream fileOutputStream = new FileOutputStream(workDir + fileName);
                zipOutputStream = new JarOutputStream(fileOutputStream);
                JarEntry entry = ((JarInputStream)jis).getNextJarEntry();
                while (entry != null) {
                    int size = new Long(entry.getSize()).intValue();
                    if (size > 0) {
                        String name = entry.getName();
                        boolean bExtract = false;
                        Iterator j = pkgNames.iterator();
                        while (j.hasNext() && !bExtract) {
                            bExtract = name.startsWith((String)j.next());
                        }
                        if (bExtract) {
                            int readSize;
                            ((JarOutputStream)zipOutputStream).putNextEntry(entry);
                            byte[] b = new byte[size];
                            for (int tobeRead = size; (readSize = ((JarInputStream)jis).read(b, size - tobeRead, tobeRead)) != tobeRead; tobeRead -= readSize) {
                            }
                            zipOutputStream.write(b);
                        }
                    }
                    entry = ((JarInputStream)jis).getNextJarEntry();
                }
            }
            catch (IOException ex) {
                throw new WorkflowException(ex.getMessage());
            }
            finally {
                try {
                    if (jis != null) {
                        jis.close();
                    }
                    if (zipOutputStream == null) continue;
                    zipOutputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void copyFile(ServletContext servletCtx, String source, String dest) throws WorkflowException {
        block14: {
            File test = new File(dest);
            File parent = test.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream fos = null;
            InputStream src = null;
            try {
                src = servletCtx.getResourceAsStream(source);
                if (src != null) {
                    fos = new FileOutputStream(dest);
                    int length = 0;
                    byte[] bytes = new byte[1024];
                    while ((length = src.read(bytes)) != -1) {
                        fos.write(bytes, 0, length);
                    }
                    break block14;
                }
                Object[] param = new Object[]{source};
                throw new WorkflowException("file-not-found", param);
            }
            catch (IOException e) {
                throw new WorkflowException(e.getMessage());
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (src != null) {
                        src.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
    }

    private void createCOTProperties(Map params, String workDir) throws WorkflowException {
        String sp = this.getString(params, "entityId");
        String idp = this.getString(params, "idp");
        String cot = this.getString(params, "cot");
        String content = "cot-name=" + cot + "\n" + "sun-fm-cot-status=Active\n" + "sun-fm-trusted-providers=" + this.encodeVal(idp) + "," + this.encodeVal(sp) + "\n" + "sun-fm-saml2-readerservice-url=\n" + "sun-fm-saml2-writerservice-url=\n";
        CreateFedlet.writeToFile(workDir + "/fedlet.cot", content);
    }

    private void exportIDPMetaData(Map params, String workDir) throws WorkflowException {
        String realm = this.getString(params, "realm");
        String idp = this.getString(params, "idp");
        String metadata = ExportSAML2MetaData.exportStandardMeta(realm, idp, false);
        String extended = ExportSAML2MetaData.exportExtendedMeta(realm, idp);
        String extendedModified = CreateFedlet.flipHostedParameter(extended, false);
        CreateFedlet.writeToFile(workDir + "/idp-extended.xml", extendedModified);
        CreateFedlet.writeToFile(workDir + "/idp.xml", metadata);
    }

    private void loadMetaData(Map params, String workDir) throws WorkflowException {
        String realm = this.getString(params, "realm");
        String entityId = this.getString(params, "entityId");
        String cot = this.getString(params, "cot");
        String assertConsumer = this.getString(params, "assertionconsumer");
        List attrMapping = this.getAttributeMapping(params);
        String metadata = FedletMetaData.createStandardMetaData(entityId, assertConsumer);
        String extended = FedletMetaData.createExtendedMetaData(realm, entityId, attrMapping, assertConsumer);
        extended = this.addAttributeQueryTemplate(extended, cot);
        ImportSAML2MetaData.importData(realm, metadata, extended);
        if (cot != null && cot.length() > 0) {
            try {
                AddProviderToCOT.addToCOT(realm, cot, entityId);
            }
            catch (COTException e) {
                throw new WorkflowException(e.getMessage());
            }
            int idx = extended.indexOf("<Attribute name=\"cotlist\">");
            idx = extended.indexOf("</Attribute>", idx);
            extended = extended.substring(0, idx) + "<Value>" + cot + "</Value>" + extended.substring(idx);
        }
        String extendedModified = CreateFedlet.flipHostedParameter(extended, true);
        CreateFedlet.writeToFile(workDir + "/sp-extended.xml", extendedModified);
        CreateFedlet.writeToFile(workDir + "/sp.xml", metadata);
    }

    private void validateParameters(Map params) throws WorkflowException {
        String entityId = this.getString(params, "entityId");
        if (entityId == null || entityId.trim().length() == 0) {
            throw new WorkflowException("entityId-required", null);
        }
        String assertConsumer = this.getString(params, "assertionconsumer");
        if (assertConsumer == null || assertConsumer.trim().length() == 0) {
            throw new WorkflowException("assertion.consumer-required", null);
        }
        try {
            new URL(assertConsumer);
        }
        catch (MalformedURLException e) {
            throw new WorkflowException("assertion.consumer-invalid", null);
        }
        String cot = this.getString(params, "cot");
        if (cot == null || cot.trim().length() == 0) {
            throw new WorkflowException("missing-cot", null);
        }
        String realm = this.getString(params, "realm");
        if (realm == null || realm.trim().length() == 0) {
            throw new WorkflowException("missing-realm", null);
        }
    }

    private void createFederationConfigProperties(ServletContext servletCtx, String workDir) throws WorkflowException {
        String prop = this.getBitAsString(servletCtx, "/WEB-INF/fedlet/FederationConfig.properties");
        for (String k : FedConfigTagSwapOrder) {
            String v = (String)FedConfigTagSwap.get(k);
            prop = prop.replaceAll(k, v);
        }
        CreateFedlet.writeToFile(workDir + "/FederationConfig.properties", prop);
    }

    private String getBitAsString(ServletContext servletCtx, String bitName) throws WorkflowException {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            int len;
            in = servletCtx.getResourceAsStream(bitName);
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            String string = out.toString();
            return string;
        }
        catch (IOException ex) {
            throw new WorkflowException(ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void writeToFile(String fileName, String content) throws WorkflowException {
        FileWriter fout = null;
        try {
            fout = new FileWriter(fileName);
            fout.write(content);
        }
        catch (IOException e) {
            throw new WorkflowException(e.getMessage());
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static String flipHostedParameter(String xml, boolean bHosted) {
        int idx = xml.indexOf("<EntityConfig ");
        if (idx != -1 && (idx = xml.indexOf("hosted=\"", idx)) != -1) {
            int idx2 = xml.indexOf("\"", idx + 9);
            xml = bHosted ? xml.substring(0, idx + 8) + "1" + xml.substring(idx2) : xml.substring(0, idx + 8) + "0" + xml.substring(idx2);
        }
        return xml;
    }

    private void createWar(String workDir) throws WorkflowException {
        ZipOutputStream out = null;
        String warDir = workDir + "/war";
        int lenWorkDir = warDir.length() + 1;
        List files = this.getAllFiles(warDir, true);
        String jarName = workDir + "/fedlet.war";
        try {
            out = new JarOutputStream(new FileOutputStream(jarName));
            byte[] buf = new byte[1024];
            for (String fname : files) {
                int len;
                FileInputStream in = new FileInputStream(fname);
                String jarEntryName = fname.substring(lenWorkDir);
                if (File.separatorChar == '\\') {
                    jarEntryName = jarEntryName.replace('\\', '/');
                }
                ((JarOutputStream)out).putNextEntry(new JarEntry(jarEntryName));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            this.deleteAllFiles(warDir, files);
            new File(warDir).delete();
        }
        catch (IOException e) {
            throw new WorkflowException(e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private String createZip(String workDir) throws WorkflowException {
        int lenWorkDir = workDir.length() + 1;
        ZipOutputStream out = null;
        try {
            List files = this.getAllFiles(workDir, true);
            String zipName = workDir + "/Fedlet.zip";
            out = new ZipOutputStream(new FileOutputStream(zipName));
            byte[] buf = new byte[1024];
            for (String fname : files) {
                int len;
                FileInputStream in = new FileInputStream(fname);
                out.putNextEntry(new ZipEntry(fname.substring(lenWorkDir)));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            this.deleteAllFiles(workDir, files);
            String string = zipName;
            return string;
        }
        catch (IOException e) {
            throw new WorkflowException(e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private void deleteAllFiles(String workDir, List files) {
        for (String fname : files) {
            new File(fname).delete();
        }
        List dirs = this.getAllFiles(workDir, false);
        for (int i = dirs.size() - 1; i >= 0; --i) {
            String dirName = (String)dirs.get(i);
            File test = new File(dirName);
            if (!test.isDirectory()) continue;
            test.delete();
        }
    }

    private List getAllFiles(String dir, boolean bFileOnly) {
        ArrayList<String> list = new ArrayList<String>();
        File directory = new File(dir);
        String[] children = directory.list();
        for (int i = 0; i < children.length; ++i) {
            String child = dir + "/" + children[i];
            File f = new File(child);
            if (f.isDirectory()) {
                if (!bFileOnly) {
                    list.add(f.getAbsolutePath());
                }
                list.addAll(this.getAllFiles(f.getAbsolutePath(), bFileOnly));
                continue;
            }
            list.add(f.getAbsolutePath());
        }
        return list;
    }

    private String encodeVal(String v) {
        char[] chars = v.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 20);
        int i = 0;
        int lastIdx = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] == '%') {
                if (lastIdx != i) {
                    sb.append(chars, lastIdx, i - lastIdx);
                }
                sb.append("%25");
                lastIdx = i + 1;
                continue;
            }
            if (chars[i] != ',') continue;
            if (lastIdx != i) {
                sb.append(chars, lastIdx, i - lastIdx);
            }
            sb.append("%2C");
            lastIdx = i + 1;
        }
        if (lastIdx != i) {
            sb.append(chars, lastIdx, i - lastIdx);
        }
        return sb.toString();
    }

    private String addAttributeQueryTemplate(String extended, String cot) {
        StringBuffer buff = new StringBuffer();
        buff.append("    <AttributeQueryConfig metaAlias=\"/attrQuery\">\n        <Attribute name=\"signingCertAlias\">\n            <Value></Value>\n        </Attribute>\n        <Attribute name=\"encryptionCertAlias\">\n            <Value></Value>\n        </Attribute>\n        <Attribute name=\"cotlist\">\n            <Value>" + cot + "</Value>\n" + "        </Attribute>\n" + "    </AttributeQueryConfig>\n");
        int idx = extended.indexOf("</EntityConfig>");
        if (idx != -1) {
            extended = extended.substring(0, idx) + buff.toString() + "</EntityConfig>";
        }
        return extended;
    }

    static {
        FedConfigTagSwap.put("@CONFIGURATION_PROVIDER_CLASS@", "com.sun.identity.plugin.configuration.impl.FedletConfigurationImpl");
        FedConfigTagSwap.put("@DATASTORE_PROVIDER_CLASS@", "com.sun.identity.plugin.datastore.impl.FedletDataStoreProvider");
        FedConfigTagSwap.put("@LOG_PROVIDER_CLASS@", "com.sun.identity.plugin.log.impl.FedletLogger");
        FedConfigTagSwap.put("@SESSION_PROVIDER_CLASS@", "com.sun.identity.plugin.session.impl.FedletSessionProvider");
        FedConfigTagSwap.put("@XML_SIGNATURE_PROVIDER@", "com.sun.identity.saml.xmlsig.AMSignatureProvider");
        FedConfigTagSwap.put("@XMLSIG_KEY_PROVIDER@", "com.sun.identity.saml.xmlsig.JKSKeyProvider");
        FedConfigTagSwap.put("%BASE_DIR%%SERVER_URI%", "@FEDLET_HOME@");
        FedConfigTagSwap.put("%BASE_DIR%", "@FEDLET_HOME@");
        FedConfigTagSwap.put("com.sun.identity.common.serverMode=true", "com.sun.identity.common.serverMode=false");
        FedConfigTagSwap.put("@SERVER_PROTO@", "http");
        FedConfigTagSwap.put("@SERVER_HOST@", "example.identity.sun.com");
        FedConfigTagSwap.put("@SERVER_PORT@", "80");
        FedConfigTagSwap.put("/@SERVER_URI@", "/fedlet");
        FedConfigTagSwapOrder.add("@CONFIGURATION_PROVIDER_CLASS@");
        FedConfigTagSwapOrder.add("@DATASTORE_PROVIDER_CLASS@");
        FedConfigTagSwapOrder.add("@LOG_PROVIDER_CLASS@");
        FedConfigTagSwapOrder.add("@SESSION_PROVIDER_CLASS@");
        FedConfigTagSwapOrder.add("@XML_SIGNATURE_PROVIDER@");
        FedConfigTagSwapOrder.add("@XMLSIG_KEY_PROVIDER@");
        FedConfigTagSwapOrder.add("%BASE_DIR%%SERVER_URI%");
        FedConfigTagSwapOrder.add("%BASE_DIR%");
        FedConfigTagSwapOrder.add("com.sun.identity.common.serverMode=true");
        FedConfigTagSwapOrder.add("@SERVER_PROTO@");
        FedConfigTagSwapOrder.add("@SERVER_HOST@");
        FedConfigTagSwapOrder.add("@SERVER_PORT@");
        FedConfigTagSwapOrder.add("/@SERVER_URI@");
        ResourceBundle rb = ResourceBundle.getBundle("fedletBits");
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            fedletBits.put(k, rb.getObject(k));
        }
        rb = ResourceBundle.getBundle("fedletJarExtract");
        e = rb.getKeys();
        while (e.hasMoreElements()) {
            String jarName = e.nextElement();
            String pkgNames = rb.getString(jarName);
            StringTokenizer st = new StringTokenizer(pkgNames, ",");
            HashSet<String> set = new HashSet<String>();
            while (st.hasMoreElements()) {
                set.add(st.nextToken().trim());
            }
            jarExtracts.put(jarName, set);
        }
    }
}

