/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.net.MalformedURLException;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.DefaultErrorHandler;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.xml.sax.SAXException;

public class ErrorDispatcher {
    private ErrorHandler errHandler = new DefaultErrorHandler();
    private boolean jspcMode = false;

    public ErrorDispatcher(boolean jspcMode) {
        this.jspcMode = jspcMode;
    }

    public void javacError(JavacErrorDetail[] javacErrors) throws JasperException {
        this.errHandler.javacError(javacErrors);
    }

    public void javacError(String errorReport, Exception e) throws JasperException {
        this.errHandler.javacError(errorReport, e);
    }

    public void jspError(String errorMessage) throws JasperException {
        this.jspError(null, errorMessage, null);
    }

    public void jspError(String errorMessage, Exception e) throws JasperException {
        this.jspError(null, errorMessage, e);
    }

    public void jspError(Mark where, String errorMessage) throws JasperException {
        this.jspError(where, errorMessage, null);
    }

    public void jspError(Mark where, String errorMessage, Exception e) throws JasperException {
        String file = null;
        int line = -1;
        int column = -1;
        boolean hasLocation = false;
        if (where != null) {
            if (this.jspcMode) {
                try {
                    file = where.getURL().toString();
                }
                catch (MalformedURLException me) {
                    file = where.getFile();
                }
            } else {
                file = where.getFile();
            }
            line = where.getLineNumber();
            column = where.getColumnNumber();
            hasLocation = true;
        }
        Exception nestedEx = e;
        if (e instanceof SAXException && ((SAXException)e).getException() != null) {
            nestedEx = ((SAXException)e).getException();
        }
        if (hasLocation) {
            this.errHandler.jspError(file, line, column, errorMessage, nestedEx);
        } else {
            this.errHandler.jspError(errorMessage, nestedEx);
        }
    }

    public static JavacErrorDetail createJavacError(String fname, Node.Nodes page, StringBuilder errMsgBuf, int lineNum) throws JasperException {
        return ErrorDispatcher.createJavacError(fname, page, errMsgBuf, lineNum, null);
    }

    public static JavacErrorDetail createJavacError(String fname, Node.Nodes page, StringBuilder errMsgBuf, int lineNum, JspCompilationContext ctxt) throws JasperException {
        ErrorVisitor errVisitor = new ErrorVisitor(lineNum);
        page.visit(errVisitor);
        Node errNode = errVisitor.getJspSourceNode();
        JavacErrorDetail javacError = errNode != null && errNode.getStart() != null ? (errVisitor.getJspSourceNode() instanceof Node.Scriptlet ? new JavacErrorDetail(fname, lineNum, errNode.getStart().getFile(), errNode.getStart().getLineNumber() + lineNum - errVisitor.getJspSourceNode().getBeginJavaLine(), errMsgBuf, ctxt) : new JavacErrorDetail(fname, lineNum, errNode.getStart().getFile(), errNode.getStart().getLineNumber(), errMsgBuf, ctxt)) : new JavacErrorDetail(fname, lineNum, errMsgBuf);
        return javacError;
    }

    static class ErrorVisitor
    extends Node.Visitor {
        private int lineNum;
        Node found;

        public ErrorVisitor(int lineNum) {
            this.lineNum = lineNum;
        }

        @Override
        public void doVisit(Node n) throws JasperException {
            if (this.lineNum >= n.getBeginJavaLine() && this.lineNum < n.getEndJavaLine()) {
                this.found = n;
            }
        }

        public Node getJspSourceNode() {
            return this.found;
        }
    }
}

