/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class ListAgentMembership
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String agentName = this.getStringOptionValue("agentname");
        String[] params = new String[]{realm, agentName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_LIST_AGENT_MEMBERSHIP", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, agentName, IdType.AGENT, realm, null);
            if (!amid.isExists()) {
                String[] args = new String[]{realm, agentName, "agent did not exist"};
                this.writeLog(1, Level.INFO, "FAILED_LIST_AGENT_MEMBERSHIP", args);
                Object[] p = new Object[]{agentName};
                String msg = MessageFormat.format(this.getResourceString("list-agent-membership-agent-not-found"), p);
                throw new CLIException(msg, 127);
            }
            Set groups = amid.getMemberships(IdType.AGENTGROUP);
            if (groups != null && !groups.isEmpty()) {
                AMIdentity a = (AMIdentity)groups.iterator().next();
                Object[] obj = new Object[]{a.getName(), a.getUniversalId()};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-agent-membership-succeeded"), obj));
            } else {
                outputWriter.printlnMessage(this.getResourceString("list-agent-membership-no-members"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_LIST_AGENT_MEMBERSHIP", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentName, e.getMessage()};
            this.debugError("ListAgentMembership.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_AGENT_MEMBERSHIP", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentName, e.getMessage()};
            this.debugError("ListAgentMembership.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_AGENT_MEMBERSHIP", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

