/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPostViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.idm.EntityOpViewBeanBase;
import com.sun.identity.console.idm.EntityServicesViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCTabsModel;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class EntityEditViewBean
extends EntityOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/idm/EntityEdit.jsp";
    public static final String UNIVERSAL_ID = "universalId";
    public static final String PG_SESSION_ENTITY_TAB = "entityTab";
    public static final String PG_SESSION_MEMBER_TYPE = "memberType";
    public static final String TAB_PROFILE_COMP = "tabProfile";
    static final String PROPERTY_UUID = "tfUUID";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    public static final int TAB_PROFILE = 0;
    public static final int TAB_SERVICES = 1;
    protected String identityDisplayName;

    EntityEditViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public EntityEditViewBean() {
        super("EntityEdit", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("policy.table.title.subjects");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        EntitiesModel model = (EntitiesModel)this.getModel();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        Map localized = model.getSupportedEntityTypes(curRealm);
        String type = (String)this.getPageSessionAttribute("entityTypeName");
        String i18nName = (String)localized.get(type);
        String title = model.getLocalizedString("page.title.entities.edit");
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        this.propertySheetModel.setValue(PROPERTY_UUID, universalId);
        this.identityDisplayName = AMFormatUtils.getIdentityDisplayName((AMModel)model, universalId);
        Object[] param = new Object[]{i18nName, this.identityDisplayName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
        this.checkForAttributesToDisplay(type);
        if (this.hasNoAttributeToDisplay) {
            this.disableSaveAndResetButton();
        }
    }

    protected void checkForAttributesToDisplay(String type) {
        if (((Object)((Object)this)).getClass().equals(EntityEditViewBean.class)) {
            String agentType;
            EntitiesModel model = (EntitiesModel)this.getModel();
            String serviceName = model.getServiceNameForIdType(type, agentType = (String)this.getPageSessionAttribute("entityAgentType"));
            this.hasNoAttributeToDisplay = serviceName == null || serviceName.trim().length() == 0;
        }
    }

    protected void disableSaveAndResetButton() {
        this.disableButton("button1", true);
        this.disableButton("button2", true);
    }

    protected boolean createPropertyModel() {
        boolean created = super.createPropertyModel();
        if (created) {
            String type = (String)this.getPageSessionAttribute("entityTypeName");
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            EntitiesModel model = (EntitiesModel)this.getModel();
            this.tabModel = new CCTabsModel();
            this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(0, "profile.tab", "", ""));
            if (model.canAssignService(curRealm, type)) {
                this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(1, "services.tab", "", ""));
            }
            try {
                Set memberOfs = model.getIdTypeMemberOf(curRealm, type);
                for (IdType t : memberOfs) {
                    this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(t.hashCode(), t.getName(), "", ""));
                }
                Set beMemberOfs = model.getIdTypeBeMemberOf(curRealm, type);
                if (beMemberOfs != null && !beMemberOfs.isEmpty()) {
                    for (IdType t : beMemberOfs) {
                        this.tabModel.addNode((CCNavNodeInterface)new CCNavNode(t.hashCode(), t.getName(), "", ""));
                    }
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
            this.tabModel.setSelectedNode(0);
        }
        return created;
    }

    protected void setDefaultValues(String type) throws AMConsoleException {
        if (this.propertySheetModel != null) {
            EntitiesModel model = (EntitiesModel)this.getModel();
            String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
            if (!this.submitCycle) {
                this.propertySheetModel.clear();
                try {
                    Map attrValues = model.getAttributeValues(universalId, false);
                    AMPropertySheet prop = (AMPropertySheet)this.getChild("propertyAttributes");
                    prop.setAttributeValues(attrValues, model);
                }
                catch (AMConsoleException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                }
            }
            Object[] uuid = new String[]{universalId};
            this.propertySheetModel.setValues(PROPERTY_UUID, uuid, model);
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        EntitiesModel model = (EntitiesModel)this.getModel();
        AMPropertySheet prop = (AMPropertySheet)this.getChild("propertyAttributes");
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        try {
            Map oldValues = model.getAttributeValues(universalId, false);
            Map values = prop.getAttributeValues(oldValues, true, model);
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            model.modifyEntity(curRealm, universalId, values);
            this.setInlineAlertMessage("info", "message.information", "message.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    protected boolean isCreateViewBean() {
        return false;
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        EntityEditViewBean vb = null;
        IdType idType = null;
        EntitiesModel model = (EntitiesModel)this.getModel();
        this.unlockPageTrailForSwapping();
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(nodeID)));
        if (nodeID == 0) {
            vb = (EntityEditViewBean)this.getViewBean(EntityEditViewBean.class);
            this.forwardToOtherEntityViewBean(vb, idType);
        } else if (nodeID == 1) {
            vb = (EntityServicesViewBean)this.getViewBean(EntityServicesViewBean.class);
            this.forwardToOtherEntityViewBean(vb, idType);
        } else {
            this.handleMembersViewForwarding(nodeID, model);
        }
    }

    protected int getDefaultTabId(String realmName, HttpServletRequest req) {
        return 0;
    }

    private void forwardToOtherEntityViewBean(EntityEditViewBean vb, IdType idType) {
        if (vb == null) {
            this.forwardTo();
        } else {
            String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
            if (idType != null) {
                this.setPageSessionAttribute(PG_SESSION_MEMBER_TYPE, (Serializable)((Object)idType.getName()));
            }
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    private void handleMembersViewForwarding(int nodeID, EntitiesModel model) {
        String type = (String)this.getPageSessionAttribute("entityTypeName");
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            Set memberOfs = model.getIdTypeMemberOf(curRealm, type);
            IdType idType = this.getIdType(nodeID);
            if (idType != null) {
                String viewURL = null;
                viewURL = memberOfs.contains(idType) ? "../idm/EntityMembership" : (model.canAddMember(curRealm, type, idType.getName()) ? "../idm/EntityMembers" : "../idm/EntityMembersFilteredIdentity");
                AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
                this.setPageSessionAttribute(PG_SESSION_MEMBER_TYPE, (Serializable)((Object)idType.getName()));
                this.passPgSessionMap((ViewBean)vb);
                vb.setTargetViewBeanURL(viewURL);
                vb.forwardTo(this.getRequestContext());
            } else {
                this.forwardTo();
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    protected IdType getIdType(int hashCode) {
        IdType idType = null;
        EntitiesModel model = (EntitiesModel)this.getModel();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        Map types = model.getSupportedEntityTypes(curRealm);
        Iterator iter = types.keySet().iterator();
        while (iter.hasNext() && idType == null) {
            try {
                IdType type = IdUtils.getType((String)iter.next());
                if (type.hashCode() != hashCode) continue;
                idType = type;
            }
            catch (IdRepoException e) {}
        }
        return idType;
    }

    protected String getTrackingTabIDName() {
        return PG_SESSION_ENTITY_TAB;
    }

    protected OptionList getOptionListForEntities(Collection entities) {
        OptionList optList = new OptionList();
        if (entities != null && !entities.isEmpty()) {
            EntitiesModel model = (EntitiesModel)this.getModel();
            HashMap<String, String> lookup = new HashMap<String, String>(entities.size() * 2);
            HashSet<String> unsorted = new HashSet<String>(entities.size() * 2);
            for (AMIdentity entity : entities) {
                String name = AMFormatUtils.getIdentityDisplayName((AMModel)model, entity);
                String universalId = IdUtils.getUniversalId(entity);
                lookup.put(universalId, name);
                unsorted.add(name);
            }
            List list = AMFormatUtils.sortItems(unsorted, model.getUserLocale());
            for (String name : list) {
                String id2 = null;
                String tmp = null;
                for (String id2 : lookup.keySet()) {
                    if (!lookup.get(id2).equals(name)) continue;
                    String[] comps = LDAPDN.explodeDN((String)id2, (boolean)true);
                    tmp = name + "(" + comps[0] + ")";
                    optList.add(tmp, id2);
                }
            }
        }
        return optList;
    }

    protected List getEntityDisplayNames(Collection entities) {
        List displayNames = null;
        if (entities != null && !entities.isEmpty()) {
            EntitiesModel model = (EntitiesModel)this.getModel();
            HashSet<String> names = new HashSet<String>(entities.size() * 2);
            for (AMIdentity entity : entities) {
                names.add(AMFormatUtils.getIdentityDisplayName((AMModel)model, entity));
            }
            displayNames = AMFormatUtils.sortItems(names, model.getUserLocale());
        }
        return displayNames != null ? displayNames : Collections.EMPTY_LIST;
    }

    protected Set getEntitiesID(Set entities) {
        HashSet<String> ids = new HashSet<String>(entities.size() * 2);
        for (AMIdentity entity : entities) {
            ids.add(IdUtils.getUniversalId(entity));
        }
        return ids;
    }

    protected String getBreadCrumbDisplayName() {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String universalId = (String)this.getPageSessionAttribute(UNIVERSAL_ID);
        Object[] arg = new String[]{AMFormatUtils.getIdentityDisplayName((AMModel)model, universalId)};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.editentities"), arg);
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.removePageSessionAttribute(this.getTrackingTabIDName());
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)Integer.toString(0)));
        this.forwardToEntitiesViewBean();
    }

    protected boolean startPageTrail() {
        return false;
    }
}

