/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.InvalidAttributeNameException;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.RemoteServiceAttributeValidator;
import com.sun.identity.sm.RequiredValueValidator;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceSchemaImpl {
    Node schemaNode;
    String name;
    String i18nKey;
    String statusAttribute;
    String validate;
    String inheritance;
    Set serviceAttributes;
    Set searchableAttributeNames;
    Map attrSchemas;
    Map attrValidators;
    Map attrDefaults;
    Map attrReadOnlyDefaults;
    Map subSchemas;
    ServiceSchemaImpl orgAttrSchema;
    ServiceSchemaManagerImpl ssm;
    boolean isOrgAttrSchema;
    String serviceName;
    static Debug debug = SMSEntry.debug;

    ServiceSchemaImpl() {
    }

    protected ServiceSchemaImpl(Node node) {
        this(null, node);
    }

    protected ServiceSchemaImpl(ServiceSchemaManagerImpl ss, Node node) {
        this.ssm = ss;
        this.update(node);
    }

    String getName() {
        return this.name;
    }

    String getI18NKey() {
        return this.i18nKey == null && this.ssm != null ? this.ssm.getI18NKey() : this.i18nKey;
    }

    String getStatusAttribute() {
        return this.statusAttribute;
    }

    String getValidate() {
        return this.validate;
    }

    boolean supportsMultipleConfigurations() {
        return this.inheritance != null && this.inheritance.equalsIgnoreCase("multiple");
    }

    Set getAttributeSchemaNames() {
        return new HashSet(this.attrSchemas.keySet());
    }

    protected Set getSearchableAttributeNames() {
        HashSet<String> tmpSet = new HashSet<String>();
        if (this.searchableAttributeNames != null && !this.searchableAttributeNames.isEmpty()) {
            for (String str : this.searchableAttributeNames) {
                if (this.isOrgAttrSchema && !str.toLowerCase().startsWith(this.serviceName.toLowerCase())) {
                    tmpSet.add((this.serviceName + "-" + str).toLowerCase());
                    continue;
                }
                tmpSet.add(str);
            }
        }
        this.searchableAttributeNames = tmpSet;
        return this.searchableAttributeNames;
    }

    Set getServiceAttributeNames() {
        return new HashSet(this.serviceAttributes);
    }

    AttributeSchemaImpl getAttributeSchema(String attributeName) {
        return (AttributeSchemaImpl)this.attrSchemas.get(attributeName);
    }

    Set getAttributeSchemas() {
        return new HashSet(this.attrSchemas.values());
    }

    Map getAttributeDefaults() {
        return SMSUtils.copyAttributes(this.attrDefaults);
    }

    Map getReadOnlyAttributeDefaults() {
        return this.attrReadOnlyDefaults;
    }

    Set getSubSchemaNames() {
        return new HashSet(this.subSchemas.keySet());
    }

    ServiceSchemaImpl getSubSchema(String subSchemaName) throws SMSException {
        return (ServiceSchemaImpl)this.subSchemas.get(subSchemaName);
    }

    ServiceSchemaImpl getOrgAttrSchema() {
        return this.orgAttrSchema;
    }

    boolean validateAttributes(Map attributeSet, boolean encodePassword) throws SMSException {
        return this.validateAttributes(attributeSet, encodePassword, null);
    }

    boolean validateAttributes(Map attributeSet, boolean encodePassword, String orgName) throws SMSException {
        return this.validateAttributes(null, attributeSet, encodePassword, orgName);
    }

    boolean validateAttributes(SSOToken ssoToken, Map attributeSet, boolean encodePassword, String orgName) throws SMSException {
        if (this.validate != null && this.validate.equalsIgnoreCase("no")) {
            return true;
        }
        CaseInsensitiveHashSet asNames = new CaseInsensitiveHashSet();
        for (String attrName : attributeSet.keySet()) {
            if (asNames.contains(attrName)) {
                Object[] args = new Object[]{attrName};
                throw new SMSException("amSDK", "sms-attributeschema-duplicates", args);
            }
            asNames.add(attrName);
            if (attrName.equalsIgnoreCase("cospriority")) continue;
            Set vals = (Set)attributeSet.get(attrName);
            this.validateAttrValues(ssoToken, attrName, vals, encodePassword, orgName);
        }
        return true;
    }

    public String toString() {
        Iterator items;
        StringBuffer sb = new StringBuffer(100);
        if (this.getName() != null) {
            sb.append("Schema name: ").append(this.getName()).append("\n");
        }
        if (this.attrSchemas.size() > 0) {
            sb.append("Attribute Schemas:\n");
            items = this.attrSchemas.keySet().iterator();
            while (items.hasNext()) {
                sb.append(this.attrSchemas.get(items.next()).toString());
            }
        }
        if (this.subSchemas.size() > 0) {
            sb.append("Sub-Schemas:\n");
            items = this.subSchemas.keySet().iterator();
            while (items.hasNext()) {
                sb.append(this.subSchemas.get(items.next()).toString());
            }
        }
        return sb.toString();
    }

    Node getSchemaNode() {
        return this.schemaNode;
    }

    synchronized void update(Node sNode) {
        this.schemaNode = sNode;
        if (this.schemaNode == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaImpl::update schema node is NULL");
            }
            this.name = "";
            this.i18nKey = null;
            this.statusAttribute = null;
            this.serviceAttributes = new HashSet();
            this.searchableAttributeNames = new HashSet();
            this.attrValidators = this.attrDefaults = new HashMap();
            this.attrSchemas = this.attrDefaults;
            this.subSchemas = new CaseInsensitiveHashMap();
            this.attrReadOnlyDefaults = Collections.unmodifiableMap(new HashMap());
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"name");
        this.i18nKey = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"i18nKey");
        this.statusAttribute = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"statusAttribute");
        this.inheritance = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"inheritance");
        this.validate = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"validate");
        HashSet<String> newServiceAttributes = new HashSet<String>();
        HashSet<String> newSearchableAttributeNames = new HashSet<String>();
        HashMap<String, AttributeSchemaImpl> newAttrSchemas = new HashMap<String, AttributeSchemaImpl>();
        HashMap<String, AttributeValidator> newAttrValidators = new HashMap<String, AttributeValidator>();
        HashMap<String, Set> newAttrDefaults = new HashMap<String, Set>();
        CaseInsensitiveHashMap newSubSchemas = new CaseInsensitiveHashMap();
        HashMap tempUnmodifiableDefaults = new HashMap();
        NodeList children = this.schemaNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String name = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
            if (node.getNodeName().equals("AttributeSchema")) {
                AttributeSchemaImpl asi = null;
                if (this.attrSchemas != null) {
                    asi = (AttributeSchemaImpl)this.attrSchemas.get(name);
                }
                if (asi == null) {
                    asi = new AttributeSchemaImpl(node);
                } else {
                    asi.update(node);
                }
                newAttrSchemas.put(name, asi);
                if (!asi.isStatusAttribute() && !asi.isServiceIdentifier()) {
                    newServiceAttributes.add(name);
                }
                if (asi.isSearchable()) {
                    newSearchableAttributeNames.add(name);
                }
                newAttrValidators.put(name, new AttributeValidator(asi));
                newAttrDefaults.put(name, asi.getDefaultValues());
                tempUnmodifiableDefaults.put(name, Collections.unmodifiableSet(asi.getDefaultValues()));
                continue;
            }
            if (node.getNodeName().equals("SubSchema")) {
                ServiceSchemaImpl ssi = null;
                if (this.subSchemas != null) {
                    ssi = (ServiceSchemaImpl)this.subSchemas.get(name);
                }
                if (ssi == null) {
                    newSubSchemas.put(name, new ServiceSchemaImpl(this.ssm, node));
                    continue;
                }
                ssi.update(node);
                newSubSchemas.put(name, ssi);
                continue;
            }
            if (!node.getNodeName().equals("OrganizationAttributeSchema")) continue;
            this.orgAttrSchema = new ServiceSchemaImpl(this.ssm, node);
        }
        this.serviceAttributes = newServiceAttributes;
        this.attrSchemas = newAttrSchemas;
        this.searchableAttributeNames = newSearchableAttributeNames;
        this.attrValidators = newAttrValidators;
        this.attrDefaults = newAttrDefaults;
        this.attrReadOnlyDefaults = Collections.unmodifiableMap(tempUnmodifiableDefaults);
        this.subSchemas = newSubSchemas;
    }

    AttributeValidator getAttributeValidator(String attrName) {
        AttributeValidator av = (AttributeValidator)this.attrValidators.get(attrName);
        if (av == null) {
            AttributeSchemaImpl as = this.getAttributeSchema(attrName);
            if (as == null) {
                return null;
            }
            av = new AttributeValidator(as);
            this.attrValidators.put(attrName, av);
        }
        return av;
    }

    void validateAttrValues(SSOToken ssoToken, String attrName, Set values, boolean encodePassword, String orgName) throws SMSException {
        AttributeSchemaImpl as;
        String anyValue;
        if (this.validate != null && this.validate.equalsIgnoreCase("no")) {
            return;
        }
        AttributeValidator av = this.getAttributeValidator(attrName);
        if (av == null) {
            if (debug.messageEnabled()) {
                debug.message("ServiceSchemaImpl::validateAttrValues Invalid Attribute: " + attrName + " in service: " + this.ssm.getName() + " sub-schema: " + this.name);
            }
            Object[] args = new String[]{attrName};
            throw new InvalidAttributeNameException("amSDK", "sms-validation_failed_invalid_name", args);
        }
        if (orgName != null && (anyValue = (as = this.getAttributeSchema(attrName)).getAny()) != null && anyValue.indexOf("required") > -1 && (values == null || values.isEmpty())) {
            Object[] args = new Object[]{attrName};
            SMSException smse = new SMSException("amSDK", "sms-required-attribute-delete", args);
            debug.error("ServiceSchemaImpl.validateAttrValues: " + attrName + " is a required attribute and cannot" + " be deleted", (Throwable)smse);
            throw smse;
        }
        if (orgName != null) {
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("organization_name", orgName);
            if (ssoToken != null) {
                env.put("SSOToken", ssoToken);
            }
            String i18nFileName = this.ssm != null ? this.ssm.getI18NFileName() : null;
            av.validate(values, i18nFileName, encodePassword, env);
        } else {
            String i18nFileName = this.ssm != null ? this.ssm.getI18NFileName() : null;
            av.validate(values, i18nFileName, encodePassword);
        }
        this.validatePlugin(ssoToken, attrName, values);
    }

    boolean validatePlugin(SSOToken token, String attrName, Set values) throws SMSException, InvalidAttributeNameException {
        AttributeSchemaImpl as = this.getAttributeSchema(attrName);
        if (as == null) {
            Object[] args = new String[]{attrName};
            throw new InvalidAttributeNameException("amSDK", "sms-validation_failed_invalid_name", args);
        }
        String validatorName = as.getValidator();
        if (validatorName == null) {
            return true;
        }
        AttributeSchemaImpl validatorAttrSchema = this.getAttributeSchema(validatorName);
        if (validatorAttrSchema != null) {
            boolean isServerMode = SystemProperties.isServerMode();
            Set javaClasses = validatorAttrSchema.getDefaultValues();
            for (String javaClass : javaClasses) {
                try {
                    this.serverEndAttrValidation(as, attrName, values, javaClass);
                }
                catch (SMSException e) {
                    if (!isServerMode) {
                        this.clientEndAttrValidation(token, as, attrName, values, javaClass);
                        continue;
                    }
                    throw e;
                }
            }
        }
        return true;
    }

    private void clientEndAttrValidation(SSOToken token, AttributeSchemaImpl as, String attrName, Set values, String javaClass) throws SMSException {
        if (!RemoteServiceAttributeValidator.validate(token, javaClass, values)) {
            this.throwInvalidAttributeValuesException(javaClass.equals("com.sun.identity.sm.RequiredValueValidator"), attrName, as);
        }
    }

    private void serverEndAttrValidation(AttributeSchemaImpl as, String attrName, Set values, String javaClass) throws SMSException {
        try {
            Class<?> clazz = Class.forName(javaClass);
            ServiceAttributeValidator validator = (ServiceAttributeValidator)clazz.newInstance();
            this.validatePlugin(validator, as, attrName, values);
        }
        catch (InstantiationException ex) {
            debug.error("ServiceSchemaImpl.serverEndAttrValidation", (Throwable)ex);
            Object[] args = new String[]{javaClass};
            throw new SMSException("amSDK", "sms-validator_cannot_instantiate_class", args);
        }
        catch (IllegalAccessException ex) {
            debug.error("ServiceSchemaImpl.serverEndAttrValidation", (Throwable)ex);
            Object[] args = new String[]{javaClass};
            throw new SMSException("amSDK", "sms-validator_cannot_instantiate_class", args);
        }
        catch (ClassNotFoundException ex) {
            debug.error("ServiceSchemaImpl.serverEndAttrValidation", (Throwable)ex);
            Object[] args = new String[]{javaClass};
            throw new SMSException("amSDK", "sms-validator_cannot_instantiate_class", args);
        }
    }

    private void validatePlugin(ServiceAttributeValidator validator, AttributeSchemaImpl as, String attrName, Set values) throws InvalidAttributeValueException {
        if (!validator.validate(values)) {
            this.throwInvalidAttributeValuesException(validator instanceof RequiredValueValidator, attrName, as);
        }
    }

    private void throwInvalidAttributeValuesException(boolean isRequiredValue, String attrName, AttributeSchemaImpl as) throws InvalidAttributeValueException {
        String message;
        String i18nFileName = this.ssm != null ? this.ssm.getI18NFileName() : null;
        String string = message = isRequiredValue ? "sms-attribute-values-missing" : "sms-attribute-values-does-not-match-schema";
        if (i18nFileName != null) {
            Object[] args = new String[]{attrName, i18nFileName, as.getI18NKey()};
            throw new InvalidAttributeValueException("amSDK", message, args);
        }
        Object[] args = new String[]{attrName};
        throw new InvalidAttributeValueException("amSDK", message, args);
    }
}

