/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.nightly;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import java.util.TreeSet;

public class PrepNight {
    private static final String HEADER = "<html><head><title>OpenSSO - Download</title><link rel=\"stylesheet\" href=\"https://opensso.dev.java.net/opensso.css\" /></head><body><p><img src=\"https://opensso.dev.java.net/images/openssoDownload.gif\" width=\"146\" height=\"64\" /></p>";
    private static final String FOOTER = "</body></html>";
    private static final String TEMPLATE = "&raquo;&nbsp;<a href=\"{0}\">{0}</a>";

    private PrepNight() {
    }

    private static void createIndexHTML(String baseDir) throws IOException {
        Set fileNames = PrepNight.getFileContent(baseDir);
        StringBuffer buff = new StringBuffer();
        buff.append(HEADER);
        for (String name : fileNames) {
            Object[] param = new Object[]{name};
            buff.append(MessageFormat.format(TEMPLATE, param)).append("<br />");
        }
        buff.append(FOOTER);
        PrepNight.writeToFile(baseDir + "/index.html", buff.toString());
    }

    private static Set getFileContent(String baseDir) throws IOException {
        TreeSet<String> binaries = new TreeSet<String>();
        File dir = new File(baseDir);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String name = baseDir + "/" + files[i];
            if (!new File(name).isFile()) continue;
            binaries.add(files[i]);
        }
        return binaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filename, String content) throws IOException {
        if (filename != null) {
            File fileHandle = new File(filename);
            FileWriter out = null;
            try {
                out = new FileWriter(filename);
                out.write(content);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            PrepNight.createIndexHTML(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

