/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2009, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.gatein.common.net;

import java.net.ServerSocket;
import java.io.IOException;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public abstract class AbstractServer implements Runnable
{

   /** . */
   private int port;

   /** . */
   private ServerSocket server;

   public AbstractServer(int port)
   {
      this.port = port;
   }

   public final void start() throws Exception
   {
      server = new ServerSocket(port, 1);
      new Thread(this).start();
   }

   public final void run()
   {
      try
      {
         run(server);
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      finally
      {
         if (!server.isClosed())
         {
            try
            {
               server.close();
            }
            catch (IOException ignore)
            {
            }
         }
      }
   }

   protected abstract void run(ServerSocket server) throws Exception;

   public final void stop()
   {
      if (server != null)
      {
         try
         {
            server.close();
         }
         catch (IOException ignore)
         {
         }
      }
   }

}
