# OpenAPI Gradle plugin

Covers the same functionality as `smallrye-open-api-maven-plugin`, but
as a Gradle plugin.

## Status

The plugin works, but only generates 

## Build information

The Gradle plugin build is integrated into the Maven build pretty much
as in the Quarkus project, roughly using the `exec-maven-plugin` to
call the Gradle wrapper and then attach the artifacts generated by
Gradle to the Maven build.

## Try-out

To try this plugin in another project, perform a **Maven build** to
deploy to the local Maven repository (`mvn clean install`), and tell
Gradle to resolve plugin dependencies in via the local Maven repository,
add the following snippet to your Gradle project's `settings.gradle[.kts]`:

```kotlin
pluginManagement {
    repositories {
        gradlePluginPortal()
        mavenLocal()
    }
}
```

### Via Gradle `includeBuild`

To make the plugin available to your build, add the following snippet(s)
to your Gradle project's `settings.gradle[.kts]`:

```kotlin
includeBuild("FULL_PATH_TO_tools/gradle-plugin")
```

You can then use the plugin using the "standard" mechanisms in
`build.gradle[.kts]` files like this:

```kotlin
plugins {
    id("io.smallrye.openapi")
}
```

### Via the local Maven repository

First deploy the plugin to your local Maven repository by issuing:

```shell
cd tools/gradle-plugin
./gradlew publishToMavenLocal
```

You use the plugin using the "standard" mechanisms in
`build.gradle[.kts]` files like this:

```kotlin
plugins {
    id("io.smallrye.openapi.gradleplugin") version "EXACT_VERSION_OF_THE_PROJECT"
}
```
