/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.opentelemetry.javaagent.instrumentation.elasticsearch.transport.v6_0;

import io.opentelemetry.instrumentation.api.instrumenter.net.InetSocketAddressNetClientAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.elasticsearch.transport.ElasticTransportRequest;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionResponse;

public class Elasticsearch6TransportNetAttributesGetter
    extends InetSocketAddressNetClientAttributesGetter<ElasticTransportRequest, ActionResponse> {
  @Override
  @Nullable
  public String getTransport(ElasticTransportRequest request, @Nullable ActionResponse response) {
    return null;
  }

  @Nullable
  @Override
  public String getPeerName(ElasticTransportRequest request) {
    return null;
  }

  @Nullable
  @Override
  public Integer getPeerPort(ElasticTransportRequest request) {
    return null;
  }

  @Override
  @Nullable
  protected InetSocketAddress getPeerSocketAddress(
      ElasticTransportRequest request, @Nullable ActionResponse response) {
    if (response != null && response.remoteAddress() != null) {
      return response.remoteAddress().address();
    }
    return null;
  }
}
