# Supported libraries, frameworks, application servers, and JVMs

We automatically instrument and support a huge number of libraries, frameworks,
and application servers... right out of the box!

Don't see your favorite tool listed here?  Consider [filing an issue](https://github.com/open-telemetry/opentelemetry-java-instrumentation/issues),
or [contributing](../CONTRIBUTING.md).

## Contents

* [Libraries / Frameworks](#libraries--frameworks)
* [Application Servers](#application-servers)
* [JVMs and Operating Systems](#jvms-and-operating-systems)
* [Disabled instrumentations](#disabled-instrumentations)

## Libraries / Frameworks

These are the supported libraries and frameworks:

| Library/Framework                                                                                                                           | Auto-instrumented versions    | Standalone Library Instrumentation [1]                                                                                                                                                                                                                                                                                                                                                  | Semantic Conventions                                                                   |
|---------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------|
| [Akka Actors](https://doc.akka.io/docs/akka/current/typed/index.html)                                                                       | 2.5+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Context propagation                                                                    |
| [Akka HTTP](https://doc.akka.io/docs/akka-http/current/index.html)                                                                          | 10.0+                         | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics], [HTTP Server Spans], [HTTP Server Metrics] |
| [Apache Axis2](https://axis.apache.org/axis2/java/core/)                                                                                    | 1.6+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Apache Camel](https://camel.apache.org/)                                                                                                   | 2.20+ (not including 3.x yet) | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Dependent on components in use                                                         |
| [Apache DBCP](https://commons.apache.org/proper/commons-dbcp/)                                                                              | 2.0+                          | [opentelemetry-apache-dbcp-2.0](../instrumentation/apache-dbcp-2.0/library)                                                                                                                                                                                                                                                                                                             | [Database Pool Metrics]                                                                |
| [Apache CXF JAX-RS](https://cxf.apache.org/)                                                                                                | 3.2+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Apache CXF JAX-WS](https://cxf.apache.org/)                                                                                                | 3.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Apache Dubbo](https://github.com/apache/dubbo/)                                                                                            | 2.7+                          | [opentelemetry-apache-dubbo-2.7](../instrumentation/apache-dubbo-2.7/library-autoconfigure)                                                                                                                                                                                                                                                                                             | [RPC Client Spans], [RPC Server Spans]                                                 |
| [Apache HttpAsyncClient](https://hc.apache.org/index.html)                                                                                  | 4.1+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Apache HttpClient](https://hc.apache.org/index.html)                                                                                       | 2.0+                          | [opentelemetry-apache-httpclient-4.3](../instrumentation/apache-httpclient/apache-httpclient-4.3/library)                                                                                                                                                                                                                                                                               | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Apache Kafka Producer/Consumer API](https://kafka.apache.org/documentation/#producerapi)                                                   | 0.11+                         | [opentelemetry-kafka-clients-2.6](../instrumentation/kafka/kafka-clients/kafka-clients-2.6/library)                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Apache Kafka Streams API](https://kafka.apache.org/documentation/streams/)                                                                 | 0.11+                         | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Apache MyFaces](https://myfaces.apache.org/)                                                                                               | 1.2+ (not including 3.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Apache Pulsar](https://pulsar.apache.org/)                                                                                                 | 2.8+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Apache RocketMQ gRPC/Protobuf-based Client](https://rocketmq.apache.org/)                                                                  | 5.0.0+                        | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Apache RocketMQ Remoting-based Client](https://rocketmq.apache.org/)                                                                       | 4.8+                          | [opentelemetry-rocketmq-client-4.8](../instrumentation/rocketmq/rocketmq-client/rocketmq-client-4.8/library)                                                                                                                                                                                                                                                                            | [Messaging Spans]                                                                      |
| [Apache Struts 2](https://github.com/apache/struts)                                                                                         | 2.3+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Apache Tapestry](https://tapestry.apache.org/)                                                                                             | 5.4+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Apache Wicket](https://wicket.apache.org/)                                                                                                 | 8.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2]                                                              |
| [Armeria](https://armeria.dev)                                                                                                              | 1.3+                          | [opentelemetry-armeria-1.3](../instrumentation/armeria-1.3/library)                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics], [HTTP Server Spans], [HTTP Server Metrics] |
| [AsyncHttpClient](https://github.com/AsyncHttpClient/async-http-client)                                                                     | 1.9+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [AWS Lambda](https://docs.aws.amazon.com/lambda/latest/dg/java-handler.html)                                                                | 1.0+                          | [opentelemetry-aws-lambda-core-1.0](../instrumentation/aws-lambda/aws-lambda-core-1.0/library),<br>[opentelemetry-aws-lambda-events-2.2](../instrumentation/aws-lambda/aws-lambda-events-2.2/library)                                                                                                                                                                                   | [FaaS Server Spans]                                                                    |
| [AWS SDK](https://aws.amazon.com/sdk-for-java/)                                                                                             | 1.11.x and 2.2.0+             | [opentelemetry-aws-sdk-1.11](../instrumentation/aws-sdk/aws-sdk-1.11/library),<br>[opentelemetry-aws-sdk-1.11-autoconfigure](../instrumentation/aws-sdk/aws-sdk-1.11/library-autoconfigure),<br>[opentelemetry-aws-sdk-2.2](../instrumentation/aws-sdk/aws-sdk-2.2/library),<br>[opentelemetry-aws-sdk-2.2-autoconfigure](../instrumentation/aws-sdk/aws-sdk-2.2/library-autoconfigure) | [Messaging Spans], [Database Client Spans], [HTTP Client Spans]                        |
| [Azure Core](https://docs.microsoft.com/en-us/java/api/overview/azure/core-readme)                                                          | 1.14+                         | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Context propagation                                                                    |
| [Cassandra Driver](https://github.com/datastax/java-driver)                                                                                 | 3.0+                          | [opentelemetry-cassandra-4.4](../instrumentation/cassandra/cassandra-4.4/library)                                                                                                                                                                                                                                                                                                       | [Database Client Spans]                                                                |
| [Couchbase Client](https://github.com/couchbase/couchbase-java-client)                                                                      | 2.0+ and 3.1+                 | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [c3p0](https://github.com/swaldman/c3p0)                                                                                                    | 0.9.2+                        | [opentelemetry-c3p0-0.9](../instrumentation/c3p0-0.9/library)                                                                                                                                                                                                                                                                                                                           | [Database Pool Metrics]                                                                |
| [Dropwizard Metrics](https://metrics.dropwizard.io/)                                                                                        | 4.0+ (disabled by default)    | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Dropwizard Views](https://www.dropwizard.io/en/latest/manual/views.html)                                                                   | 0.7+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Controller Spans [3]                                                                   |
| [Eclipse Grizzly](https://javaee.github.io/grizzly/httpserverframework.html)                                                                | 2.0+ (disabled by default)    | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Server Spans], [HTTP Server Metrics]                                             |
| [Eclipse Jersey](https://eclipse-ee4j.github.io/jersey/)                                                                                    | 2.0+ (not including 3.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Eclipse Jetty HTTP Client](https://www.eclipse.org/jetty/javadoc/jetty-9/org/eclipse/jetty/client/HttpClient.html)                         | 9.2+ (not including 10+ yet)  | [opentelemetry-jetty-httpclient-9.2](../instrumentation/jetty-httpclient/jetty-httpclient-9.2/library)                                                                                                                                                                                                                                                                                  | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Eclipse Metro](https://projects.eclipse.org/projects/ee4j.metro)                                                                           | 2.2+ (not including 3.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Eclipse Mojarra](https://projects.eclipse.org/projects/ee4j.mojarra)                                                                       | 1.2+ (not including 3.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Elasticsearch API](https://www.elastic.co/guide/en/elasticsearch/client/java-api/current/index.html)                                       | 5.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [Elasticsearch REST Client](https://www.elastic.co/guide/en/elasticsearch/client/java-rest/current/index.html)                              | 5.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [Finatra](https://github.com/twitter/finatra)                                                                                               | 2.9+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Geode Client](https://geode.apache.org/)                                                                                                   | 1.4+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [Google HTTP Client](https://github.com/googleapis/google-http-java-client)                                                                 | 1.19+                         | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Grails](https://grails.org/)                                                                                                               | 3.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [GraphQL Java](https://www.graphql-java.com/)                                                                                               | 12.0+                         | [opentelemetry-graphql-java-12.0](../instrumentation/graphql-java-12.0/library)                                                                                                                                                                                                                                                                                                         | [GraphQL Server Spans]                                                                 |
| [gRPC](https://github.com/grpc/grpc-java)                                                                                                   | 1.6+                          | [opentelemetry-grpc-1.6](../instrumentation/grpc-1.6/library)                                                                                                                                                                                                                                                                                                                           | [RPC Client Spans], [RPC Client Metrics], [RPC Server Spans], [RPC Server Metrics]     |
| [Guava ListenableFuture](https://guava.dev/releases/snapshot/api/docs/com/google/common/util/concurrent/ListenableFuture.html)              | 10.0+                         | [opentelemetry-guava-10.0](../instrumentation/guava-10.0/library)                                                                                                                                                                                                                                                                                                                       | Context propagation                                                                    |
| [GWT](http://www.gwtproject.org/)                                                                                                           | 2.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [RPC Server Spans]                                                                     |
| [Hibernate](https://github.com/hibernate/hibernate-orm)                                                                                     | 3.3+ (not including 6.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [HikariCP](https://github.com/brettwooldridge/HikariCP)                                                                                     | 3.0+                          | [opentelemetry-hikaricp-3.0](../instrumentation/hikaricp-3.0/library)                                                                                                                                                                                                                                                                                                                   | [Database Pool Metrics]                                                                |
| [HttpURLConnection](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/net/HttpURLConnection.html)                           | Java 8+                       | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Hystrix](https://github.com/Netflix/Hystrix)                                                                                               | 1.4+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Java Executors](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executor.html)                                              | Java 8+                       | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Context propagation                                                                    |
| [Java Http Client](https://docs.oracle.com/en/java/javase/11/docs/api/java.net.http/java/net/http/package-summary.html)                     | Java 11+                      | [opentelemetry-java-http-client](../instrumentation/java-http-client/library)                                                                                                                                                                                                                                                                                                           | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [java.util.logging](https://docs.oracle.com/javase/8/docs/api/java/util/logging/package-summary.html)                                       | Java 8+                       | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Java Platform](https://docs.oracle.com/javase/8/docs/api/java/lang/management/ManagementFactory.html)                                      | Java 8+                       | [opentelemetry-runtime-metrics](../instrumentation/runtime-metrics/library),<br>[opentelemetry-resources](../instrumentation/resources/library)                                                                                                                                                                                                                                         | [JVM Runtime Metrics]                                                                  |
| [JAX-RS](https://javaee.github.io/javaee-spec/javadocs/javax/ws/rs/package-summary.html)                                                    | 0.5+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [JAX-RS Client](https://javaee.github.io/javaee-spec/javadocs/javax/ws/rs/client/package-summary.html)                                      | 1.1+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [JAX-WS](https://jakarta.ee/specifications/xml-web-services/2.3/apidocs/javax/xml/ws/package-summary.html)                                  | 2.0+ (not including 3.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [JBoss Log Manager](https://github.com/jboss-logging/jboss-logmanager)                                                                      | 1.1+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [JDBC](https://docs.oracle.com/javase/8/docs/api/java/sql/package-summary.html)                                                             | Java 8+                       | [opentelemetry-jdbc](../instrumentation/jdbc/library)                                                                                                                                                                                                                                                                                                                                   | [Database Client Spans]                                                                |
| [Jedis](https://github.com/xetorthio/jedis)                                                                                                 | 1.4+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [JMS](https://javaee.github.io/javaee-spec/javadocs/javax/jms/package-summary.html)                                                         | 1.1+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Jodd Http](https://javadoc.io/doc/org.jodd/jodd-http/latest/index.html)                                                                    | 4.2+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [JSP](https://javaee.github.io/javaee-spec/javadocs/javax/servlet/jsp/package-summary.html)                                                 | 2.3+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Kotlin Coroutines](https://kotlinlang.org/docs/coroutines-overview.html)                                                                   | 1.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Context propagation                                                                    |
| [Ktor](https://github.com/ktorio/ktor)                                                                                                      | 1.0+                          | [opentelemetry-ktor-1.0](../instrumentation/ktor/ktor-1.0/library),<br>[opentelemetry-ktor-2.0](../instrumentation/ktor/ktor-2.0/library)                                                                                                                                                                                                                                               | [HTTP Client Spans], [HTTP Client Metrics], [HTTP Server Spans], [HTTP Server Metrics] |
| [Kubernetes Client](https://github.com/kubernetes-client/java)                                                                              | 7.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans]                                                                    |
| [Lettuce](https://github.com/lettuce-io/lettuce-core)                                                                                       | 4.0+                          | [opentelemetry-lettuce-5.1](../instrumentation/lettuce/lettuce-5.1/library)                                                                                                                                                                                                                                                                                                             | [Database Client Spans]                                                                |
| [Log4j 1](https://logging.apache.org/log4j/1.2/)                                                                                            | 1.2+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Log4j 2](https://logging.apache.org/log4j/2.x/)                                                                                            | 2.11+                         | [opentelemetry-log4j-appender-2.17](../instrumentation/log4j/log4j-appender-2.17/library),<br>[opentelemetry-log4j-context-data-2.17-autoconfigure](../instrumentation/log4j/log4j-context-data/log4j-context-data-2.17/library-autoconfigure)                                                                                                                                          | none                                                                                   |
| [Logback](http://logback.qos.ch/)                                                                                                           | 1.0+                          | [opentelemetry-logback-appender-1.0](../instrumentation/logback/logback-appender-1.0/library),<br>[opentelemetry-logback-mdc-1.0](../instrumentation/logback/logback-mdc-1.0/library)                                                                                                                                                                                                   | none                                                                                   |
| [Micrometer](https://micrometer.io/)                                                                                                        | 1.5+                          | [opentelemetry-micrometer-1.5](../instrumentation/micrometer/micrometer-1.5/library)                                                                                                                                                                                                                                                                                                    | none                                                                                   |
| [MongoDB Driver](https://mongodb.github.io/mongo-java-driver/)                                                                              | 3.1+                          | [opentelemetry-mongo-3.1](../instrumentation/mongo/mongo-3.1/library)                                                                                                                                                                                                                                                                                                                   | [Database Client Spans]                                                                |
| [Netty](https://github.com/netty/netty)                                                                                                     | 3.8+                          | [opentelemetry-netty-4.1](../instrumentation/netty/netty-4.1/library)                                                                                                                                                                                                                                                                                                                   | [HTTP Client Spans], [HTTP Client Metrics], [HTTP Server Spans], [HTTP Server Metrics] |
| [OkHttp](https://github.com/square/okhttp/)                                                                                                 | 2.2+                          | [opentelemetry-okhttp-3.0](../instrumentation/okhttp/okhttp-3.0/library)                                                                                                                                                                                                                                                                                                                | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Oracle UCP](https://docs.oracle.com/database/121/JJUCP/)                                                                                   | 11.2+                         | [opentelemetry-oracle-ucp-11.2](../instrumentation/oracle-ucp-11.2/library)                                                                                                                                                                                                                                                                                                             | [Database Pool Metrics]                                                                |
| [OSHI](https://github.com/oshi/oshi/)                                                                                                       | 5.3.1+                        | [opentelemetry-oshi](../instrumentation/oshi/library)                                                                                                                                                                                                                                                                                                                                   | [System Metrics] (partial support)                                                     |
| [Play](https://github.com/playframework/playframework)                                                                                      | 2.4+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics], Provides `http.route` [2]                  |
| [Play WS](https://github.com/playframework/play-ws)                                                                                         | 1.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Quartz](https://www.quartz-scheduler.org/)                                                                                                 | 2.0+                          | [opentelemetry-quartz-2.0](../instrumentation/quartz-2.0/library)                                                                                                                                                                                                                                                                                                                       | none                                                                                   |
| [R2DBC](https://r2dbc.io/)                                                                                                                  | 1.0+                          | [opentelemetry-r2dbc-1.0](../instrumentation/r2dbc-1.0/library)                                                                                                                                                                                                                                                                                                                         | [Database Client Spans]                                                                |
| [RabbitMQ Client](https://github.com/rabbitmq/rabbitmq-java-client)                                                                         | 2.7+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Ratpack](https://github.com/ratpack/ratpack)                                                                                               | 1.4+                          | [opentelemetry-ratpack-1.7](../instrumentation/ratpack/ratpack-1.7/library)                                                                                                                                                                                                                                                                                                             | [HTTP Client Spans], [HTTP Client Metrics], [HTTP Server Spans], [HTTP Server Metrics] |
| [Reactor](https://github.com/reactor/reactor-core)                                                                                          | 3.1+                          | [opentelemetry-reactor-3.1](../instrumentation/reactor/reactor-3.1/library)                                                                                                                                                                                                                                                                                                             | Context propagation                                                                    |
| [Reactor Netty](https://github.com/reactor/reactor-netty)                                                                                   | 0.9+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Rediscala](https://github.com/etaty/rediscala)                                                                                             | 1.8+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [Redisson](https://github.com/redisson/redisson)                                                                                            | 3.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [RESTEasy](https://resteasy.github.io/)                                                                                                     | 3.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Restlet](https://restlet.github.io/)                                                                                                       | 1.0+                          | [opentelemetry-restlet-1.1](../instrumentation/restlet/restlet-1.1/library),<br>[opentelemetry-restlet-2.0](../instrumentation/restlet/restlet-2.0/library)                                                                                                                                                                                                                             | [HTTP Server Spans], [HTTP Server Metrics]                                             |
| [RMI](https://docs.oracle.com/en/java/javase/11/docs/api/java.rmi/java/rmi/package-summary.html)                                            | Java 8+                       |                                                                                                                                                                                                                                                                                                                                                                                         | [RPC Client Spans], [RPC Server Spans]                                                 |
| [RxJava](https://github.com/ReactiveX/RxJava)                                                                                               | 1.0+                          | [opentelemetry-rxjava-1.0](../instrumentation/rxjava/rxjava-1.0/library),<br>[opentelemetry-rxjava-2.0](../instrumentation/rxjava/rxjava-2.0/library),<br>[opentelemetry-rxjava-3.0](../instrumentation/rxjava/rxjava-3.0/library),<br>[opentelemetry-rxjava-3.1.1](../instrumentation/rxjava/rxjava-3.1.1/library)                                                                     | Context propagation                                                                    |
| [Scala ForkJoinPool](https://www.scala-lang.org/api/2.12.0/scala/concurrent/forkjoin/package$$ForkJoinPool$.html)                           | 2.8+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Context propagation                                                                    |
| [Servlet](https://javaee.github.io/javaee-spec/javadocs/javax/servlet/package-summary.html)                                                 | 2.2+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Server Spans], [HTTP Server Metrics]                                             |
| [Spark Web Framework](https://github.com/perwendel/spark)                                                                                   | 2.3+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2]                                                              |
| [Spring Boot](https://spring.io/projects/spring-boot)                                                                                       |                               | [opentelemetry-spring-boot-resources](../instrumentation/spring/spring-boot-resources/library)                                                                                                                                                                                                                                                                                          | none                                                                                   |
| [Spring Batch](https://spring.io/projects/spring-batch)                                                                                     | 3.0+ (not including 5.0+ yet) | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Spring Data](https://spring.io/projects/spring-data)                                                                                       | 1.8+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Spring Integration](https://spring.io/projects/spring-integration)                                                                         | 4.1+ (not including 6.0+ yet) | [opentelemetry-spring-integration-4.1](../instrumentation/spring/spring-integration-4.1/library)                                                                                                                                                                                                                                                                                        | [Messaging Spans]                                                                      |
| [Spring JMS](https://docs.spring.io/spring-framework/docs/current/reference/html/integration.html#jms)                                      | 2.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Spring Kafka](https://spring.io/projects/spring-kafka)                                                                                     | 2.7+                          | [opentelemetry-spring-kafka-2.7](../instrumentation/spring/spring-kafka-2.7/library)                                                                                                                                                                                                                                                                                                    | [Messaging Spans]                                                                      |
| [Spring RabbitMQ](https://spring.io/projects/spring-amqp)                                                                                   | 1.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Spring Scheduling](https://docs.spring.io/spring/docs/current/javadoc-api/org/springframework/scheduling/package-summary.html)             | 3.1+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Spring RestTemplate](https://docs.spring.io/spring-framework/docs/current/javadoc-api/org/springframework/web/client/package-summary.html) | 3.1+                          | [opentelemetry-spring-web-3.1](../instrumentation/spring/spring-web/spring-web-3.1/library)                                                                                                                                                                                                                                                                                             | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Spring Web MVC](https://docs.spring.io/spring/docs/current/javadoc-api/org/springframework/web/servlet/mvc/package-summary.html)           | 3.1+                          | [opentelemetry-spring-webmvc-5.3](../instrumentation/spring/spring-webmvc/spring-webmvc-5.3/library),<br>[opentelemetry-spring-webmvc-6.0](../instrumentation/spring/spring-webmvc/spring-webmvc-6.0/library)                                                                                                                                                                           | [HTTP Server Spans], [HTTP Server Metrics]                                             |
| [Spring Web Services](https://spring.io/projects/spring-ws)                                                                                 | 2.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Spring WebFlux](https://docs.spring.io/spring/docs/current/javadoc-api/org/springframework/web/reactive/package-summary.html)              | 5.3+                          | [opentelemetry-spring-webflux-5.3](../instrumentation/spring/spring-webflux/spring-webflux-5.3/library)                                                                                                                                                                                                                                                                                 | [HTTP Client Spans], [HTTP Client Metrics], [HTTP Server Spans], [HTTP Server Metrics] |
| [Spymemcached](https://github.com/couchbase/spymemcached)                                                                                   | 2.12+                         | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Client Spans]                                                                |
| [Tomcat JDBC Pool](https://tomcat.apache.org/tomcat-7.0-doc/jdbc-pool.html)                                                                 | 8.5.0+                        | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Database Pool Metrics]                                                                |
| [Twilio](https://github.com/twilio/twilio-java)                                                                                             | 6.6+ (not including 8.x yet)  | N/A                                                                                                                                                                                                                                                                                                                                                                                     | none                                                                                   |
| [Undertow](https://undertow.io/)                                                                                                            | 1.4+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Server Spans], [HTTP Server Metrics]                                             |
| [Vaadin](https://vaadin.com/)                                                                                                               | 14.2+                         | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2], Controller Spans [3]                                        |
| [Vert.x Web](https://vertx.io/docs/vertx-web/java/)                                                                                         | 3.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Provides `http.route` [2]                                                              |
| [Vert.x HttpClient](https://vertx.io/docs/apidocs/io/vertx/core/http/HttpClient.html)                                                       | 3.0+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [HTTP Client Spans], [HTTP Client Metrics]                                             |
| [Vert.x Kafka Client](https://vertx.io/docs/vertx-kafka-client/java/)                                                                       | 3.6+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | [Messaging Spans]                                                                      |
| [Vert.x RxJava2](https://vertx.io/docs/vertx-rx/java2/)                                                                                     | 3.5+                          | N/A                                                                                                                                                                                                                                                                                                                                                                                     | context propagation only                                                               |
| [Vibur DBCP](https://www.vibur.org/)                                                                                                        | 11.0+                         | [opentelemetry-vibur-dbcp-11.0](../instrumentation/vibur-dbcp-11.0/library)                                                                                                                                                                                                                                                                                                             | [Database Pool Metrics]                                                                |
| [ZIO](https://zio.dev/)                                                                                                                     | 2.0.0+                        | N/A                                                                                                                                                                                                                                                                                                                                                                                     | Context propagation                                                                    |

**[1]** Standalone library instrumentation refers to instrumentation that can be used without the Java agent.

**[2]** Provides `http.route`: Provides route-based span name for existing `SERVER` span. If applicable, provides `http.route` span and metric attribute on existing `SERVER` span and metrics.

**[3]** Controller Spans are `INTERNAL` spans capturing the controller and/or view execution. See [Suppressing controller and/or view spans](https://opentelemetry.io/docs/instrumentation/java/automatic/agent-config/#suppressing-controller-andor-view-spans).

[HTTP Server Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/http.md#http-server-semantic-conventions
[HTTP Client Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/http.md#http-client
[HTTP Server Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/http-metrics.md#http-server
[HTTP Client Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/http-metrics.md#http-client
[RPC Server Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/rpc.md#server-attributes
[RPC Client Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/rpc.md#common-attributes
[RPC Server Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/rpc-metrics.md#rpc-server
[RPC Client Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/rpc-metrics.md#rpc-client
[Messaging Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/messaging.md
[Database Client Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/database.md
[Database Pool Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/database-metrics.md
[JVM Runtime Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/runtime-environment-metrics.md#jvm-metrics
[System Metrics]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/system-metrics.md
[GraphQL Server Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/instrumentation/graphql.md
[FaaS Server Spans]: https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/semantic_conventions/faas.md

## Application Servers

These are the application servers that the smoke tests are run against:

| Application server                                                                        | Version                     | JVM               | OS                             |
| ----------------------------------------------------------------------------------------- | --------------------------- | ----------------- | ------------------------------ |
| [Jetty](https://www.eclipse.org/jetty/)                                                   | 9.4.x, 10.0.x, 11.0.x       | OpenJDK 8, 11, 17 | [`ubuntu-latest`], [`windows-latest`] |
| [Payara](https://www.payara.fish/)                                                        | 5.0.x, 5.1.x                | OpenJDK 8, 11     | [`ubuntu-latest`], [`windows-latest`] |
| [Tomcat](http://tomcat.apache.org/)                                                       | 7.0.x                       | OpenJDK 8         | [`ubuntu-latest`], [`windows-latest`] |
| [Tomcat](http://tomcat.apache.org/)                                                       | 7.0.x, 8.5.x, 9.0.x, 10.0.x | OpenJDK 8, 11, 17 | [`ubuntu-latest`], [`windows-latest`] |
| [TomEE](https://tomee.apache.org/)                                                        | 7.x, 8.x                    | OpenJDK 8, 11, 17 | [`ubuntu-latest`], [`windows-latest`] |
| [Open Liberty](https://openliberty.io/)                                                   | 21.x, 22.x                  | OpenJDK 8, 11, 17 | [`ubuntu-latest`], [`windows-latest`] |
| [Websphere Traditional](https://www.ibm.com/uk-en/cloud/websphere-application-server)     | 8.5.5.x, 9.0.x              | IBM JDK 8         | Red Hat Enterprise Linux 8.4   |
| [WildFly](https://www.wildfly.org/)                                                       | 13.x                        | OpenJDK 8         | [`ubuntu-latest`], [`windows-latest`] |
| [WildFly](https://www.wildfly.org/)                                                       | 17.x, 21.x, 25.x            | OpenJDK 8, 11, 17 | [`ubuntu-latest`], [`windows-latest`] |

[`ubuntu-latest`]: https://github.com/actions/runner-images#available-images
[`windows-latest`]: https://github.com/actions/runner-images#available-images

## JVMs and operating systems

These are the JVMs and operating systems that the integration tests are run against:

| JVM                                                                                        | Versions  | OS                             |
| ------------------------------------------------------------------------------------------ | --------- | ------------------------------ |
| [OpenJDK (Eclipse Temurin)](https://adoptium.net/)                                         | 8, 11, 17 | [`ubuntu-latest`], [`windows-latest`] |
| [OpenJ9 (IBM Semeru Runtimes)](https://developer.ibm.com/languages/java/semeru-runtimes/)  | 8, 11, 17 | [`ubuntu-latest`] |

## Disabled instrumentations

Some instrumentations can produce too many spans and make traces very noisy.
For this reason, the following instrumentations are disabled by default:

- `jdbc-datasource` which creates spans whenever the `java.sql.DataSource#getConnection` method is called.
- `dropwizard-metrics` which might create a very low quality metrics data, because of lack of label/attribute support
  in the Dropwizard metrics API.

To enable them, add the `otel.instrumentation.<name>.enabled` system property:
`-Dotel.instrumentation.jdbc-datasource.enabled=true`
