/**
 * Copyright 2014 Red Hat, Inc.
 * 
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Category;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An SAP endpoint sending a IDoc (Intermediary Document) to an SAP system using transactional remote function calls (tRFC).
 * 
 * @author William Collins <punkhornsw@gmail.com>
 *
 */
@UriEndpoint(firstVersion = "3.20.1-redhat", scheme="sap-idoclist-destination", syntax = "sap-idoclist-destination:destination:idocType:idocTypeExtension:systemRelease:applicationRelease", producerOnly = true, title="SAP IDoc List Destination", category = { Category.SAP })
public class SapTransactionalIDocListDestinationEndpoint extends SapIDocDestinationEndpoint {

	private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocListDestinationEndpoint.class); 

	public SapTransactionalIDocListDestinationEndpoint() {
	}

	public SapTransactionalIDocListDestinationEndpoint(String endpointUri, SapTransactionalIDocListDestinationComponent component) {
		super(endpointUri, component);
	}

	public DocumentList createDocumentList() throws Exception {
		try {
			return IDocUtil.createDocumentList(getIDocRepository(), getIdocType(), getIdocTypeExtension(), getSystemRelease(), getApplicationRelease());
		} catch (Exception e) {
			throw new Exception("Failed to get Document List from endpoint", e);
		}
	}

	@Override
	public Producer createProducer() throws Exception {
		LOG.debug("Created producer for endpoint '" + getEndpointUri() + "'");
		return new SapTransactionalIDocListProducer(this);
	}

}
