/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.infinispan.embedded.springboot;

import java.util.function.BiFunction;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedComponent;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedCustomListener;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Read and write from/to Infinispan distributed key/value store and data grid.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.infinispan-embedded")
public class InfinispanEmbeddedComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the infinispan-embedded
     * component. This is enabled by default.
     */
    private Boolean enabled;
    /**
     * Component configuration. The option is a
     * org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration type.
     */
    private InfinispanEmbeddedConfiguration configuration;
    /**
     * Specifies the query builder. The option is a
     * org.apache.camel.component.infinispan.InfinispanQueryBuilder type.
     */
    private InfinispanQueryBuilder queryBuilder;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * If true, the listener will be installed for the entire cluster
     */
    private Boolean clusteredListener = false;
    /**
     * Returns the custom listener in use, if provided. The option is a
     * org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedCustomListener type.
     */
    private InfinispanEmbeddedCustomListener customListener;
    /**
     * Specifies the set of event types to register by the consumer.Multiple
     * event can be separated by comma. The possible event types are:
     * CACHE_ENTRY_ACTIVATED, CACHE_ENTRY_PASSIVATED, CACHE_ENTRY_VISITED,
     * CACHE_ENTRY_LOADED, CACHE_ENTRY_EVICTED, CACHE_ENTRY_CREATED,
     * CACHE_ENTRY_REMOVED, CACHE_ENTRY_MODIFIED, TRANSACTION_COMPLETED,
     * TRANSACTION_REGISTERED, CACHE_ENTRY_INVALIDATED, CACHE_ENTRY_EXPIRED,
     * DATA_REHASHED, TOPOLOGY_CHANGED, PARTITION_STATUS_CHANGED,
     * PERSISTENCE_AVAILABILITY_CHANGED
     */
    private String eventTypes;
    /**
     * If true, the consumer will receive notifications synchronously
     */
    private Boolean sync = true;
    /**
     * Set a specific default value for some producer operations. The option is
     * a java.lang.Object type.
     */
    private Object defaultValue;
    /**
     * Set a specific key for producer operations. The option is a
     * java.lang.Object type.
     */
    private Object key;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Set a specific old value for some producer operations. The option is a
     * java.lang.Object type.
     */
    private Object oldValue;
    /**
     * The operation to perform
     */
    private InfinispanOperation operation = InfinispanOperation.PUT;
    /**
     * Set a specific value for producer operations. The option is a
     * java.lang.Object type.
     */
    private Object value;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Specifies the cache Container to connect. The option is a
     * org.infinispan.manager.EmbeddedCacheManager type.
     */
    private EmbeddedCacheManager cacheContainer;
    /**
     * The CacheContainer configuration. Used if the cacheContainer is not
     * defined. The option is a org.infinispan.configuration.cache.Configuration
     * type.
     */
    private Configuration cacheContainerConfiguration;
    /**
     * An implementation specific URI for the CacheManager
     */
    private String configurationUri;
    /**
     * A comma separated list of org.infinispan.context.Flag to be applied by
     * default on each cache invocation
     */
    private String flags;
    /**
     * Set a specific remappingFunction to use in a compute operation. The
     * option is a java.util.function.BiFunction type.
     */
    private BiFunction remappingFunction;
    /**
     * Store the operation result in a header instead of the message body. By
     * default, resultHeader == null and the query result is stored in the
     * message body, any existing content in the message body is discarded. If
     * resultHeader is set, the value is used as the name of the header to store
     * the query result and the original message body is preserved. This value
     * can be overridden by an in message header named:
     * CamelInfinispanOperationResultHeader
     */
    private String resultHeader;

    public InfinispanEmbeddedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(InfinispanEmbeddedConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfinispanQueryBuilder getQueryBuilder() {
        return queryBuilder;
    }

    public void setQueryBuilder(InfinispanQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getClusteredListener() {
        return clusteredListener;
    }

    public void setClusteredListener(Boolean clusteredListener) {
        this.clusteredListener = clusteredListener;
    }

    public InfinispanEmbeddedCustomListener getCustomListener() {
        return customListener;
    }

    public void setCustomListener(
            InfinispanEmbeddedCustomListener customListener) {
        this.customListener = customListener;
    }

    public String getEventTypes() {
        return eventTypes;
    }

    public void setEventTypes(String eventTypes) {
        this.eventTypes = eventTypes;
    }

    public Boolean getSync() {
        return sync;
    }

    public void setSync(Boolean sync) {
        this.sync = sync;
    }

    public Object getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getKey() {
        return key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Object getOldValue() {
        return oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public InfinispanOperation getOperation() {
        return operation;
    }

    public void setOperation(InfinispanOperation operation) {
        this.operation = operation;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public EmbeddedCacheManager getCacheContainer() {
        return cacheContainer;
    }

    public void setCacheContainer(EmbeddedCacheManager cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    public Configuration getCacheContainerConfiguration() {
        return cacheContainerConfiguration;
    }

    public void setCacheContainerConfiguration(
            Configuration cacheContainerConfiguration) {
        this.cacheContainerConfiguration = cacheContainerConfiguration;
    }

    public String getConfigurationUri() {
        return configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public String getFlags() {
        return flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public BiFunction getRemappingFunction() {
        return remappingFunction;
    }

    public void setRemappingFunction(BiFunction remappingFunction) {
        this.remappingFunction = remappingFunction;
    }

    public String getResultHeader() {
        return resultHeader;
    }

    public void setResultHeader(String resultHeader) {
        this.resultHeader = resultHeader;
    }
}