/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Socket level networking using TCP or UDP with Apache Mina 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MinaEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Mina component.
     */
    public interface MinaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMinaEndpointConsumerBuilder advanced() {
            return (AdvancedMinaEndpointConsumerBuilder) this;
        }
        /**
         * Whether to disconnect(close) from Mina session right after use. Can
         * be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether to disconnect(close) from Mina session right after use. Can
         * be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param minaLogger the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder minaLogger(boolean minaLogger) {
            doSetProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param minaLogger the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder minaLogger(String minaLogger) {
            doSetProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder writeTimeout(long writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * If the clientMode is true, mina consumer will connect the address as
         * a TCP client.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clientMode the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder clientMode(boolean clientMode) {
            doSetProperty("clientMode", clientMode);
            return this;
        }
        /**
         * If the clientMode is true, mina consumer will connect the address as
         * a TCP client.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param clientMode the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder clientMode(String clientMode) {
            doSetProperty("clientMode", clientMode);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder allowDefaultCodec(
                boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder allowDefaultCodec(
                String allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.mina.filter.codec.ProtocolCodecFactory&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param codec the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder codec(
                org.apache.mina.filter.codec.ProtocolCodecFactory codec) {
            doSetProperty("codec", codec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.mina.filter.codec.ProtocolCodecFactory&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param codec the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder codec(String codec) {
            doSetProperty("codec", codec);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: codec
         * 
         * @param encoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder encoderMaxLineLength(
                int encoderMaxLineLength) {
            doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: codec
         * 
         * @param encoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder encoderMaxLineLength(
                String encoderMaxLineLength) {
            doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * You can configure the encoding (a charset name) to use for the TCP
         * textline codec and the UDP protocol. If not provided, Camel will use
         * the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;org.apache.mina.core.filterchain.IoFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder filters(
                List<org.apache.mina.core.filterchain.IoFilter> filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;org.apache.mina.core.filterchain.IoFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder filters(String filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder textline(String textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mina.MinaTextLineDelimiter&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param textlineDelimiter the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder textlineDelimiter(
                org.apache.camel.component.mina.MinaTextLineDelimiter textlineDelimiter) {
            doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mina.MinaTextLineDelimiter&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param textlineDelimiter the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder textlineDelimiter(
                String textlineDelimiter) {
            doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MinaEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Mina component.
     */
    public interface AdvancedMinaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MinaEndpointConsumerBuilder basic() {
            return (MinaEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * If sync is enabled this option dictates MinaConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder noReplyLogLevel(
                org.apache.camel.LoggingLevel noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If sync is enabled this option dictates MinaConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder noReplyLogLevel(
                String noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder disconnectOnNoReply(
                boolean disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder disconnectOnNoReply(
                String disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 16
         * Group: advanced
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder maximumPoolSize(
                int maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 16
         * Group: advanced
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder maximumPoolSize(
                String maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param orderedThreadPoolExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder orderedThreadPoolExecutor(
                boolean orderedThreadPoolExecutor) {
            doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param orderedThreadPoolExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder orderedThreadPoolExecutor(
                String orderedThreadPoolExecutor) {
            doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointConsumerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Mina component.
     */
    public interface MinaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMinaEndpointProducerBuilder advanced() {
            return (AdvancedMinaEndpointProducerBuilder) this;
        }
        /**
         * Whether to disconnect(close) from Mina session right after use. Can
         * be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether to disconnect(close) from Mina session right after use. Can
         * be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param minaLogger the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder minaLogger(boolean minaLogger) {
            doSetProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param minaLogger the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder minaLogger(String minaLogger) {
            doSetProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder writeTimeout(long writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder allowDefaultCodec(
                boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder allowDefaultCodec(
                String allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.mina.filter.codec.ProtocolCodecFactory&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param codec the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder codec(
                org.apache.mina.filter.codec.ProtocolCodecFactory codec) {
            doSetProperty("codec", codec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.mina.filter.codec.ProtocolCodecFactory&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param codec the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder codec(String codec) {
            doSetProperty("codec", codec);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: codec
         * 
         * @param encoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder encoderMaxLineLength(
                int encoderMaxLineLength) {
            doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: codec
         * 
         * @param encoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder encoderMaxLineLength(
                String encoderMaxLineLength) {
            doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * You can configure the encoding (a charset name) to use for the TCP
         * textline codec and the UDP protocol. If not provided, Camel will use
         * the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;org.apache.mina.core.filterchain.IoFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder filters(
                List<org.apache.mina.core.filterchain.IoFilter> filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;org.apache.mina.core.filterchain.IoFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder filters(String filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder textline(String textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mina.MinaTextLineDelimiter&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param textlineDelimiter the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder textlineDelimiter(
                org.apache.camel.component.mina.MinaTextLineDelimiter textlineDelimiter) {
            doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mina.MinaTextLineDelimiter&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param textlineDelimiter the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder textlineDelimiter(
                String textlineDelimiter) {
            doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MinaEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Mina component.
     */
    public interface AdvancedMinaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MinaEndpointProducerBuilder basic() {
            return (MinaEndpointProducerBuilder) this;
        }
        /**
         * Whether to create the InetAddress once and reuse. Setting this to
         * false allows to pickup DNS changes in the network.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param cachedAddress the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder cachedAddress(
                boolean cachedAddress) {
            doSetProperty("cachedAddress", cachedAddress);
            return this;
        }
        /**
         * Whether to create the InetAddress once and reuse. Setting this to
         * false allows to pickup DNS changes in the network.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param cachedAddress the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder cachedAddress(
                String cachedAddress) {
            doSetProperty("cachedAddress", cachedAddress);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazySessionCreation the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder lazySessionCreation(
                boolean lazySessionCreation) {
            doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazySessionCreation the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder lazySessionCreation(
                String lazySessionCreation) {
            doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder disconnectOnNoReply(
                boolean disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder disconnectOnNoReply(
                String disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 16
         * Group: advanced
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder maximumPoolSize(
                int maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 16
         * Group: advanced
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder maximumPoolSize(
                String maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param orderedThreadPoolExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder orderedThreadPoolExecutor(
                boolean orderedThreadPoolExecutor) {
            doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param orderedThreadPoolExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder orderedThreadPoolExecutor(
                String orderedThreadPoolExecutor) {
            doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointProducerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Mina component.
     */
    public interface MinaEndpointBuilder
            extends
                MinaEndpointConsumerBuilder,
                MinaEndpointProducerBuilder {
        default AdvancedMinaEndpointBuilder advanced() {
            return (AdvancedMinaEndpointBuilder) this;
        }
        /**
         * Whether to disconnect(close) from Mina session right after use. Can
         * be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether to disconnect(close) from Mina session right after use. Can
         * be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param minaLogger the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder minaLogger(boolean minaLogger) {
            doSetProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * You can enable the Apache MINA logging filter. Apache MINA uses slf4j
         * logging at INFO level to log all input and output.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param minaLogger the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder minaLogger(String minaLogger) {
            doSetProperty("minaLogger", minaLogger);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * You can configure the timeout that specifies how long to wait for a
         * response from a remote server. The timeout unit is in milliseconds,
         * so 60000 is 60 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder writeTimeout(long writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Maximum amount of time it should take to send data to the MINA
         * session. Default is 10000 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * The mina component installs a default codec if both, codec is null
         * and textline is false. Setting allowDefaultCodec to false prevents
         * the mina component from installing a default codec as the first
         * element in the filter chain. This is useful in scenarios where
         * another filter must be the first in the filter chain, like the SSL
         * filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: codec
         * 
         * @param allowDefaultCodec the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder allowDefaultCodec(String allowDefaultCodec) {
            doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.mina.filter.codec.ProtocolCodecFactory&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param codec the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder codec(
                org.apache.mina.filter.codec.ProtocolCodecFactory codec) {
            doSetProperty("codec", codec);
            return this;
        }
        /**
         * To use a custom minda codec implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.mina.filter.codec.ProtocolCodecFactory&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param codec the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder codec(String codec) {
            doSetProperty("codec", codec);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder decoderMaxLineLength(
                int decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol decoder max line length. By default the
         * default value of Mina itself is used which are 1024.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: codec
         * 
         * @param decoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder decoderMaxLineLength(
                String decoderMaxLineLength) {
            doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: codec
         * 
         * @param encoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder encoderMaxLineLength(
                int encoderMaxLineLength) {
            doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * To set the textline protocol encoder max line length. By default the
         * default value of Mina itself is used which are Integer.MAX_VALUE.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: codec
         * 
         * @param encoderMaxLineLength the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder encoderMaxLineLength(
                String encoderMaxLineLength) {
            doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }
        /**
         * You can configure the encoding (a charset name) to use for the TCP
         * textline codec and the UDP protocol. If not provided, Camel will use
         * the JVM default Charset.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;org.apache.mina.core.filterchain.IoFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder filters(
                List<org.apache.mina.core.filterchain.IoFilter> filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * You can set a list of Mina IoFilters to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;org.apache.mina.core.filterchain.IoFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder filters(String filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder textline(boolean textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP. If no codec is specified, you can use this flag to
         * indicate a text line based codec; if not specified or the value is
         * false, then Object Serialization is assumed over TCP.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: codec
         * 
         * @param textline the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder textline(String textline) {
            doSetProperty("textline", textline);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mina.MinaTextLineDelimiter&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param textlineDelimiter the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder textlineDelimiter(
                org.apache.camel.component.mina.MinaTextLineDelimiter textlineDelimiter) {
            doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * Only used for TCP and if textline=true. Sets the text line delimiter
         * to use. If none provided, Camel will use DEFAULT. This delimiter is
         * used to mark the end of text.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mina.MinaTextLineDelimiter&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param textlineDelimiter the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder textlineDelimiter(String textlineDelimiter) {
            doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure SSL security.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MinaEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Mina component.
     */
    public interface AdvancedMinaEndpointBuilder
            extends
                AdvancedMinaEndpointConsumerBuilder,
                AdvancedMinaEndpointProducerBuilder {
        default MinaEndpointBuilder basic() {
            return (MinaEndpointBuilder) this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder disconnectOnNoReply(
                boolean disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * If sync is enabled then this option dictates MinaConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder disconnectOnNoReply(
                String disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 16
         * Group: advanced
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder maximumPoolSize(int maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Number of worker threads in the worker pool for TCP and UDP.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 16
         * Group: advanced
         * 
         * @param maximumPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder maximumPoolSize(
                String maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param orderedThreadPoolExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder orderedThreadPoolExecutor(
                boolean orderedThreadPoolExecutor) {
            doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param orderedThreadPoolExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder orderedThreadPoolExecutor(
                String orderedThreadPoolExecutor) {
            doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMinaEndpointBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
    }

    public interface MinaBuilders {
        /**
         * Mina (camel-mina)
         * Socket level networking using TCP or UDP with Apache Mina 2.x.
         * 
         * Category: networking
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-mina
         * 
         * @return the dsl builder for the headers' name.
         */
        default MinaHeaderNameBuilder mina() {
            return MinaHeaderNameBuilder.INSTANCE;
        }
        /**
         * Mina (camel-mina)
         * Socket level networking using TCP or UDP with Apache Mina 2.x.
         * 
         * Category: networking
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-mina
         * 
         * Syntax: <code>mina:protocol:host:port</code>
         * 
         * Path parameter: protocol (required)
         * Protocol to use
         * 
         * Path parameter: host (required)
         * Hostname to use. Use localhost or 0.0.0.0 for local server as
         * consumer. For producer use the hostname or ip address of the remote
         * server.
         * 
         * Path parameter: port (required)
         * Port number
         * 
         * @param path protocol:host:port
         * @return the dsl builder
         */
        default MinaEndpointBuilder mina(String path) {
            return MinaEndpointBuilderFactory.endpointBuilder("mina", path);
        }
        /**
         * Mina (camel-mina)
         * Socket level networking using TCP or UDP with Apache Mina 2.x.
         * 
         * Category: networking
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-mina
         * 
         * Syntax: <code>mina:protocol:host:port</code>
         * 
         * Path parameter: protocol (required)
         * Protocol to use
         * 
         * Path parameter: host (required)
         * Hostname to use. Use localhost or 0.0.0.0 for local server as
         * consumer. For producer use the hostname or ip address of the remote
         * server.
         * 
         * Path parameter: port (required)
         * Port number
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path protocol:host:port
         * @return the dsl builder
         */
        default MinaEndpointBuilder mina(String componentName, String path) {
            return MinaEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Mina component.
     */
    public static class MinaHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final MinaHeaderNameBuilder INSTANCE = new MinaHeaderNameBuilder();

        /**
         * Indicates whether the session should be closed after complete.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MinaCloseSessionWhenComplete}.
         */
        public String minaCloseSessionWhenComplete() {
            return "MinaCloseSessionWhenComplete";
        }

        /**
         * The key of the IoSession which is stored in the message header.
         * 
         * The option is a: {@code org.apache.mina.core.session.IoSession} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MinaIoSession}.
         */
        public String minaIoSession() {
            return "MinaIoSession";
        }

        /**
         * The socket address of local machine that received the message.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MinaLocalAddress}.
         */
        public String minaLocalAddress() {
            return "MinaLocalAddress";
        }

        /**
         * The socket address of the remote machine that send the message.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MinaRemoteAddress}.
         */
        public String minaRemoteAddress() {
            return "MinaRemoteAddress";
        }
    }
    static MinaEndpointBuilder endpointBuilder(String componentName, String path) {
        class MinaEndpointBuilderImpl extends AbstractEndpointBuilder implements MinaEndpointBuilder, AdvancedMinaEndpointBuilder {
            public MinaEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MinaEndpointBuilderImpl(path);
    }
}