/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.azure.storage.datalake.springboot;

import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Set;
import com.azure.core.credential.AzureSasCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import org.apache.camel.component.azure.storage.datalake.DataLakeComponent;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Sends and receives files to/from Azure DataLake Storage.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.azure-storage-datalake")
public class DataLakeComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the azure-storage-datalake
     * component. This is enabled by default.
     */
    private Boolean enabled;
    /**
     * client id for azure account
     */
    private String clientId;
    /**
     * Whether or not a file changed event raised indicates completion (true) or
     * modification (false)
     */
    private Boolean close;
    /**
     * check for closing stream after read
     */
    private Boolean closeStreamAfterRead;
    /**
     * configuration object for datalake. The option is a
     * org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration
     * type.
     */
    private DataLakeConfiguration configuration;
    /**
     * count number of bytes to download
     */
    private Long dataCount;
    /**
     * directory of the file to be handled in component
     */
    private String directoryName;
    /**
     * download link expiration time
     */
    private Long downloadLinkExpiration;
    /**
     * expression for queryInputStream
     */
    private String expression;
    /**
     * directory of file to do operations in the local system
     */
    private String fileDir;
    /**
     * name of file to be handled in component
     */
    private String fileName;
    /**
     * offset position in file for different operations
     */
    private Long fileOffset;
    /**
     * maximum number of results to show at a time
     */
    private Integer maxResults;
    /**
     * no of retries to a given request
     */
    private Integer maxRetryRequests;
    /**
     * set open options for creating file
     */
    private Set<OpenOption> openOptions;
    /**
     * path in azure datalake for operations
     */
    private String path;
    /**
     * permission string for the file
     */
    private String permission;
    /**
     * This parameter allows the caller to upload data in parallel and control
     * the order in which it is appended to the file.
     */
    private Long position;
    /**
     * recursively include all paths
     */
    private Boolean recursive;
    /**
     * regular expression for matching file names
     */
    private String regex;
    /**
     * Whether or not uncommitted data is to be retained after the operation
     */
    private Boolean retainUncommitedData;
    /**
     * datalake service client for azure storage datalake. The option is a
     * com.azure.storage.file.datalake.DataLakeServiceClient type.
     */
    private DataLakeServiceClient serviceClient;
    /**
     * shared key credential for azure datalake gen2. The option is a
     * com.azure.storage.common.StorageSharedKeyCredential type.
     */
    private StorageSharedKeyCredential sharedKeyCredential;
    /**
     * tenant id for azure account
     */
    private String tenantId;
    /**
     * Timeout for operation. The option is a java.time.Duration type.
     */
    private Duration timeout;
    /**
     * umask permission for file
     */
    private String umask;
    /**
     * whether or not to use upn
     */
    private Boolean userPrincipalNameReturned;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * operation to be performed
     */
    private DataLakeOperationsDefinition operation = DataLakeOperationsDefinition.listFileSystem;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Used for enabling or disabling all consumer based health checks from this
     * component
     */
    private Boolean healthCheckConsumerEnabled = true;
    /**
     * Used for enabling or disabling all producer based health checks from this
     * component. Notice: Camel has by default disabled all producer based
     * health-checks. You can turn on producer checks globally by setting
     * camel.health.producersEnabled=true.
     */
    private Boolean healthCheckProducerEnabled = true;
    /**
     * account key for authentication
     */
    private String accountKey;
    /**
     * client secret for azure account
     */
    private String clientSecret;
    /**
     * client secret credential for authentication. The option is a
     * com.azure.identity.ClientSecretCredential type.
     */
    private ClientSecretCredential clientSecretCredential;
    /**
     * SAS token credential. The option is a
     * com.azure.core.credential.AzureSasCredential type.
     */
    private AzureSasCredential sasCredential;
    /**
     * SAS token signature
     */
    private String sasSignature;
    /**
     * Use default identity
     */
    private Boolean useDefaultIdentity;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Boolean getClose() {
        return close;
    }

    public void setClose(Boolean close) {
        this.close = close;
    }

    public Boolean getCloseStreamAfterRead() {
        return closeStreamAfterRead;
    }

    public void setCloseStreamAfterRead(Boolean closeStreamAfterRead) {
        this.closeStreamAfterRead = closeStreamAfterRead;
    }

    public DataLakeConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(DataLakeConfiguration configuration) {
        this.configuration = configuration;
    }

    public Long getDataCount() {
        return dataCount;
    }

    public void setDataCount(Long dataCount) {
        this.dataCount = dataCount;
    }

    public String getDirectoryName() {
        return directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public Long getDownloadLinkExpiration() {
        return downloadLinkExpiration;
    }

    public void setDownloadLinkExpiration(Long downloadLinkExpiration) {
        this.downloadLinkExpiration = downloadLinkExpiration;
    }

    public String getExpression() {
        return expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getFileDir() {
        return fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileOffset() {
        return fileOffset;
    }

    public void setFileOffset(Long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public Integer getMaxResults() {
        return maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxRetryRequests() {
        return maxRetryRequests;
    }

    public void setMaxRetryRequests(Integer maxRetryRequests) {
        this.maxRetryRequests = maxRetryRequests;
    }

    public Set<OpenOption> getOpenOptions() {
        return openOptions;
    }

    public void setOpenOptions(Set<OpenOption> openOptions) {
        this.openOptions = openOptions;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPermission() {
        return permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public Long getPosition() {
        return position;
    }

    public void setPosition(Long position) {
        this.position = position;
    }

    public Boolean getRecursive() {
        return recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public String getRegex() {
        return regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public Boolean getRetainUncommitedData() {
        return retainUncommitedData;
    }

    public void setRetainUncommitedData(Boolean retainUncommitedData) {
        this.retainUncommitedData = retainUncommitedData;
    }

    public DataLakeServiceClient getServiceClient() {
        return serviceClient;
    }

    public void setServiceClient(DataLakeServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public StorageSharedKeyCredential getSharedKeyCredential() {
        return sharedKeyCredential;
    }

    public void setSharedKeyCredential(
            StorageSharedKeyCredential sharedKeyCredential) {
        this.sharedKeyCredential = sharedKeyCredential;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Duration getTimeout() {
        return timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public String getUmask() {
        return umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public Boolean getUserPrincipalNameReturned() {
        return userPrincipalNameReturned;
    }

    public void setUserPrincipalNameReturned(Boolean userPrincipalNameReturned) {
        this.userPrincipalNameReturned = userPrincipalNameReturned;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public DataLakeOperationsDefinition getOperation() {
        return operation;
    }

    public void setOperation(DataLakeOperationsDefinition operation) {
        this.operation = operation;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public Boolean getHealthCheckConsumerEnabled() {
        return healthCheckConsumerEnabled;
    }

    public void setHealthCheckConsumerEnabled(Boolean healthCheckConsumerEnabled) {
        this.healthCheckConsumerEnabled = healthCheckConsumerEnabled;
    }

    public Boolean getHealthCheckProducerEnabled() {
        return healthCheckProducerEnabled;
    }

    public void setHealthCheckProducerEnabled(Boolean healthCheckProducerEnabled) {
        this.healthCheckProducerEnabled = healthCheckProducerEnabled;
    }

    public String getAccountKey() {
        return accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public ClientSecretCredential getClientSecretCredential() {
        return clientSecretCredential;
    }

    public void setClientSecretCredential(
            ClientSecretCredential clientSecretCredential) {
        this.clientSecretCredential = clientSecretCredential;
    }

    public AzureSasCredential getSasCredential() {
        return sasCredential;
    }

    public void setSasCredential(AzureSasCredential sasCredential) {
        this.sasCredential = sasCredential;
    }

    public String getSasSignature() {
        return sasSignature;
    }

    public void setSasSignature(String sasSignature) {
        this.sasSignature = sasSignature;
    }

    public Boolean getUseDefaultIdentity() {
        return useDefaultIdentity;
    }

    public void setUseDefaultIdentity(Boolean useDefaultIdentity) {
        this.useDefaultIdentity = useDefaultIdentity;
    }
}