/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Poll the weather information from Open Weather Map.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WeatherEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Weather component.
     */
    public interface WeatherEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWeatherEndpointConsumerBuilder advanced() {
            return (AdvancedWeatherEndpointConsumerBuilder) this;
        }
        /**
         * APPID ID used to authenticate the user connected to the API Server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param appid the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder appid(String appid) {
            doSetProperty("appid", appid);
            return this;
        }
        /**
         * To store the weather result in this header instead of the message
         * body. This is useable if you want to keep current message body as-is.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param headerName the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder headerName(String headerName) {
            doSetProperty("headerName", headerName);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherLanguage&lt;/code&gt; type.
         * 
         * Default: en
         * Group: common
         * 
         * @param language the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder language(
                org.apache.camel.component.weather.WeatherLanguage language) {
            doSetProperty("language", language);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherLanguage&lt;/code&gt; type.
         * 
         * Default: en
         * Group: common
         * 
         * @param language the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder language(String language) {
            doSetProperty("language", language);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherMode&lt;/code&gt; type.
         * 
         * Default: JSON
         * Group: common
         * 
         * @param mode the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder mode(
                org.apache.camel.component.weather.WeatherMode mode) {
            doSetProperty("mode", mode);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherMode&lt;/code&gt; type.
         * 
         * Default: JSON
         * Group: common
         * 
         * @param mode the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder mode(String mode) {
            doSetProperty("mode", mode);
            return this;
        }
        /**
         * If null, the current weather will be returned, else use values of 5,
         * 7, 14 days. Only the numeric value for the forecast period is
         * actually parsed, so spelling, capitalisation of the time period is up
         * to you (its ignored).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param period the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder period(String period) {
            doSetProperty("period", period);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherUnits&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param units the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder units(
                org.apache.camel.component.weather.WeatherUnits units) {
            doSetProperty("units", units);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherUnits&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param units the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder units(String units) {
            doSetProperty("units", units);
            return this;
        }
        /**
         * The API to use (current, forecast/3 hour, forecast daily, station).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherApi&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param weatherApi the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder weatherApi(
                org.apache.camel.component.weather.WeatherApi weatherApi) {
            doSetProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * The API to use (current, forecast/3 hour, forecast daily, station).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherApi&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param weatherApi the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder weatherApi(String weatherApi) {
            doSetProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param cnt the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder cnt(Integer cnt) {
            doSetProperty("cnt", cnt);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param cnt the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder cnt(String cnt) {
            doSetProperty("cnt", cnt);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Latitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the bottom latitude.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param lat the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder lat(String lat) {
            doSetProperty("lat", lat);
            return this;
        }
        /**
         * If null Camel will try and determine your current location using the
         * geolocation of your ip address, else specify the city,country. For
         * well known city names, Open Weather Map will determine the best fit,
         * but multiple results may be returned. Hence specifying and country as
         * well will return more accurate data. If you specify current as the
         * location then the component will try to get the current latitude and
         * longitude and use that to get the weather details. You can use lat
         * and lon options instead of location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder location(String location) {
            doSetProperty("location", location);
            return this;
        }
        /**
         * Longitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the left longtitude.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param lon the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder lon(String lon) {
            doSetProperty("lon", lon);
            return this;
        }
        /**
         * For boxed queries this is the right longtitude. Needs to be used in
         * combination with topLat and zoom.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param rightLon the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder rightLon(String rightLon) {
            doSetProperty("rightLon", rightLon);
            return this;
        }
        /**
         * For boxed queries this is the top latitude. Needs to be used in
         * combination with rightLon and zoom.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param topLat the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder topLat(String topLat) {
            doSetProperty("topLat", topLat);
            return this;
        }
        /**
         * Zip-code, e.g. 94040,us.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zip the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder zip(String zip) {
            doSetProperty("zip", zip);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zoom the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder zoom(Integer zoom) {
            doSetProperty("zoom", zoom);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zoom the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder zoom(String zoom) {
            doSetProperty("zoom", zoom);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The geolocation service now needs an accessKey to be used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param geolocationAccessKey the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder geolocationAccessKey(
                String geolocationAccessKey) {
            doSetProperty("geolocationAccessKey", geolocationAccessKey);
            return this;
        }
        /**
         * The geolocation service now needs to specify the IP associated to the
         * accessKey you're using.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param geolocationRequestHostIP the value to set
         * @return the dsl builder
         */
        default WeatherEndpointConsumerBuilder geolocationRequestHostIP(
                String geolocationRequestHostIP) {
            doSetProperty("geolocationRequestHostIP", geolocationRequestHostIP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Weather component.
     */
    public interface AdvancedWeatherEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WeatherEndpointConsumerBuilder basic() {
            return (WeatherEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A custum geolocation provider to determine the longitude and latitude
         * to use when no location information is set. The default implementaion
         * uses the ipstack API and requires geolocationAccessKey and
         * geolocationRequestHostIP.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.geolocation.GeoLocationProvider&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param geoLocationProvider the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder geoLocationProvider(
                org.apache.camel.component.weather.geolocation.GeoLocationProvider geoLocationProvider) {
            doSetProperty("geoLocationProvider", geoLocationProvider);
            return this;
        }
        /**
         * A custum geolocation provider to determine the longitude and latitude
         * to use when no location information is set. The default implementaion
         * uses the ipstack API and requires geolocationAccessKey and
         * geolocationRequestHostIP.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.geolocation.GeoLocationProvider&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param geoLocationProvider the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder geoLocationProvider(
                String geoLocationProvider) {
            doSetProperty("geoLocationProvider", geoLocationProvider);
            return this;
        }
        /**
         * To use an existing configured http client (for example with http
         * proxy).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.client5.http.impl.classic.CloseableHttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder httpClient(
                org.apache.hc.client5.http.impl.classic.CloseableHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * To use an existing configured http client (for example with http
         * proxy).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.hc.client5.http.impl.classic.CloseableHttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointConsumerBuilder httpClient(
                String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Weather component.
     */
    public interface WeatherEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWeatherEndpointProducerBuilder advanced() {
            return (AdvancedWeatherEndpointProducerBuilder) this;
        }
        /**
         * APPID ID used to authenticate the user connected to the API Server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param appid the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder appid(String appid) {
            doSetProperty("appid", appid);
            return this;
        }
        /**
         * To store the weather result in this header instead of the message
         * body. This is useable if you want to keep current message body as-is.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param headerName the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder headerName(String headerName) {
            doSetProperty("headerName", headerName);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherLanguage&lt;/code&gt; type.
         * 
         * Default: en
         * Group: common
         * 
         * @param language the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder language(
                org.apache.camel.component.weather.WeatherLanguage language) {
            doSetProperty("language", language);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherLanguage&lt;/code&gt; type.
         * 
         * Default: en
         * Group: common
         * 
         * @param language the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder language(String language) {
            doSetProperty("language", language);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherMode&lt;/code&gt; type.
         * 
         * Default: JSON
         * Group: common
         * 
         * @param mode the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder mode(
                org.apache.camel.component.weather.WeatherMode mode) {
            doSetProperty("mode", mode);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherMode&lt;/code&gt; type.
         * 
         * Default: JSON
         * Group: common
         * 
         * @param mode the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder mode(String mode) {
            doSetProperty("mode", mode);
            return this;
        }
        /**
         * If null, the current weather will be returned, else use values of 5,
         * 7, 14 days. Only the numeric value for the forecast period is
         * actually parsed, so spelling, capitalisation of the time period is up
         * to you (its ignored).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param period the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder period(String period) {
            doSetProperty("period", period);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherUnits&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param units the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder units(
                org.apache.camel.component.weather.WeatherUnits units) {
            doSetProperty("units", units);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherUnits&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param units the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder units(String units) {
            doSetProperty("units", units);
            return this;
        }
        /**
         * The API to use (current, forecast/3 hour, forecast daily, station).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherApi&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param weatherApi the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder weatherApi(
                org.apache.camel.component.weather.WeatherApi weatherApi) {
            doSetProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * The API to use (current, forecast/3 hour, forecast daily, station).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherApi&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param weatherApi the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder weatherApi(String weatherApi) {
            doSetProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param cnt the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder cnt(Integer cnt) {
            doSetProperty("cnt", cnt);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param cnt the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder cnt(String cnt) {
            doSetProperty("cnt", cnt);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Latitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the bottom latitude.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param lat the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder lat(String lat) {
            doSetProperty("lat", lat);
            return this;
        }
        /**
         * If null Camel will try and determine your current location using the
         * geolocation of your ip address, else specify the city,country. For
         * well known city names, Open Weather Map will determine the best fit,
         * but multiple results may be returned. Hence specifying and country as
         * well will return more accurate data. If you specify current as the
         * location then the component will try to get the current latitude and
         * longitude and use that to get the weather details. You can use lat
         * and lon options instead of location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder location(String location) {
            doSetProperty("location", location);
            return this;
        }
        /**
         * Longitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the left longtitude.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param lon the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder lon(String lon) {
            doSetProperty("lon", lon);
            return this;
        }
        /**
         * For boxed queries this is the right longtitude. Needs to be used in
         * combination with topLat and zoom.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param rightLon the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder rightLon(String rightLon) {
            doSetProperty("rightLon", rightLon);
            return this;
        }
        /**
         * For boxed queries this is the top latitude. Needs to be used in
         * combination with rightLon and zoom.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param topLat the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder topLat(String topLat) {
            doSetProperty("topLat", topLat);
            return this;
        }
        /**
         * Zip-code, e.g. 94040,us.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zip the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder zip(String zip) {
            doSetProperty("zip", zip);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zoom the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder zoom(Integer zoom) {
            doSetProperty("zoom", zoom);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zoom the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder zoom(String zoom) {
            doSetProperty("zoom", zoom);
            return this;
        }
        /**
         * The geolocation service now needs an accessKey to be used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param geolocationAccessKey the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder geolocationAccessKey(
                String geolocationAccessKey) {
            doSetProperty("geolocationAccessKey", geolocationAccessKey);
            return this;
        }
        /**
         * The geolocation service now needs to specify the IP associated to the
         * accessKey you're using.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param geolocationRequestHostIP the value to set
         * @return the dsl builder
         */
        default WeatherEndpointProducerBuilder geolocationRequestHostIP(
                String geolocationRequestHostIP) {
            doSetProperty("geolocationRequestHostIP", geolocationRequestHostIP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Weather component.
     */
    public interface AdvancedWeatherEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WeatherEndpointProducerBuilder basic() {
            return (WeatherEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * A custum geolocation provider to determine the longitude and latitude
         * to use when no location information is set. The default implementaion
         * uses the ipstack API and requires geolocationAccessKey and
         * geolocationRequestHostIP.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.geolocation.GeoLocationProvider&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param geoLocationProvider the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointProducerBuilder geoLocationProvider(
                org.apache.camel.component.weather.geolocation.GeoLocationProvider geoLocationProvider) {
            doSetProperty("geoLocationProvider", geoLocationProvider);
            return this;
        }
        /**
         * A custum geolocation provider to determine the longitude and latitude
         * to use when no location information is set. The default implementaion
         * uses the ipstack API and requires geolocationAccessKey and
         * geolocationRequestHostIP.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.geolocation.GeoLocationProvider&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param geoLocationProvider the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointProducerBuilder geoLocationProvider(
                String geoLocationProvider) {
            doSetProperty("geoLocationProvider", geoLocationProvider);
            return this;
        }
        /**
         * To use an existing configured http client (for example with http
         * proxy).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.client5.http.impl.classic.CloseableHttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointProducerBuilder httpClient(
                org.apache.hc.client5.http.impl.classic.CloseableHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * To use an existing configured http client (for example with http
         * proxy).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.hc.client5.http.impl.classic.CloseableHttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointProducerBuilder httpClient(
                String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Weather component.
     */
    public interface WeatherEndpointBuilder
            extends
                WeatherEndpointConsumerBuilder,
                WeatherEndpointProducerBuilder {
        default AdvancedWeatherEndpointBuilder advanced() {
            return (AdvancedWeatherEndpointBuilder) this;
        }
        /**
         * APPID ID used to authenticate the user connected to the API Server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param appid the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder appid(String appid) {
            doSetProperty("appid", appid);
            return this;
        }
        /**
         * To store the weather result in this header instead of the message
         * body. This is useable if you want to keep current message body as-is.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param headerName the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder headerName(String headerName) {
            doSetProperty("headerName", headerName);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherLanguage&lt;/code&gt; type.
         * 
         * Default: en
         * Group: common
         * 
         * @param language the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder language(
                org.apache.camel.component.weather.WeatherLanguage language) {
            doSetProperty("language", language);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherLanguage&lt;/code&gt; type.
         * 
         * Default: en
         * Group: common
         * 
         * @param language the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder language(String language) {
            doSetProperty("language", language);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherMode&lt;/code&gt; type.
         * 
         * Default: JSON
         * Group: common
         * 
         * @param mode the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder mode(
                org.apache.camel.component.weather.WeatherMode mode) {
            doSetProperty("mode", mode);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherMode&lt;/code&gt; type.
         * 
         * Default: JSON
         * Group: common
         * 
         * @param mode the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder mode(String mode) {
            doSetProperty("mode", mode);
            return this;
        }
        /**
         * If null, the current weather will be returned, else use values of 5,
         * 7, 14 days. Only the numeric value for the forecast period is
         * actually parsed, so spelling, capitalisation of the time period is up
         * to you (its ignored).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param period the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder period(String period) {
            doSetProperty("period", period);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherUnits&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param units the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder units(
                org.apache.camel.component.weather.WeatherUnits units) {
            doSetProperty("units", units);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherUnits&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param units the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder units(String units) {
            doSetProperty("units", units);
            return this;
        }
        /**
         * The API to use (current, forecast/3 hour, forecast daily, station).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.WeatherApi&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param weatherApi the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder weatherApi(
                org.apache.camel.component.weather.WeatherApi weatherApi) {
            doSetProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * The API to use (current, forecast/3 hour, forecast daily, station).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.WeatherApi&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param weatherApi the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder weatherApi(String weatherApi) {
            doSetProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param cnt the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder cnt(Integer cnt) {
            doSetProperty("cnt", cnt);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param cnt the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder cnt(String cnt) {
            doSetProperty("cnt", cnt);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Latitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the bottom latitude.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param lat the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder lat(String lat) {
            doSetProperty("lat", lat);
            return this;
        }
        /**
         * If null Camel will try and determine your current location using the
         * geolocation of your ip address, else specify the city,country. For
         * well known city names, Open Weather Map will determine the best fit,
         * but multiple results may be returned. Hence specifying and country as
         * well will return more accurate data. If you specify current as the
         * location then the component will try to get the current latitude and
         * longitude and use that to get the weather details. You can use lat
         * and lon options instead of location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder location(String location) {
            doSetProperty("location", location);
            return this;
        }
        /**
         * Longitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the left longtitude.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param lon the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder lon(String lon) {
            doSetProperty("lon", lon);
            return this;
        }
        /**
         * For boxed queries this is the right longtitude. Needs to be used in
         * combination with topLat and zoom.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param rightLon the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder rightLon(String rightLon) {
            doSetProperty("rightLon", rightLon);
            return this;
        }
        /**
         * For boxed queries this is the top latitude. Needs to be used in
         * combination with rightLon and zoom.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param topLat the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder topLat(String topLat) {
            doSetProperty("topLat", topLat);
            return this;
        }
        /**
         * Zip-code, e.g. 94040,us.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zip the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder zip(String zip) {
            doSetProperty("zip", zip);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zoom the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder zoom(Integer zoom) {
            doSetProperty("zoom", zoom);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param zoom the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder zoom(String zoom) {
            doSetProperty("zoom", zoom);
            return this;
        }
        /**
         * The geolocation service now needs an accessKey to be used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param geolocationAccessKey the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder geolocationAccessKey(
                String geolocationAccessKey) {
            doSetProperty("geolocationAccessKey", geolocationAccessKey);
            return this;
        }
        /**
         * The geolocation service now needs to specify the IP associated to the
         * accessKey you're using.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param geolocationRequestHostIP the value to set
         * @return the dsl builder
         */
        default WeatherEndpointBuilder geolocationRequestHostIP(
                String geolocationRequestHostIP) {
            doSetProperty("geolocationRequestHostIP", geolocationRequestHostIP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Weather component.
     */
    public interface AdvancedWeatherEndpointBuilder
            extends
                AdvancedWeatherEndpointConsumerBuilder,
                AdvancedWeatherEndpointProducerBuilder {
        default WeatherEndpointBuilder basic() {
            return (WeatherEndpointBuilder) this;
        }
        /**
         * A custum geolocation provider to determine the longitude and latitude
         * to use when no location information is set. The default implementaion
         * uses the ipstack API and requires geolocationAccessKey and
         * geolocationRequestHostIP.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weather.geolocation.GeoLocationProvider&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param geoLocationProvider the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointBuilder geoLocationProvider(
                org.apache.camel.component.weather.geolocation.GeoLocationProvider geoLocationProvider) {
            doSetProperty("geoLocationProvider", geoLocationProvider);
            return this;
        }
        /**
         * A custum geolocation provider to determine the longitude and latitude
         * to use when no location information is set. The default implementaion
         * uses the ipstack API and requires geolocationAccessKey and
         * geolocationRequestHostIP.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.weather.geolocation.GeoLocationProvider&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param geoLocationProvider the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointBuilder geoLocationProvider(
                String geoLocationProvider) {
            doSetProperty("geoLocationProvider", geoLocationProvider);
            return this;
        }
        /**
         * To use an existing configured http client (for example with http
         * proxy).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.client5.http.impl.classic.CloseableHttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointBuilder httpClient(
                org.apache.hc.client5.http.impl.classic.CloseableHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * To use an existing configured http client (for example with http
         * proxy).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.hc.client5.http.impl.classic.CloseableHttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWeatherEndpointBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
    }

    public interface WeatherBuilders {
        /**
         * Weather (camel-weather)
         * Poll the weather information from Open Weather Map.
         * 
         * Category: api
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-weather
         * 
         * @return the dsl builder for the headers' name.
         */
        default WeatherHeaderNameBuilder weather() {
            return WeatherHeaderNameBuilder.INSTANCE;
        }
        /**
         * Weather (camel-weather)
         * Poll the weather information from Open Weather Map.
         * 
         * Category: api
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-weather
         * 
         * Syntax: <code>weather:name</code>
         * 
         * Path parameter: name (required)
         * The name value is not used.
         * 
         * @param path name
         * @return the dsl builder
         */
        default WeatherEndpointBuilder weather(String path) {
            return WeatherEndpointBuilderFactory.endpointBuilder("weather", path);
        }
        /**
         * Weather (camel-weather)
         * Poll the weather information from Open Weather Map.
         * 
         * Category: api
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-weather
         * 
         * Syntax: <code>weather:name</code>
         * 
         * Path parameter: name (required)
         * The name value is not used.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default WeatherEndpointBuilder weather(String componentName, String path) {
            return WeatherEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Weather component.
     */
    public static class WeatherHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WeatherHeaderNameBuilder INSTANCE = new WeatherHeaderNameBuilder();

        /**
         * Used by the producer to override the endpoint location and use the
         * location from this header instead.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeatherLocation}.
         */
        public String weatherLocation() {
            return "CamelWeatherLocation";
        }

        /**
         * The original query URL sent to the Open Weather Map site.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code WeatherQuery}.
         */
        public String weatherQuery() {
            return "CamelWeatherQuery";
        }
    }
    static WeatherEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class WeatherEndpointBuilderImpl extends AbstractEndpointBuilder implements WeatherEndpointBuilder, AdvancedWeatherEndpointBuilder {
            public WeatherEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WeatherEndpointBuilderImpl(path);
    }
}