/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * IEC 60870 supervisory control and data acquisition (SCADA) client using
 * NeoSCADA implementation.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ClientEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IEC 60870 Client component.
     */
    public interface ClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedClientEndpointConsumerBuilder advanced() {
            return (AdvancedClientEndpointConsumerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder dataModuleOptions(
                org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder dataModuleOptions(
                String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder protocolOptions(
                org.eclipse.neoscada.protocol.iec60870.ProtocolOptions protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder protocolOptions(
                String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder adsuAddressType(
                org.eclipse.neoscada.protocol.iec60870.ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder adsuAddressType(
                String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder causeOfTransmissionType(
                org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder informationObjectAddressType(
                org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: id
         * 
         * @param connectionId the value to set
         * @return the dsl builder
         */
        default ClientEndpointConsumerBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IEC 60870 Client
     * component.
     */
    public interface AdvancedClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ClientEndpointConsumerBuilder basic() {
            return (ClientEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IEC 60870 Client component.
     */
    public interface ClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedClientEndpointProducerBuilder advanced() {
            return (AdvancedClientEndpointProducerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder dataModuleOptions(
                org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder dataModuleOptions(
                String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder protocolOptions(
                org.eclipse.neoscada.protocol.iec60870.ProtocolOptions protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder protocolOptions(
                String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder adsuAddressType(
                org.eclipse.neoscada.protocol.iec60870.ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder adsuAddressType(
                String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder causeOfTransmissionType(
                org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder informationObjectAddressType(
                org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: id
         * 
         * @param connectionId the value to set
         * @return the dsl builder
         */
        default ClientEndpointProducerBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IEC 60870 Client
     * component.
     */
    public interface AdvancedClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ClientEndpointProducerBuilder basic() {
            return (ClientEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedClientEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IEC 60870 Client component.
     */
    public interface ClientEndpointBuilder
            extends
                ClientEndpointConsumerBuilder,
                ClientEndpointProducerBuilder {
        default AdvancedClientEndpointBuilder advanced() {
            return (AdvancedClientEndpointBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder dataModuleOptions(
                org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder dataModuleOptions(String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder protocolOptions(
                org.eclipse.neoscada.protocol.iec60870.ProtocolOptions protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder protocolOptions(String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder acknowledgeWindow(short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder acknowledgeWindow(String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder adsuAddressType(
                org.eclipse.neoscada.protocol.iec60870.ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder adsuAddressType(String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder causeOfTransmissionType(
                org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder informationObjectAddressType(
                org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder maxUnacknowledged(short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder maxUnacknowledged(String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder causeSourceAddress(byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: id
         * 
         * @param connectionId the value to set
         * @return the dsl builder
         */
        default ClientEndpointBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IEC 60870 Client component.
     */
    public interface AdvancedClientEndpointBuilder
            extends
                AdvancedClientEndpointConsumerBuilder,
                AdvancedClientEndpointProducerBuilder {
        default ClientEndpointBuilder basic() {
            return (ClientEndpointBuilder) this;
        }
    }

    public interface ClientBuilders {
        /**
         * IEC 60870 Client (camel-iec60870)
         * IEC 60870 supervisory control and data acquisition (SCADA) client
         * using NeoSCADA implementation.
         * 
         * Category: iot
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-iec60870
         * 
         * @return the dsl builder for the headers' name.
         */
        default ClientHeaderNameBuilder iec60870Client() {
            return ClientHeaderNameBuilder.INSTANCE;
        }
        /**
         * IEC 60870 Client (camel-iec60870)
         * IEC 60870 supervisory control and data acquisition (SCADA) client
         * using NeoSCADA implementation.
         * 
         * Category: iot
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-iec60870
         * 
         * Syntax: <code>iec60870-client:uriPath</code>
         * 
         * Path parameter: uriPath (required)
         * The object information address
         * 
         * @param path uriPath
         * @return the dsl builder
         */
        default ClientEndpointBuilder iec60870Client(String path) {
            return ClientEndpointBuilderFactory.endpointBuilder("iec60870-client", path);
        }
        /**
         * IEC 60870 Client (camel-iec60870)
         * IEC 60870 supervisory control and data acquisition (SCADA) client
         * using NeoSCADA implementation.
         * 
         * Category: iot
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-iec60870
         * 
         * Syntax: <code>iec60870-client:uriPath</code>
         * 
         * Path parameter: uriPath (required)
         * The object information address
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path uriPath
         * @return the dsl builder
         */
        default ClientEndpointBuilder iec60870Client(
                String componentName,
                String path) {
            return ClientEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the IEC 60870 Client component.
     */
    public static class ClientHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final ClientHeaderNameBuilder INSTANCE = new ClientHeaderNameBuilder();

        /**
         * The value.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code Iec60870Value}.
         */
        public String iec60870Value() {
            return "CamelIec60870Value";
        }

        /**
         * The timestamp of the value.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code Iec60870Timestamp}.
         */
        public String iec60870Timestamp() {
            return "CamelIec60870Timestamp";
        }

        /**
         * The quality information of the value.
         * 
         * The option is a: {@code
         * org.eclipse.neoscada.protocol.iec60870.asdu.types.QualityInformation}
         * type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code Iec60870Quality}.
         */
        public String iec60870Quality() {
            return "CamelIec60870Quality";
        }

        /**
         * Is overflow.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code Iec60870Overflow}.
         */
        public String iec60870Overflow() {
            return "CamelIec60870Overflow";
        }
    }
    static ClientEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ClientEndpointBuilderImpl extends AbstractEndpointBuilder implements ClientEndpointBuilder, AdvancedClientEndpointBuilder {
            public ClientEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ClientEndpointBuilderImpl(path);
    }
}