/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Stores and retrieves messages to/from Azure Storage Queue.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface QueueEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Queue Service
     * component.
     */
    public interface QueueEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedQueueEndpointConsumerBuilder advanced() {
            return (AdvancedQueueEndpointConsumerBuilder) this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.CredentialType&lt;/code&gt; type.
         * 
         * Default: SHARED_ACCOUNT_KEY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder credentialType(
                org.apache.camel.component.azure.storage.queue.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.CredentialType&lt;/code&gt; type.
         * 
         * Default: SHARED_ACCOUNT_KEY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder credentialType(
                String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder serviceClient(
                com.azure.storage.queue.QueueServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder maxMessages(Integer maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * The ID of the message to be deleted or updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * Unique identifier that must match for the message to be deleted or
         * updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param popReceipt the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder popReceipt(String popReceipt) {
            doSetProperty("popReceipt", popReceipt);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeToLive(
                java.time.Duration timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder visibilityTimeout(
                java.time.Duration visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder visibilityTimeout(
                String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure queue services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder credentials(
                com.azure.storage.common.StorageSharedKeyCredential credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Queue
     * Service component.
     */
    public interface AdvancedQueueEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default QueueEndpointConsumerBuilder basic() {
            return (QueueEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Queue Service
     * component.
     */
    public interface QueueEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedQueueEndpointProducerBuilder advanced() {
            return (AdvancedQueueEndpointProducerBuilder) this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.CredentialType&lt;/code&gt; type.
         * 
         * Default: SHARED_ACCOUNT_KEY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder credentialType(
                org.apache.camel.component.azure.storage.queue.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.CredentialType&lt;/code&gt; type.
         * 
         * Default: SHARED_ACCOUNT_KEY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder credentialType(
                String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder serviceClient(
                com.azure.storage.queue.QueueServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * When is set to true, the queue will be automatically created when
         * sending messages to the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param createQueue the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder createQueue(boolean createQueue) {
            doSetProperty("createQueue", createQueue);
            return this;
        }
        /**
         * When is set to true, the queue will be automatically created when
         * sending messages to the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param createQueue the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder createQueue(String createQueue) {
            doSetProperty("createQueue", createQueue);
            return this;
        }
        /**
         * Queue service operation hint to the producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.QueueOperationDefinition&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder operation(
                org.apache.camel.component.azure.storage.queue.QueueOperationDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Queue service operation hint to the producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.QueueOperationDefinition&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder maxMessages(Integer maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * The ID of the message to be deleted or updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * Unique identifier that must match for the message to be deleted or
         * updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param popReceipt the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder popReceipt(String popReceipt) {
            doSetProperty("popReceipt", popReceipt);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeToLive(
                java.time.Duration timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder visibilityTimeout(
                java.time.Duration visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder visibilityTimeout(
                String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure queue services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder credentials(
                com.azure.storage.common.StorageSharedKeyCredential credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Queue
     * Service component.
     */
    public interface AdvancedQueueEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default QueueEndpointProducerBuilder basic() {
            return (QueueEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Queue Service component.
     */
    public interface QueueEndpointBuilder
            extends
                QueueEndpointConsumerBuilder,
                QueueEndpointProducerBuilder {
        default AdvancedQueueEndpointBuilder advanced() {
            return (AdvancedQueueEndpointBuilder) this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.CredentialType&lt;/code&gt; type.
         * 
         * Default: SHARED_ACCOUNT_KEY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder credentialType(
                org.apache.camel.component.azure.storage.queue.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.CredentialType&lt;/code&gt; type.
         * 
         * Default: SHARED_ACCOUNT_KEY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder serviceClient(
                com.azure.storage.queue.QueueServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder maxMessages(Integer maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * The ID of the message to be deleted or updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * Unique identifier that must match for the message to be deleted or
         * updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param popReceipt the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder popReceipt(String popReceipt) {
            doSetProperty("popReceipt", popReceipt);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeToLive(java.time.Duration timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder visibilityTimeout(
                java.time.Duration visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder visibilityTimeout(String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure queue services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder credentials(
                com.azure.storage.common.StorageSharedKeyCredential credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Queue Service
     * component.
     */
    public interface AdvancedQueueEndpointBuilder
            extends
                AdvancedQueueEndpointConsumerBuilder,
                AdvancedQueueEndpointProducerBuilder {
        default QueueEndpointBuilder basic() {
            return (QueueEndpointBuilder) this;
        }
    }

    public interface QueueBuilders {
        /**
         * Azure Storage Queue Service (camel-azure-storage-queue)
         * Stores and retrieves messages to/from Azure Storage Queue.
         * 
         * Category: cloud,messaging
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-queue
         * 
         * @return the dsl builder for the headers' name.
         */
        default QueueHeaderNameBuilder azureStorageQueue() {
            return QueueHeaderNameBuilder.INSTANCE;
        }
        /**
         * Azure Storage Queue Service (camel-azure-storage-queue)
         * Stores and retrieves messages to/from Azure Storage Queue.
         * 
         * Category: cloud,messaging
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-queue
         * 
         * Syntax: <code>azure-storage-queue:accountName/queueName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure queue
         * services
         * 
         * Path parameter: queueName
         * The queue resource name
         * 
         * @param path accountName/queueName
         * @return the dsl builder
         */
        default QueueEndpointBuilder azureStorageQueue(String path) {
            return QueueEndpointBuilderFactory.endpointBuilder("azure-storage-queue", path);
        }
        /**
         * Azure Storage Queue Service (camel-azure-storage-queue)
         * Stores and retrieves messages to/from Azure Storage Queue.
         * 
         * Category: cloud,messaging
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-queue
         * 
         * Syntax: <code>azure-storage-queue:accountName/queueName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure queue
         * services
         * 
         * Path parameter: queueName
         * The queue resource name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path accountName/queueName
         * @return the dsl builder
         */
        default QueueEndpointBuilder azureStorageQueue(
                String componentName,
                String path) {
            return QueueEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Azure Storage Queue Service
     * component.
     */
    public static class QueueHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final QueueHeaderNameBuilder INSTANCE = new QueueHeaderNameBuilder();

        /**
         * Returns non-parsed httpHeaders that can be used by the user.
         * 
         * The option is a: {@code HttpHeaders} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureStorageQueueRawHttpHeaders}.
         */
        public String azureStorageQueueRawHttpHeaders() {
            return "CamelAzureStorageQueueRawHttpHeaders";
        }

        /**
         * (createQueue) Metadata to associate with the queue.
         * 
         * The option is a: {@code Map<String,String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueMetadata}.
         */
        public String azureStorageQueueMetadata() {
            return "CamelAzureStorageQueueMetadata";
        }

        /**
         * The ID of the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureStorageQueueMessageId}.
         */
        public String azureStorageQueueMessageId() {
            return "CamelAzureStorageQueueMessageId";
        }

        /**
         * The time the Message was inserted into the Queue.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureStorageQueueInsertionTime}.
         */
        public String azureStorageQueueInsertionTime() {
            return "CamelAzureStorageQueueInsertionTime";
        }

        /**
         * The time that the Message will expire and be automatically deleted.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureStorageQueueExpirationTime}.
         */
        public String azureStorageQueueExpirationTime() {
            return "CamelAzureStorageQueueExpirationTime";
        }

        /**
         * (deleteMessage, updateMessage) Unique identifier that must match for
         * the message to be deleted or updated. If deletion fails using this
         * pop receipt then the message has been dequeued by another client.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueuePopReceipt}.
         */
        public String azureStorageQueuePopReceipt() {
            return "CamelAzureStorageQueuePopReceipt";
        }

        /**
         * The time that the message will again become visible in the Queue.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureStorageQueueTimeNextVisible}.
         */
        public String azureStorageQueueTimeNextVisible() {
            return "CamelAzureStorageQueueTimeNextVisible";
        }

        /**
         * The number of times the message has been dequeued.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureStorageQueueDequeueCount}.
         */
        public String azureStorageQueueDequeueCount() {
            return "CamelAzureStorageQueueDequeueCount";
        }

        /**
         * (All) Specify the producer operation to execute, please see the doc
         * on this page related to producer operation.
         * 
         * The option is a: {@code
         * org.apache.camel.component.azure.storage.queue.QueueOperationDefinition} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueOperation}.
         */
        public String azureStorageQueueOperation() {
            return "CamelAzureStorageQueueOperation";
        }

        /**
         * (All) Override the queue name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueName}.
         */
        public String azureStorageQueueName() {
            return "CamelAzureStorageQueueName";
        }

        /**
         * (listQueues) Options for listing queues.
         * 
         * The option is a: {@code QueuesSegmentOptions} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageQueueSegmentOptions}.
         */
        public String azureStorageQueueSegmentOptions() {
            return "CamelAzureStorageQueueSegmentOptions";
        }

        /**
         * (All) An optional timeout value beyond which a RuntimeException will
         * be raised.
         * 
         * The option is a: {@code Duration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueTimeout}.
         */
        public String azureStorageQueueTimeout() {
            return "CamelAzureStorageQueueTimeout";
        }

        /**
         * (receiveMessages, peekMessages) Maximum number of messages to get, if
         * there are less messages exist in the queue than requested all the
         * messages will be returned. If left empty only 1 message will be
         * retrieved, the allowed range is 1 to 32 messages.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueMaxMessages}.
         */
        public String azureStorageQueueMaxMessages() {
            return "CamelAzureStorageQueueMaxMessages";
        }

        /**
         * (sendMessage, receiveMessages, updateMessage) The timeout period for
         * how long the message is invisible in the queue. If unset the value
         * will default to 0 and the message will be instantly visible. The
         * timeout must be between 0 seconds and 7 days.
         * 
         * The option is a: {@code Duration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageQueueVisibilityTimeout}.
         */
        public String azureStorageQueueVisibilityTimeout() {
            return "CamelAzureStorageQueueVisibilityTimeout";
        }

        /**
         * (sendMessage) How long the message will stay alive in the queue. If
         * unset the value will default to 7 days, if -1 is passed the message
         * will not expire. The time to live must be -1 or any positive number.
         * 
         * The option is a: {@code Duration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueTimeToLive}.
         */
        public String azureStorageQueueTimeToLive() {
            return "CamelAzureStorageQueueTimeToLive";
        }

        /**
         * (sendMessage) When is set to true, the queue will be automatically
         * created when sending messages to the queue.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageQueueCreateQueue}.
         */
        public String azureStorageQueueCreateQueue() {
            return "CamelAzureStorageQueueCreateQueue";
        }
    }
    static QueueEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class QueueEndpointBuilderImpl extends AbstractEndpointBuilder implements QueueEndpointBuilder, AdvancedQueueEndpointBuilder {
            public QueueEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new QueueEndpointBuilderImpl(path);
    }
}