## Description
<!--
Thank you for your pull request (PR)!

Please provide a description of what your PR does providing a link (if applicable) to the issue it fixes.
-->
Fixes # (issue)


## Type of change
<!---
What types of changes does your code introduce? Put an `x` in all the boxes that apply
-->
 - [ ] Bug fix (non-breaking change which fixes an issue)
 - [ ] Feature (non-breaking change which adds functionality)
 - [ ] Breaking change (fix or feature that would cause existing functionality to change
 - [ ] Chore (non-breaking change which doesn't affect codebase;
   test, version modification, documentation, etc.)

## Checklist
 - [ ] I have read the [contributing guidelines](https://www.eclipse.dev/jkube/contributing)
 - [ ] I signed-off my commit with a user that has signed the [Eclipse Contributor Agreement](https://www.eclipse.org/legal/ECA.php)
 - [ ] My code follows the style guidelines of this project
 - [ ] I Keep It Small and Simple: The smaller the PR is, the easier it is to review and have it merged
 - [ ] I use [conventional commits](https://www.conventionalcommits.org/) in my commit messages
 - [ ] I have performed a self-review of my code
 - [ ] I Added [CHANGELOG](../CHANGELOG.md) entry
 - [ ] I have updated the [documentation](../kubernetes-maven-plugin/doc) accordingly
 - [ ] No new bugs, code smells, etc. in [SonarCloud](https://sonarcloud.io/dashboard?id=jkubeio_jkube) report
 - [ ] I have added tests that prove my fix is effective or that my feature works
 - [ ] New and existing unit tests pass locally with my changes
 - [ ] I tested my code in Kubernetes
 - [ ] I tested my code in OpenShift

<!--
Integration tests (https://github.com/jkubeio/jkube-integration-tests)
Please check integration tests and provide/improve tests if necessary.

Open your PR in Draft mode and verify all of the applicable Checklist items before marking your issue as ready
-->
