/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.StreamFilterType;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationSortComparator;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ConfigurationExpander;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.JavaContentHandlerFactory;
import org.milyn.delivery.UnsupportedContentHandlerTypeException;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.sax.SAXContentDeliveryConfig;
import org.milyn.dtd.DTDStore;
import org.milyn.event.types.ConfigBuilderEvent;
import org.milyn.profile.ProfileSet;

public class ContentDeliveryConfigBuilder {
    private static Log logger = LogFactory.getLog(ContentDeliveryConfigBuilder.class);
    private static final String DELIVERY_CONFIG_TABLE_CTX_KEY = String.valueOf(ContentDeliveryConfig.class.getName()) + "#configTable";
    private ProfileSet profileSet;
    private ApplicationContext applicationContext;
    private static final String ELCSPEC_PREFIX = "elcspec:";
    private List<SmooksResourceConfiguration> resourceConfigsList = new ArrayList<SmooksResourceConfiguration>();
    private LinkedHashMap<String, List<SmooksResourceConfiguration>> resourceConfigTable = new LinkedHashMap();
    private VisitorConfigMap visitorConfig;
    private List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private DTDStore.DTDObjectContainer dtd;

    private ContentDeliveryConfigBuilder(ProfileSet profileSet, ApplicationContext applicationContext) {
        this.profileSet = profileSet;
        this.applicationContext = applicationContext;
        this.visitorConfig = new VisitorConfigMap(applicationContext);
        this.visitorConfig.setConfigBuilderEvents(this.configBuilderEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ContentDeliveryConfig getConfig(ProfileSet profileSet, ApplicationContext applicationContext, VisitorConfigMap extendedVisitorConfigMap) {
        ContentDeliveryConfig config;
        Class<ContentDeliveryConfigBuilder> clazz;
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg passed in method call.");
        }
        if (applicationContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg passed in method call.");
        }
        LinkedHashMap<String, ContentDeliveryConfig> configTable = ContentDeliveryConfigBuilder.getDeliveryConfigTable(applicationContext);
        if (configTable == null) {
            clazz = ContentDeliveryConfigBuilder.class;
            // MONITORENTER : org.milyn.delivery.ContentDeliveryConfigBuilder.class
            configTable = ContentDeliveryConfigBuilder.getDeliveryConfigTable(applicationContext);
            if (configTable == null) {
                configTable = new LinkedHashMap();
                applicationContext.setAttribute(DELIVERY_CONFIG_TABLE_CTX_KEY, configTable);
            }
            // MONITOREXIT : clazz
        }
        if ((config = configTable.get(profileSet.getBaseProfile())) != null) return config;
        clazz = ContentDeliveryConfigBuilder.class;
        // MONITORENTER : org.milyn.delivery.ContentDeliveryConfigBuilder.class
        config = configTable.get(profileSet.getBaseProfile());
        if (config == null) {
            ContentDeliveryConfigBuilder configBuilder = new ContentDeliveryConfigBuilder(profileSet, applicationContext);
            configBuilder.load();
            config = configBuilder.createConfig(extendedVisitorConfigMap);
            configTable.put(profileSet.getBaseProfile(), config);
        }
        // MONITOREXIT : clazz
        return config;
    }

    private ContentDeliveryConfig createConfig(VisitorConfigMap extendedVisitorConfigMap) {
        boolean sortVisitors = ParameterAccessor.getBoolParameter("smooks.visitors.sort", true, this.resourceConfigTable);
        this.visitorConfig.addAll(extendedVisitorConfigMap);
        StreamFilterType filterType = this.getStreamFilterType();
        this.configBuilderEvents.add(new ConfigBuilderEvent("SAX/DOM support characteristics of the Resource Configuration map:\n" + this.getResourceFilterCharacteristics()));
        this.configBuilderEvents.add(new ConfigBuilderEvent("Using Stream Filter Type: " + (Object)((Object)filterType)));
        if (filterType == StreamFilterType.DOM) {
            DOMContentDeliveryConfig domConfig = new DOMContentDeliveryConfig();
            logger.debug((Object)"Using the DOM Stream Filter.");
            domConfig.setAssemblyVisitBefores(this.visitorConfig.getDomAssemblyVisitBefores());
            domConfig.setAssemblyVisitAfters(this.visitorConfig.getDomAssemblyVisitAfters());
            domConfig.setProcessingVisitBefores(this.visitorConfig.getDomProcessingVisitBefores());
            domConfig.setProcessingVisitAfters(this.visitorConfig.getDomProcessingVisitAfters());
            domConfig.setSerailizationVisitors(this.visitorConfig.getDomSerializationVisitors());
            domConfig.setVisitCleanables(this.visitorConfig.getVisitCleanables());
            domConfig.setExecCleanables(this.visitorConfig.getExecCleanables());
            domConfig.setApplicationContext(this.applicationContext);
            domConfig.setSmooksResourceConfigurations(this.resourceConfigTable);
            domConfig.setDtd(this.dtd);
            domConfig.getConfigBuilderEvents().addAll(this.configBuilderEvents);
            if (sortVisitors) {
                domConfig.sort();
            }
            domConfig.initializeXMLReaderPool();
            domConfig.configureFilterBypass();
            return domConfig;
        }
        SAXContentDeliveryConfig saxConfig = new SAXContentDeliveryConfig();
        logger.debug((Object)"Using the SAX Stream Filter.");
        saxConfig.setVisitBefores(this.visitorConfig.getSaxVisitBefores());
        saxConfig.setVisitAfters(this.visitorConfig.getSaxVisitAfters());
        saxConfig.setVisitCleanables(this.visitorConfig.getVisitCleanables());
        saxConfig.setExecCleanables(this.visitorConfig.getExecCleanables());
        saxConfig.setApplicationContext(this.applicationContext);
        saxConfig.setSmooksResourceConfigurations(this.resourceConfigTable);
        saxConfig.setDtd(this.dtd);
        saxConfig.getConfigBuilderEvents().addAll(this.configBuilderEvents);
        saxConfig.optimizeConfig();
        if (sortVisitors) {
            saxConfig.sort();
        }
        saxConfig.initializeXMLReaderPool();
        return saxConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamFilterType getStreamFilterType() {
        StreamFilterType filterType;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SAX/DOM support characteristics of the Resource Configuration map:\n" + this.getResourceFilterCharacteristics()));
        }
        String filterTypeParam = ParameterAccessor.getStringParameter("stream.filter.type", this.resourceConfigTable);
        if (this.visitorConfig.getSaxVisitorCount() == this.visitorConfig.getVisitorCount() && this.visitorConfig.getDomVisitorCount() == this.visitorConfig.getVisitorCount()) {
            if (filterTypeParam == null) {
                filterType = StreamFilterType.DOM;
                logger.debug((Object)"All configured XML Element Content Handler resource configurations can be applied using the SAX or DOM Stream Filter.  Defaulting to DOM Filter.  Set 'global-parameters:stream.filter.type'.");
                logger.debug((Object)"You can explicitly select the Filter type as follows:\n\t\t<resource-config selector=\"global-parameters\">\n\t\t\t<param name=\"stream.filter.type\">SAX/DOM</param>\n\t\t</resource-config>");
            } else if (filterTypeParam.equalsIgnoreCase(StreamFilterType.DOM.name())) {
                filterType = StreamFilterType.DOM;
            } else {
                if (!filterTypeParam.equalsIgnoreCase(StreamFilterType.SAX.name())) throw new SmooksException("Invalid 'stream.filter.type' configuration parameter value of '" + filterTypeParam + "'.  Must be 'SAX' or 'DOM'.");
                filterType = StreamFilterType.SAX;
            }
        } else if (this.visitorConfig.getDomVisitorCount() == this.visitorConfig.getVisitorCount()) {
            filterType = StreamFilterType.DOM;
        } else {
            if (this.visitorConfig.getSaxVisitorCount() != this.visitorConfig.getVisitorCount()) throw new SmooksException("Ambiguous Resource Configuration set.  All Element Content Handlers must support processing on the SAX and/or DOM Filter:\n" + this.getResourceFilterCharacteristics());
            filterType = StreamFilterType.SAX;
        }
        if (filterTypeParam == null || filterTypeParam.equalsIgnoreCase(filterType.name())) return filterType;
        throw new SmooksException("The configured Filter ('" + filterTypeParam + "') cannot be used with the specified set of Smooks visitors.  The '" + (Object)((Object)filterType) + "' Filter is the only filter that can be used for this set of Visitors.  Turn on Debug logging for more information.");
    }

    private String getResourceFilterCharacteristics() {
        StringBuffer stringBuf = new StringBuffer();
        ArrayList<ContentHandler> printedHandlers = new ArrayList<ContentHandler>();
        stringBuf.append("\t\tDOM   SAX    Resource  ('x' equals supported)\n");
        stringBuf.append("\t\t---------------------------------------------------------------------\n");
        this.printHandlerCharacteristics(this.visitorConfig.getDomAssemblyVisitBefores(), stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.visitorConfig.getDomAssemblyVisitAfters(), stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.visitorConfig.getDomProcessingVisitBefores(), stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.visitorConfig.getDomProcessingVisitAfters(), stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.visitorConfig.getDomSerializationVisitors(), stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.visitorConfig.getSaxVisitBefores(), stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.visitorConfig.getSaxVisitAfters(), stringBuf, printedHandlers);
        stringBuf.append("\n\n");
        return stringBuf.toString();
    }

    private <U extends ContentHandler> void printHandlerCharacteristics(ContentHandlerConfigMapTable<U> table, StringBuffer stringBuf, List<ContentHandler> printedHandlers) {
        Collection<List<ContentHandlerConfigMap<U>>> map = table.getTable().values();
        for (List<ContentHandlerConfigMap<U>> mapList : map) {
            for (ContentHandlerConfigMap<U> configMap : mapList) {
                U handler = configMap.getContentHandler();
                boolean domSupported = VisitorConfigMap.isDOMVisitor(handler);
                boolean saxSupported = VisitorConfigMap.isSAXVisitor(handler);
                if (printedHandlers.contains(handler)) continue;
                printedHandlers.add((ContentHandler)handler);
                stringBuf.append("\t\t " + (domSupported ? "x" : " ") + "     " + (saxSupported ? "x" : " ") + "     " + configMap.getResourceConfig() + "\n");
            }
        }
    }

    private static LinkedHashMap<String, ContentDeliveryConfig> getDeliveryConfigTable(ApplicationContext applicationContext) {
        return (LinkedHashMap)applicationContext.getAttribute(DELIVERY_CONFIG_TABLE_CTX_KEY);
    }

    private void load() {
        this.resourceConfigsList.clear();
        this.resourceConfigsList.addAll(Arrays.asList(this.applicationContext.getStore().getSmooksResourceConfigurations(this.profileSet)));
        this.buildSmooksResourceConfigurationTable(this.resourceConfigsList);
        this.sortSmooksResourceConfigurations(this.resourceConfigTable);
        List<SmooksResourceConfiguration> dtdSmooksResourceConfigurations = this.resourceConfigTable.get("dtd");
        if (dtdSmooksResourceConfigurations != null && dtdSmooksResourceConfigurations.size() > 0) {
            SmooksResourceConfiguration dtdSmooksResourceConfiguration = dtdSmooksResourceConfigurations.get(0);
            byte[] dtdDataBytes = dtdSmooksResourceConfiguration.getBytes();
            if (dtdDataBytes != null) {
                DTDStore.addDTD(this.profileSet, new ByteArrayInputStream(dtdDataBytes));
                this.dtd = DTDStore.getDTDObject(this.profileSet);
            } else {
                logger.error((Object)("DTD resource [" + dtdSmooksResourceConfiguration.getResource() + "] not found in classpath."));
            }
        }
        this.expandSmooksResourceConfigurationTable();
        this.sortSmooksResourceConfigurations(this.resourceConfigTable);
        this.extractContentHandlers();
        if (logger.isDebugEnabled()) {
            this.logResourceConfig();
        }
    }

    private void logResourceConfig() {
        logger.debug((Object)"==================================================================================================");
        logger.debug((Object)("Resource configuration (sorted) for profile [" + this.profileSet.getBaseProfile() + "].  Sub Profiles: [" + this.profileSet + "]"));
        Iterator<Map.Entry<String, List<SmooksResourceConfiguration>>> configurations = this.resourceConfigTable.entrySet().iterator();
        int i = 0;
        while (configurations.hasNext()) {
            Map.Entry<String, List<SmooksResourceConfiguration>> entry = configurations.next();
            List<SmooksResourceConfiguration> resources = entry.getValue();
            logger.debug((Object)(String.valueOf(i) + ") " + entry.getKey()));
            int ii = 0;
            while (ii < resources.size()) {
                logger.debug((Object)("\t(" + ii + ") " + resources.get(ii)));
                ++ii;
            }
        }
        logger.debug((Object)"==================================================================================================");
    }

    private void buildSmooksResourceConfigurationTable(List resourceConfigsList) {
        for (SmooksResourceConfiguration config : resourceConfigsList) {
            this.addResourceConfiguration(config);
        }
    }

    private void addResourceConfiguration(SmooksResourceConfiguration config) {
        String target = config.getSelector();
        if (config.isSelectorContextual()) {
            target = config.getTargetElement();
        }
        this.addResourceConfiguration(target, config);
    }

    private void addResourceConfiguration(String element, SmooksResourceConfiguration resourceConfiguration) {
        List<SmooksResourceConfiguration> elementConfigList;
        if (!this.resourceConfigsList.contains(resourceConfiguration)) {
            this.resourceConfigsList.add(resourceConfiguration);
        }
        if ((elementConfigList = this.resourceConfigTable.get(element)) == null) {
            elementConfigList = new Vector<SmooksResourceConfiguration>();
            this.resourceConfigTable.put(element, elementConfigList);
        }
        if (!elementConfigList.contains(resourceConfiguration)) {
            elementConfigList.add(resourceConfiguration);
        }
    }

    private void expandSmooksResourceConfigurationTable() {
        class ExpansionSmooksResourceConfigurationStrategy
        implements SmooksResourceConfigurationStrategy {
            ExpansionSmooksResourceConfigurationStrategy() {
            }

            @Override
            public void applyStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
                if (resourceConfig.isXmlDef()) {
                    String[] elements = ContentDeliveryConfigBuilder.this.getDTDElements(resourceConfig.getSelector().substring(SmooksResourceConfiguration.XML_DEF_PREFIX.length()));
                    int i = 0;
                    while (i < elements.length) {
                        ContentDeliveryConfigBuilder.this.addResourceConfiguration(elements[i], resourceConfig);
                        ++i;
                    }
                }
            }
        }
        SmooksResourceConfigurationTableIterator tableIterator = new SmooksResourceConfigurationTableIterator(new ExpansionSmooksResourceConfigurationStrategy());
        tableIterator.iterate();
    }

    private void sortSmooksResourceConfigurations(Map<String, List<SmooksResourceConfiguration>> table) {
        Parameter sortParam = ParameterAccessor.getParameter("sort.resources", table);
        if (sortParam != null && sortParam.getValue().trim().equalsIgnoreCase("true") && !table.isEmpty()) {
            for (Map.Entry<String, List<SmooksResourceConfiguration>> entry : table.entrySet()) {
                List<SmooksResourceConfiguration> markupElSmooksResourceConfigurations = entry.getValue();
                SmooksResourceConfiguration[] resourceConfigs = markupElSmooksResourceConfigurations.toArray(new SmooksResourceConfiguration[markupElSmooksResourceConfigurations.size()]);
                SmooksResourceConfigurationSortComparator sortComparator = new SmooksResourceConfigurationSortComparator(this.profileSet);
                Arrays.sort(resourceConfigs, sortComparator);
                entry.setValue(new Vector<SmooksResourceConfiguration>(Arrays.asList(resourceConfigs)));
            }
        }
    }

    private void extractContentHandlers() {
        ContentHandlerExtractionStrategy cduStrategy = new ContentHandlerExtractionStrategy(this.applicationContext);
        SmooksResourceConfigurationTableIterator tableIterator = new SmooksResourceConfigurationTableIterator(cduStrategy);
        tableIterator.iterate();
    }

    private String[] getDTDElements(String string) {
        String tmpString = string.toLowerCase();
        if (tmpString.startsWith(ELCSPEC_PREFIX)) {
            if ((tmpString = tmpString.substring(ELCSPEC_PREFIX.length())).equals("empty")) {
                return this.dtd.getEmptyElements();
            }
            if (tmpString.equals("not-empty")) {
                return this.dtd.getNonEmptyElements();
            }
            if (tmpString.equals("any")) {
                return this.dtd.getAnyElements();
            }
            if (tmpString.equals("not-any")) {
                return this.dtd.getNonAnyElements();
            }
            if (tmpString.equals("mixed")) {
                return this.dtd.getMixedElements();
            }
            if (tmpString.equals("not-mixed")) {
                return this.dtd.getNonMixedElements();
            }
            if (tmpString.equals("pcdata")) {
                return this.dtd.getPCDataElements();
            }
            if (tmpString.equals("not-pcdata")) {
                return this.dtd.getNonPCDataElements();
            }
        }
        throw new IllegalStateException("Unsupported DTD spec definition [" + string + "]");
    }

    private void logExecutionEvent(SmooksResourceConfiguration resourceConfig, String message) {
        this.configBuilderEvents.add(new ConfigBuilderEvent(resourceConfig, message));
    }

    private final class ContentHandlerExtractionStrategy
    implements SmooksResourceConfigurationStrategy {
        private SmooksResourceConfigurationStore store;

        public ContentHandlerExtractionStrategy(ApplicationContext applicationContext) {
            this.store = applicationContext.getStore();
        }

        @Override
        public void applyStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
            this.applyCDUStrategy(elementName, resourceConfig);
        }

        public boolean applyCDUStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
            String restype;
            ContentHandlerFactory creator;
            if (resourceConfig.isJavaContentHandler()) {
                try {
                    creator = this.store.getContentHandlerFactory("class");
                    if (this.addCDU(elementName, resourceConfig, creator)) {
                        return true;
                    }
                }
                catch (UnsupportedContentHandlerTypeException unsupportedContentHandlerTypeException) {
                    throw new IllegalStateException("No ContentHandlerFactory configured (IoC) for type 'class' (Java).");
                }
                catch (InstantiationException instantiationException) {}
            }
            if ((creator = this.tryCreateCreator(restype = resourceConfig.getResourceType())) != null) {
                if (!(creator instanceof JavaContentHandlerFactory)) {
                    try {
                        return this.addCDU(elementName, resourceConfig, creator);
                    }
                    catch (InstantiationException e) {
                        logger.warn((Object)"ContentHandler creation failure.", (Throwable)e);
                    }
                }
            } else if (restype != null) {
                ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Unable to create ContentHandler class instance for resource.  This is probably because there's no " + ContentHandlerFactory.class.getSimpleName() + " implementation for resource " + "type '" + restype + "' available on the classpath.");
            }
            return false;
        }

        private ContentHandlerFactory tryCreateCreator(String restype) {
            block3: {
                try {
                    if (restype != null && !restype.trim().equals("")) break block3;
                    logger.debug((Object)"Request to attempt ContentHandlerFactory creation based on a null/empty resource type.");
                    return null;
                }
                catch (UnsupportedContentHandlerTypeException unsupportedContentHandlerTypeException) {
                    return null;
                }
            }
            ContentHandlerFactory creator = this.store.getContentHandlerFactory(restype);
            return creator;
        }

        private boolean addCDU(String elementName, SmooksResourceConfiguration resourceConfig, ContentHandlerFactory handlerFactory) throws InstantiationException {
            List<SmooksResourceConfiguration> additionalConfigs;
            ContentHandler contentHandler;
            try {
                contentHandler = handlerFactory.create(resourceConfig);
                this.store.getInitializedObjects().add(contentHandler);
            }
            catch (SmooksConfigurationException e) {
                throw e;
            }
            catch (Throwable thrown) {
                String message = "ContentHandlerFactory [" + handlerFactory.getClass().getName() + "] unable to create resource processing instance for resource [" + resourceConfig + "]. ";
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)message, thrown);
                } else {
                    logger.warn((Object)(String.valueOf(message) + thrown.getMessage()));
                }
                ContentDeliveryConfigBuilder.this.configBuilderEvents.add(new ConfigBuilderEvent(resourceConfig, message, thrown));
                return false;
            }
            if (contentHandler instanceof Visitor) {
                ContentDeliveryConfigBuilder.this.visitorConfig.addVisitor((Visitor)contentHandler, resourceConfig, false);
            }
            if (contentHandler instanceof ConfigurationExpander && (additionalConfigs = ((ConfigurationExpander)contentHandler).expandConfigurations()) != null && !additionalConfigs.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding expansion resource configurations created by: " + resourceConfig));
                    for (SmooksResourceConfiguration additionalConfig : additionalConfigs) {
                        logger.debug((Object)("\tAdding expansion resource configuration: " + additionalConfig));
                    }
                }
                this.processExpansionConfigurations(additionalConfigs);
            }
            if (contentHandler instanceof VisitorAppender) {
                ((VisitorAppender)((Object)contentHandler)).addVisitors(ContentDeliveryConfigBuilder.this.visitorConfig);
            }
            return true;
        }

        private void processExpansionConfigurations(List<SmooksResourceConfiguration> additionalConfigs) {
            for (SmooksResourceConfiguration config : additionalConfigs) {
                String targetElement = config.getTargetElement();
                if (this.applyCDUStrategy(targetElement, config)) continue;
                ContentDeliveryConfigBuilder.this.addResourceConfiguration(config);
            }
        }
    }

    private static interface SmooksResourceConfigurationStrategy {
        public void applyStrategy(String var1, SmooksResourceConfiguration var2);
    }

    private class SmooksResourceConfigurationTableIterator {
        private SmooksResourceConfigurationStrategy strategy;

        private SmooksResourceConfigurationTableIterator(SmooksResourceConfigurationStrategy strategy) {
            this.strategy = strategy;
        }

        private void iterate() {
            int i = 0;
            while (i < ContentDeliveryConfigBuilder.this.resourceConfigsList.size()) {
                SmooksResourceConfiguration smooksResourceConfiguration = (SmooksResourceConfiguration)ContentDeliveryConfigBuilder.this.resourceConfigsList.get(i);
                this.strategy.applyStrategy(smooksResourceConfiguration.getTargetElement(), smooksResourceConfiguration);
                ++i;
            }
        }
    }
}

