/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;
import org.hsqldb.jdbcDriver;
import org.milyn.io.StreamUtils;
import org.milyn.util.StdoutToLog4jFilter;

public class HsqlServer {
    private static Log logger = LogFactory.getLog(HsqlServer.class);
    private Server hsqlServer;
    private String url;
    private String username = "sa";
    private String password = "";
    private Connection connection;

    public HsqlServer(final int port) throws Exception {
        final String databaseName = "milyn-hsql-" + port;
        this.url = "jdbc:hsqldb:hsql://localhost:" + port + "/" + databaseName;
        logger.info((Object)("Starting Hypersonic Database '" + this.url + "'."));
        new Thread(){

            @Override
            public void run() {
                Server server = new Server();
                Log targetLogger = LogFactory.getLog((String)"org.hsqldb");
                server.setLogWriter(new PrintWriter(new StdoutToLog4jFilter(server.getLogWriter(), targetLogger)));
                server.setDatabasePath(0, "target/hsql/" + databaseName);
                server.setDatabaseName(0, databaseName);
                server.setNoSystemExit(true);
                server.setSilent(true);
                server.setPort(port);
                server.start();
                HsqlServer.this.hsqlServer = server;
            }
        }.start();
        while (this.hsqlServer == null) {
            Thread.sleep(50L);
        }
        DriverManager.registerDriver((Driver)new jdbcDriver());
        this.connection = DriverManager.getConnection(this.url, this.username, this.password);
    }

    /*
     * Unable to fully structure code
     */
    public void stop() throws Exception {
        try {
            this.hsqlServer.signalCloseAllServerConnections();
        }
        finally {
            this.hsqlServer.stop();
            ** while (this.hsqlServer.getState() != 16)
        }
lbl-1000:
        // 1 sources

        {
            Thread.sleep(100L);
            continue;
        }
lbl10:
        // 1 sources

    }

    public boolean execScript(InputStream script) throws SQLException {
        String scriptString;
        try {
            scriptString = StreamUtils.readStream(new InputStreamReader(script));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Statement statement = this.connection.createStatement();
        try {
            boolean bl = statement.execute(scriptString);
            return bl;
        }
        finally {
            statement.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getState() {
        if (this.hsqlServer == null) {
            throw new IllegalStateException("hsqlServer was null. Perhaps there was an error upon startup?");
        }
        return this.hsqlServer.getState();
    }
}

