/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.UndoLogRecord;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.ObjectArray;

public class UndoLog {
    private Session session;
    private Database database;
    private ObjectArray records = new ObjectArray();
    private FileStore file;
    private DataPage rowBuff;
    private int memoryUndo;

    public UndoLog(Session session) {
        this.session = session;
        this.database = session.getDatabase();
    }

    public int size() {
        if (SysProperties.CHECK && this.memoryUndo > this.records.size()) {
            throw Message.getInternalError();
        }
        return this.records.size();
    }

    public void clear() {
        this.records.clear();
        this.memoryUndo = 0;
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }

    public UndoLogRecord getAndRemoveLast() throws SQLException {
        UndoLogRecord undoLogRecord;
        int n = this.records.size() - 1;
        UndoLogRecord undoLogRecord2 = (UndoLogRecord)this.records.get(n);
        if (undoLogRecord2.isStored()) {
            int n2 = Math.max(0, n - this.database.getMaxMemoryUndo() / 2);
            UndoLogRecord undoLogRecord3 = null;
            for (int i = n2; i <= n; ++i) {
                UndoLogRecord undoLogRecord4 = (UndoLogRecord)this.records.get(i);
                if (!undoLogRecord4.isStored()) continue;
                undoLogRecord4.load(this.rowBuff, this.file, this.session);
                ++this.memoryUndo;
                if (undoLogRecord3 != null) continue;
                undoLogRecord3 = undoLogRecord4;
            }
            undoLogRecord3.seek(this.file);
        }
        if (!(undoLogRecord = (UndoLogRecord)this.records.remove(n)).isStored()) {
            --this.memoryUndo;
        }
        return undoLogRecord2;
    }

    public void add(UndoLogRecord undoLogRecord) throws SQLException {
        this.records.add(undoLogRecord);
        if (!undoLogRecord.isStored()) {
            ++this.memoryUndo;
        }
        if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent()) {
            if (this.file == null) {
                String string = this.database.createTempFile();
                this.file = this.database.openFile(string, "rw", false);
                this.file.autoDelete();
                this.file.seek(48L);
                DataPage dataPage = this.rowBuff = DataPage.create((DataHandler)this.database, 512);
                for (int i = 0; i < this.records.size(); ++i) {
                    UndoLogRecord undoLogRecord2 = (UndoLogRecord)this.records.get(i);
                    this.saveIfPossible(undoLogRecord2, dataPage);
                }
            } else {
                this.saveIfPossible(undoLogRecord, this.rowBuff);
            }
        }
    }

    private void saveIfPossible(UndoLogRecord undoLogRecord, DataPage dataPage) throws SQLException {
        if (!undoLogRecord.isStored() && undoLogRecord.canStore()) {
            undoLogRecord.save(dataPage, this.file);
            --this.memoryUndo;
        }
    }
}

