/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDependencyGenerator {
    protected String grammarFileName;
    protected String tokenVocab;
    protected Tool tool;
    protected Grammar grammar;
    protected CodeGenerator generator;
    protected StringTemplateGroup templates;

    public BuildDependencyGenerator(Tool tool, String grammarFileName) throws IOException, TokenStreamException, RecognitionException {
        this.tool = tool;
        this.grammarFileName = grammarFileName;
        this.grammar = tool.getRootGrammar(grammarFileName);
        String language = (String)this.grammar.getOption("language");
        this.generator = new CodeGenerator(tool, this.grammar, language);
        this.generator.loadTemplates(language);
    }

    public List<File> getGeneratedFileList() {
        String suffix;
        ArrayList<File> files = new ArrayList<File>();
        File outputDir = this.tool.getOutputDirectory(this.grammarFileName);
        if (outputDir.getName().equals(".")) {
            outputDir = null;
        } else if (outputDir.getName().indexOf(32) >= 0) {
            String escSpaces = Utils.replace(outputDir.toString(), " ", "\\ ");
            outputDir = new File(escSpaces);
        }
        String recognizer = this.generator.getRecognizerFileName(this.grammar.name, this.grammar.type);
        files.add(new File(outputDir, recognizer));
        files.add(new File(this.tool.getOutputDirectory(), this.generator.getVocabFileName()));
        StringTemplate headerExtST = null;
        StringTemplate extST = this.generator.getTemplates().getInstanceOf("codeFileExtension");
        if (this.generator.getTemplates().isDefined("headerFile")) {
            headerExtST = this.generator.getTemplates().getInstanceOf("headerFileExtension");
            suffix = Grammar.grammarTypeToFileNameSuffix[this.grammar.type];
            String fileName = this.grammar.name + suffix + headerExtST.toString();
            files.add(new File(outputDir, fileName));
        }
        if (this.grammar.type == 4) {
            suffix = Grammar.grammarTypeToFileNameSuffix[1];
            String lexer = this.grammar.name + suffix + extST.toString();
            files.add(new File(outputDir, lexer));
            if (headerExtST != null) {
                String header = this.grammar.name + suffix + headerExtST.toString();
                files.add(new File(outputDir, header));
            }
        }
        List<Grammar> imports = this.grammar.composite.getDelegates(this.grammar.composite.getRootGrammar());
        for (Grammar g : imports) {
            outputDir = this.tool.getOutputDirectory(g.getFileName());
            String fname = this.groomQualifiedFileName(outputDir.toString(), g.getRecognizerName() + extST.toString());
            files.add(new File(fname));
        }
        if (files.size() == 0) {
            return null;
        }
        return files;
    }

    public List<File> getDependenciesFileList() {
        List<File> files = this.getNonImportDependenciesFileList();
        List<Grammar> imports = this.grammar.composite.getDelegates(this.grammar.composite.getRootGrammar());
        for (Grammar g : imports) {
            String libdir = this.tool.getLibraryDirectory();
            String fileName = this.groomQualifiedFileName(libdir, g.fileName);
            files.add(new File(fileName));
        }
        if (files.size() == 0) {
            return null;
        }
        return files;
    }

    public List<File> getNonImportDependenciesFileList() {
        ArrayList<File> files = new ArrayList<File>();
        this.tokenVocab = (String)this.grammar.getOption("tokenVocab");
        if (this.tokenVocab != null) {
            File vocabFile = this.tool.getImportedVocabFile(this.tokenVocab);
            files.add(vocabFile);
        }
        return files;
    }

    public StringTemplate getDependencies() {
        this.loadDependencyTemplates();
        StringTemplate dependenciesST = this.templates.getInstanceOf("dependencies");
        dependenciesST.setAttribute("in", this.getDependenciesFileList());
        dependenciesST.setAttribute("out", this.getGeneratedFileList());
        dependenciesST.setAttribute("grammarFileName", this.grammar.fileName);
        return dependenciesST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDependencyTemplates() {
        if (this.templates != null) {
            return;
        }
        String fileName = "org/antlr/tool/templates/depend.stg";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(fileName);
        if (is == null) {
            cl = ErrorManager.class.getClassLoader();
            is = cl.getResourceAsStream(fileName);
        }
        if (is == null) {
            ErrorManager.internalError("Can't load dependency templates: " + fileName);
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            this.templates = new StringTemplateGroup((Reader)br, AngleBracketTemplateLexer.class);
            br.close();
        }
        catch (IOException ioe) {
            ErrorManager.internalError("error reading dependency templates file " + fileName, ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ErrorManager.internalError("cannot close dependency templates file " + fileName, ioe);
                }
            }
        }
    }

    public String getTokenVocab() {
        return this.tokenVocab;
    }

    public CodeGenerator getGenerator() {
        return this.generator;
    }

    public String groomQualifiedFileName(String outputDir, String fileName) {
        if (outputDir.equals(".")) {
            return fileName;
        }
        if (outputDir.indexOf(32) >= 0) {
            String escSpaces = Utils.replace(outputDir.toString(), " ", "\\ ");
            return escSpaces + File.separator + fileName;
        }
        return outputDir + File.separator + fileName;
    }
}

