/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DefaultComponentFactory
implements ComponentFactory {
    private static final DefaultComponentFactory INSTANCE = new DefaultComponentFactory();
    private static final char MNEMONIC_MARKER = '&';
    private static final ColumnSpec PREF_GROWING_COL_SPEC = new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0);
    private static Boolean cachedIsLafAqua;
    private static boolean changeHandlerRegistered;

    private DefaultComponentFactory() {
    }

    public static DefaultComponentFactory getInstance() {
        return INSTANCE;
    }

    public JLabel createLabel(String textWithMnemonic) {
        JLabel label = new JLabel();
        DefaultComponentFactory.setTextAndMnemonic(label, textWithMnemonic);
        return label;
    }

    public JLabel createTitle(String textWithMnemonic) {
        TitleLabel label = new TitleLabel();
        DefaultComponentFactory.setTextAndMnemonic(label, textWithMnemonic);
        label.setVerticalAlignment(0);
        return label;
    }

    public JComponent createSeparator(String text) {
        return this.createSeparator(text, 2);
    }

    public JComponent createSeparator(String text, int alignment) {
        if (text == null || text.length() == 0) {
            return new JSeparator();
        }
        JLabel title = this.createTitle(text);
        JPanel panel = new JPanel();
        ColumnSpec gapSpec = new ColumnSpec(DefaultComponentFactory.isLafAqua() ? Sizes.DLUX1 : Sizes.DLUX3);
        CellConstraints cc = new CellConstraints();
        if (alignment == 2) {
            FormLayout layout = new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, gapSpec, PREF_GROWING_COL_SPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            panel.setLayout(layout);
            panel.add((Component)title, cc.xy(1, 1));
            panel.add((Component)new JSeparator(), cc.xy(3, 1));
        } else if (alignment == 4) {
            FormLayout layout = new FormLayout(new ColumnSpec[]{PREF_GROWING_COL_SPEC, gapSpec, FormFactory.PREF_COLSPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            panel.setLayout(layout);
            panel.add((Component)new JSeparator(), cc.xy(1, 1));
            panel.add((Component)title, cc.xy(3, 1));
        } else if (alignment == 0) {
            FormLayout layout = new FormLayout(new ColumnSpec[]{PREF_GROWING_COL_SPEC, gapSpec, FormFactory.PREF_COLSPEC, gapSpec, PREF_GROWING_COL_SPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            panel.setLayout(layout);
            panel.add((Component)new JSeparator(), cc.xy(1, 1));
            panel.add((Component)title, cc.xy(3, 1));
            panel.add((Component)new JSeparator(), cc.xy(5, 1));
        }
        return panel;
    }

    private static void setTextAndMnemonic(JLabel label, String textWithMnemonic) {
        int end;
        int markerIndex = textWithMnemonic.indexOf(38);
        if (markerIndex == -1) {
            label.setText(textWithMnemonic);
            return;
        }
        int mnemonicIndex = -1;
        int begin = 0;
        int length = textWithMnemonic.length();
        StringBuffer buffer = new StringBuffer();
        do {
            if (markerIndex + 1 < length && textWithMnemonic.charAt(markerIndex + 1) == '&') {
                end = markerIndex + 1;
            } else {
                end = markerIndex;
                if (mnemonicIndex == -1) {
                    mnemonicIndex = markerIndex;
                }
            }
            buffer.append(textWithMnemonic.substring(begin, end));
        } while ((markerIndex = (begin = end + 1) < length ? textWithMnemonic.indexOf(38, begin) : -1) != -1);
        buffer.append(textWithMnemonic.substring(begin));
        label.setText(buffer.toString());
        if (mnemonicIndex != -1 && mnemonicIndex + 1 < length) {
            label.setDisplayedMnemonic(textWithMnemonic.charAt(mnemonicIndex + 1));
            label.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!changeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
        }
    }

    private static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = DefaultComponentFactory.computeIsLafAqua();
            DefaultComponentFactory.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    private static boolean computeIsLafAqua() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf.getName().startsWith("Mac OS X Aqua");
    }

    static {
        changeHandlerRegistered = false;
    }

    private static class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            cachedIsLafAqua = null;
        }
    }

    private static class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        private TitleLabel(String text) {
            super(text);
        }

        public void updateUI() {
            super.updateUI();
            Color foreground = UIManager.getColor("TitledBorder.titleColor");
            if (foreground != null) {
                this.setForeground(foreground);
            }
            this.setFont(this.getTitleFont());
        }

        private Font getTitleFont() {
            return DefaultComponentFactory.isLafAqua() ? UIManager.getFont("Label.font").deriveFont(1) : UIManager.getFont("TitledBorder.font");
        }
    }
}

