/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

public final class BPage
implements Serializer {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    transient BTree _btree;
    protected transient long _recid;
    protected boolean _isLeaf;
    protected Object[] _keys;
    protected Object[] _values;
    protected long[] _children;
    protected int _first;
    protected long _previous;
    protected long _next;

    public BPage() {
    }

    BPage(BTree btree, BPage root, BPage overflow) throws IOException {
        this._btree = btree;
        this._isLeaf = false;
        this._first = this._btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = overflow.getLargestKey();
        this._keys[this._btree._pageSize - 1] = root.getLargestKey();
        this._children = new long[this._btree._pageSize];
        this._children[this._btree._pageSize - 2] = overflow._recid;
        this._children[this._btree._pageSize - 1] = root._recid;
        this._recid = this._btree._recman.insert(this, this);
    }

    BPage(BTree btree, Object key, Object value) throws IOException {
        this._btree = btree;
        this._isLeaf = true;
        this._first = btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = key;
        this._keys[this._btree._pageSize - 1] = null;
        this._values = new Object[this._btree._pageSize];
        this._values[this._btree._pageSize - 2] = value;
        this._values[this._btree._pageSize - 1] = null;
        this._recid = this._btree._recman.insert(this, this);
    }

    BPage(BTree btree, boolean isLeaf) throws IOException {
        this._btree = btree;
        this._isLeaf = isLeaf;
        this._first = this._btree._pageSize / 2;
        this._keys = new Object[this._btree._pageSize];
        if (isLeaf) {
            this._values = new Object[this._btree._pageSize];
        } else {
            this._children = new long[this._btree._pageSize];
        }
        this._recid = this._btree._recman.insert(this, this);
    }

    Object getLargestKey() {
        return this._keys[this._btree._pageSize - 1];
    }

    boolean isEmpty() {
        if (this._isLeaf) {
            return this._first == this._values.length - 1;
        }
        return this._first == this._children.length - 1;
    }

    boolean isFull() {
        return this._first == 0;
    }

    TupleBrowser find(int height, Object key) throws IOException {
        int index = this.findChildren(key);
        if (--height == 0) {
            return new Browser(this, index);
        }
        BPage child = this.childBPage(index);
        return child.find(height, key);
    }

    TupleBrowser findFirst() throws IOException {
        if (this._isLeaf) {
            return new Browser(this, this._first);
        }
        BPage child = this.childBPage(this._first);
        return child.findFirst();
    }

    InsertResult insert(int height, Object key, Object value, boolean replace) throws IOException {
        long overflow;
        InsertResult result;
        int index = this.findChildren(key);
        if (--height == 0) {
            result = new InsertResult();
            overflow = -1L;
            if (this.compare(key, this._keys[index]) == 0) {
                result._existing = this._values[index];
                if (replace) {
                    this._values[index] = value;
                    this._btree._recman.update(this._recid, this, this);
                }
                return result;
            }
        } else {
            BPage child = this.childBPage(index);
            result = child.insert(height, key, value, replace);
            if (result._existing != null) {
                return result;
            }
            if (result._overflow == null) {
                return result;
            }
            key = result._overflow.getLargestKey();
            overflow = result._overflow._recid;
            this._keys[index] = child.getLargestKey();
            result._overflow = null;
        }
        if (!this.isFull()) {
            if (height == 0) {
                BPage.insertEntry(this, index - 1, key, value);
            } else {
                BPage.insertChild(this, index - 1, key, overflow);
            }
            this._btree._recman.update(this._recid, this, this);
            return result;
        }
        int half = this._btree._pageSize >> 1;
        BPage newPage = new BPage(this._btree, this._isLeaf);
        if (index < half) {
            if (height == 0) {
                BPage.copyEntries(this, 0, newPage, half, index);
                BPage.setEntry(newPage, half + index, key, value);
                BPage.copyEntries(this, index, newPage, half + index + 1, half - index - 1);
            } else {
                BPage.copyChildren(this, 0, newPage, half, index);
                BPage.setChild(newPage, half + index, key, overflow);
                BPage.copyChildren(this, index, newPage, half + index + 1, half - index - 1);
            }
        } else if (height == 0) {
            BPage.copyEntries(this, 0, newPage, half, half);
            BPage.copyEntries(this, half, this, half - 1, index - half);
            BPage.setEntry(this, index - 1, key, value);
        } else {
            BPage.copyChildren(this, 0, newPage, half, half);
            BPage.copyChildren(this, half, this, half - 1, index - half);
            BPage.setChild(this, index - 1, key, overflow);
        }
        this._first = half - 1;
        for (int i = 0; i < this._first; ++i) {
            if (height == 0) {
                BPage.setEntry(this, i, null, null);
                continue;
            }
            BPage.setChild(this, i, null, -1L);
        }
        if (this._isLeaf) {
            newPage._previous = this._previous;
            newPage._next = this._recid;
            if (this._previous != 0L) {
                BPage previous = this.loadBPage(this._previous);
                previous._next = newPage._recid;
                this._btree._recman.update(this._previous, previous, this);
            }
            this._previous = newPage._recid;
        }
        this._btree._recman.update(this._recid, this, this);
        this._btree._recman.update(newPage._recid, newPage, this);
        result._overflow = newPage;
        return result;
    }

    RemoveResult remove(int height, Object key) throws IOException {
        RemoveResult result;
        int half = this._btree._pageSize / 2;
        int index = this.findChildren(key);
        if (--height == 0) {
            if (this.compare(this._keys[index], key) != 0) {
                throw new IllegalArgumentException("Key not found: " + key);
            }
            result = new RemoveResult();
            result._value = this._values[index];
            BPage.removeEntry(this, index);
            this._btree._recman.update(this._recid, this, this);
        } else {
            BPage child = this.childBPage(index);
            result = child.remove(height, key);
            this._keys[index] = child.getLargestKey();
            this._btree._recman.update(this._recid, this, this);
            if (result._underflow) {
                if (child._first != half + 1) {
                    throw new IllegalStateException("Error during underflow [1]");
                }
                if (index < this._children.length - 1) {
                    BPage brother = this.childBPage(index + 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        if (child._isLeaf) {
                            BPage.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                            BPage.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        } else {
                            BPage.copyChildren(child, half + 1, child, half + 1 - steal, half - 1);
                            BPage.copyChildren(brother, bfirst, child, 2 * half - steal, steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BPage.setEntry(brother, i, null, null);
                                continue;
                            }
                            BPage.setChild(brother, i, null, -1L);
                        }
                        this._keys[index] = child.getLargestKey();
                        this._btree._recman.update(this._recid, this, this);
                        this._btree._recman.update(brother._recid, brother, this);
                        this._btree._recman.update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [2]");
                        }
                        brother._first = 1;
                        if (child._isLeaf) {
                            BPage.copyEntries(child, half + 1, brother, 1, half - 1);
                        } else {
                            BPage.copyChildren(child, half + 1, brother, 1, half - 1);
                        }
                        this._btree._recman.update(brother._recid, brother, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, index - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, index - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._recman.update(this._recid, this, this);
                        if (child._previous != 0L) {
                            BPage prev = this.loadBPage(child._previous);
                            prev._next = child._next;
                            this._btree._recman.update(prev._recid, prev, this);
                        }
                        if (child._next != 0L) {
                            BPage next = this.loadBPage(child._next);
                            next._previous = child._previous;
                            this._btree._recman.update(next._recid, next, this);
                        }
                        this._btree._recman.delete(child._recid);
                    }
                } else {
                    BPage brother = this.childBPage(index - 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        if (child._isLeaf) {
                            BPage.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BPage.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        } else {
                            BPage.copyChildren(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BPage.copyChildren(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BPage.setEntry(brother, i, null, null);
                                continue;
                            }
                            BPage.setChild(brother, i, null, -1L);
                        }
                        this._keys[index - 1] = brother.getLargestKey();
                        this._btree._recman.update(this._recid, this, this);
                        this._btree._recman.update(brother._recid, brother, this);
                        this._btree._recman.update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [3]");
                        }
                        child._first = 1;
                        if (child._isLeaf) {
                            BPage.copyEntries(brother, half, child, 1, half);
                        } else {
                            BPage.copyChildren(brother, half, child, 1, half);
                        }
                        this._btree._recman.update(child._recid, child, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._recman.update(this._recid, this, this);
                        if (brother._previous != 0L) {
                            BPage prev = this.loadBPage(brother._previous);
                            prev._next = brother._next;
                            this._btree._recman.update(prev._recid, prev, this);
                        }
                        if (brother._next != 0L) {
                            BPage next = this.loadBPage(brother._next);
                            next._previous = brother._previous;
                            this._btree._recman.update(next._recid, next, this);
                        }
                        this._btree._recman.delete(brother._recid);
                    }
                }
            }
        }
        result._underflow = this._first > half;
        return result;
    }

    private int findChildren(Object key) {
        int left = this._first;
        int right = this._btree._pageSize - 1;
        while (left < right) {
            int middle = (left + right) / 2;
            if (this.compare(this._keys[middle], key) < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        }
        return right;
    }

    private static void insertEntry(BPage page, int index, Object key, Object value) {
        Object[] keys = page._keys;
        Object[] values = page._values;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        --page._first;
        keys[index] = key;
        values[index] = value;
    }

    private static void insertChild(BPage page, int index, Object key, long child) {
        Object[] keys = page._keys;
        long[] children = page._children;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(children, start, children, start - 1, count);
        --page._first;
        keys[index] = key;
        children[index] = child;
    }

    private static void removeEntry(BPage page, int index) {
        Object[] keys = page._keys;
        Object[] values = page._values;
        int start = page._first;
        int count = index - page._first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        ++page._first;
    }

    private static void setEntry(BPage page, int index, Object key, Object value) {
        page._keys[index] = key;
        page._values[index] = value;
    }

    private static void setChild(BPage page, int index, Object key, long recid) {
        page._keys[index] = key;
        page._children[index] = recid;
    }

    private static void copyEntries(BPage source, int indexSource, BPage dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._values, indexSource, dest._values, indexDest, count);
    }

    private static void copyChildren(BPage source, int indexSource, BPage dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._children, indexSource, dest._children, indexDest, count);
    }

    BPage childBPage(int index) throws IOException {
        return this.loadBPage(this._children[index]);
    }

    private BPage loadBPage(long recid) throws IOException {
        BPage child = (BPage)this._btree._recman.fetch(recid, this);
        child._recid = recid;
        child._btree = this._btree;
        return child;
    }

    private final int compare(Object value1, Object value2) {
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        return this._btree._comparator.compare(value1, value2);
    }

    static byte[] readByteArray(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        in.readFully(buf);
        return buf;
    }

    static void writeByteArray(ObjectOutput out, byte[] buf) throws IOException {
        if (buf == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    private void dump(int height) {
        int i;
        String prefix = "";
        for (i = 0; i < height; ++i) {
            prefix = prefix + "    ";
        }
        System.out.println(prefix + "-------------------------------------- BPage recid=" + this._recid);
        System.out.println(prefix + "first=" + this._first);
        for (i = 0; i < this._btree._pageSize; ++i) {
            if (this._isLeaf) {
                System.out.println(prefix + "BPage [" + i + "] " + this._keys[i] + " " + this._values[i]);
                continue;
            }
            System.out.println(prefix + "BPage [" + i + "] " + this._keys[i] + " " + this._children[i]);
        }
        System.out.println(prefix + "--------------------------------------");
    }

    void dumpRecursive(int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize && this._keys[i] != null; ++i) {
                BPage child = this.childBPage(i);
                child.dump(level);
                child.dumpRecursive(height, level);
            }
        }
    }

    private void assertConsistency() {
        for (int i = this._first; i < this._btree._pageSize - 1; ++i) {
            if (this.compare((byte[])this._keys[i], (byte[])this._keys[i + 1]) < 0) continue;
            this.dump(0);
            throw new Error("BPage not ordered");
        }
    }

    void assertConsistencyRecursive(int height) throws IOException {
        this.assertConsistency();
        if (--height > 0) {
            for (int i = this._first; i < this._btree._pageSize && this._keys[i] != null; ++i) {
                BPage child = this.childBPage(i);
                if (this.compare((byte[])this._keys[i], child.getLargestKey()) != 0) {
                    this.dump(0);
                    child.dump(0);
                    throw new Error("Invalid child subordinate key");
                }
                child.assertConsistencyRecursive(height);
            }
        }
    }

    public Object deserialize(byte[] serialized) throws IOException {
        int i;
        BPage bpage = new BPage();
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        ObjectInputStream ois = new ObjectInputStream(bais);
        bpage._isLeaf = ois.readBoolean();
        if (bpage._isLeaf) {
            bpage._previous = ois.readLong();
            bpage._next = ois.readLong();
        }
        bpage._first = ois.readInt();
        bpage._keys = new Object[this._btree._pageSize];
        try {
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                if (this._btree._keySerializer == null) {
                    bpage._keys[i] = ois.readObject();
                    continue;
                }
                serialized = BPage.readByteArray(ois);
                if (serialized == null) continue;
                bpage._keys[i] = this._btree._keySerializer.deserialize(serialized);
            }
        }
        catch (ClassNotFoundException except) {
            throw new IOException(except.getMessage());
        }
        if (bpage._isLeaf) {
            bpage._values = new Object[this._btree._pageSize];
            try {
                for (i = bpage._first; i < this._btree._pageSize; ++i) {
                    if (this._btree._valueSerializer == null) {
                        bpage._values[i] = ois.readObject();
                        continue;
                    }
                    serialized = BPage.readByteArray(ois);
                    if (serialized == null) continue;
                    bpage._values[i] = this._btree._valueSerializer.deserialize(serialized);
                }
            }
            catch (ClassNotFoundException except) {
                throw new IOException(except.getMessage());
            }
        } else {
            bpage._children = new long[this._btree._pageSize];
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                bpage._children[i] = ois.readLong();
            }
        }
        ois.close();
        bais.close();
        return bpage;
    }

    public byte[] serialize(Object obj) throws IOException {
        byte[] serialized;
        int i;
        BPage bpage = (BPage)obj;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeBoolean(bpage._isLeaf);
        if (bpage._isLeaf) {
            oos.writeLong(bpage._previous);
            oos.writeLong(bpage._next);
        }
        oos.writeInt(bpage._first);
        for (i = bpage._first; i < this._btree._pageSize; ++i) {
            if (this._btree._keySerializer == null) {
                oos.writeObject(bpage._keys[i]);
                continue;
            }
            if (bpage._keys[i] != null) {
                serialized = this._btree._keySerializer.serialize(bpage._keys[i]);
                BPage.writeByteArray(oos, serialized);
                continue;
            }
            BPage.writeByteArray(oos, null);
        }
        if (bpage._isLeaf) {
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                if (this._btree._valueSerializer == null) {
                    oos.writeObject(bpage._values[i]);
                    continue;
                }
                if (bpage._values[i] != null) {
                    serialized = this._btree._valueSerializer.serialize(bpage._values[i]);
                    BPage.writeByteArray(oos, serialized);
                    continue;
                }
                BPage.writeByteArray(oos, null);
            }
        } else {
            for (i = bpage._first; i < this._btree._pageSize; ++i) {
                oos.writeLong(bpage._children[i]);
            }
        }
        oos.flush();
        byte[] data = baos.toByteArray();
        oos.close();
        baos.close();
        return data;
    }

    static class Browser
    extends TupleBrowser {
        private BPage _page;
        private int _index;

        Browser(BPage page, int index) {
            this._page = page;
            this._index = index;
        }

        public boolean getNext(Tuple tuple) throws IOException {
            if (this._index < this._page._btree._pageSize) {
                if (this._page._keys[this._index] == null) {
                    return false;
                }
            } else if (this._page._next != 0L) {
                this._page = this._page.loadBPage(this._page._next);
                this._index = this._page._first;
            }
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            ++this._index;
            return true;
        }

        public boolean getPrevious(Tuple tuple) throws IOException {
            if (this._index == this._page._first) {
                if (this._page._previous != 0L) {
                    this._page = this._page.loadBPage(this._page._previous);
                    this._index = this._page._btree._pageSize;
                } else {
                    return false;
                }
            }
            --this._index;
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            return true;
        }
    }

    static class RemoveResult {
        boolean _underflow;
        Object _value;

        RemoveResult() {
        }
    }

    static class InsertResult {
        BPage _overflow;
        Object _existing;

        InsertResult() {
        }
    }
}

