/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.base.accumulators.AccumulateFunction;

public class SumAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new SumData();
    }

    public void init(Serializable context) throws Exception {
        SumData data = (SumData)context;
        data.total = 0.0;
    }

    public void accumulate(Serializable context, Object value) {
        SumData data = (SumData)context;
        data.total += ((Number)value).doubleValue();
    }

    public void reverse(Serializable context, Object value) throws Exception {
        SumData data = (SumData)context;
        data.total -= ((Number)value).doubleValue();
    }

    public Object getResult(Serializable context) throws Exception {
        SumData data = (SumData)context;
        return new Double(data.total);
    }

    public boolean supportsReverse() {
        return true;
    }

    protected static class SumData
    implements Externalizable {
        public double total = 0.0;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readDouble();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.total);
        }
    }
}

