/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

public class MergeStressTest
extends TestCase {
    static CyclicBarrier start_connecting = null;
    static CyclicBarrier received_all_views = null;
    static CyclicBarrier start_disconnecting = null;
    static CyclicBarrier disconnected = null;
    static final int NUM = 10;
    static final long TIMEOUT = 50000L;
    static final MyThread[] threads = new MyThread[10];
    static String groupname = "ConcurrentTestDemo";
    static String props = "UDP(mcast_addr=228.8.8.9;mcast_port=7788;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=3000;num_initial_members=3):MERGE2(min_interval=3000;max_interval=5000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400):pbcast.STABLE(desired_avg_gossip=5000):FRAG(frag_size=4096):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=false;view_ack_collection_timeout=5000;merge_timeout=30000;handle_concurrent_startup=false)";

    public MergeStressTest(String name) {
        super(name);
    }

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStartupAndMerging() throws Exception {
        start_connecting = new CyclicBarrier(11);
        received_all_views = new CyclicBarrier(11);
        start_disconnecting = new CyclicBarrier(11);
        disconnected = new CyclicBarrier(11);
        for (int i = 0; i < threads.length; ++i) {
            MergeStressTest.threads[i] = new MyThread(i);
            threads[i].start();
        }
        Util.sleep(1000L);
        start_connecting.await();
        long start = System.currentTimeMillis();
        try {
            received_all_views.await();
            long stop = System.currentTimeMillis();
            System.out.println("-- took " + (stop - start) + " msecs for all " + 10 + " threads to see all views");
            System.out.print("checking that all views have 10 members: ");
            for (int i = 0; i < threads.length; ++i) {
                MyThread t = threads[i];
                int num_members = t.numMembers();
                MergeStressTest.assertEquals((int)num_members, (int)10);
            }
            System.out.println("SUCCESSFUL");
        }
        catch (Exception ex) {
            MergeStressTest.fail((String)ex.toString());
        }
        finally {
            start_disconnecting.await();
            disconnected.await();
        }
    }

    public static Test suite() {
        return new TestSuite(MergeStressTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MergeStressTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static class MyThread
    extends ReceiverAdapter
    implements Runnable {
        int index = -1;
        long total_connect_time = 0L;
        long total_disconnect_time = 0L;
        private JChannel ch = null;
        private Address my_addr = null;
        private View current_view;
        private Thread thread;
        private int num_members = 0;

        public MyThread(int i) {
            this.thread = new Thread((Runnable)this, "thread #" + i);
            this.index = i;
        }

        public void start() {
            this.thread.start();
        }

        public void closeChannel() {
            if (this.ch != null) {
                this.ch.close();
            }
        }

        public int numMembers() {
            return this.ch.getView().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            String type = "view";
            if (new_view instanceof MergeView) {
                type = "merge view";
            }
            if (this.current_view == null) {
                this.current_view = new_view;
                MergeStressTest.log(type + " accepted: " + this.current_view.getVid() + " :: " + this.current_view.getMembers());
            } else if (!this.current_view.equals(new_view)) {
                this.current_view = new_view;
                MergeStressTest.log(type + " accepted: " + this.current_view.getVid() + " :: " + this.current_view.getMembers());
            }
            this.num_members = this.current_view.getMembers().size();
            if (this.num_members == 10) {
                MyThread myThread = this;
                synchronized (myThread) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                start_connecting.await();
                this.ch = new JChannel(props);
                this.ch.setReceiver(this);
                MergeStressTest.log("connecting to channel");
                long start = System.currentTimeMillis();
                this.ch.connect(groupname);
                long stop = System.currentTimeMillis();
                this.total_connect_time = stop - start;
                View view = this.ch.getView();
                this.my_addr = this.ch.getLocalAddress();
                MergeStressTest.log(this.my_addr + " connected in " + this.total_connect_time + " msecs (" + view.getMembers().size() + " members). VID=" + this.ch.getView());
                MyThread myThread = this;
                synchronized (myThread) {
                    while (this.num_members < 10) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                MergeStressTest.log("reached " + this.num_members + " members");
                received_all_views.await();
                start_disconnecting.await();
                start = System.currentTimeMillis();
                this.ch.shutdown();
                stop = System.currentTimeMillis();
                MergeStressTest.log(this.my_addr + " shut down in " + (stop - start) + " msecs");
                disconnected.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

