/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class UtilTest
extends TestCase {
    public UtilTest(String name) {
        super(name);
    }

    public void testGetProperty() {
        Properties props = new Properties();
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        System.setProperty("name", "Michelle");
        System.setProperty("name2", "Nicole");
        String retval = Util.getProperty(new String[]{"name", "name2"}, props, "name", false, "Jeannette");
        UtilTest.assertEquals((String)"Michelle", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name", false, "Jeannette");
        UtilTest.assertEquals((String)"Nicole", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name3", "name"}, props, "name", false, "Jeannette");
        UtilTest.assertEquals((String)"Michelle", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name3", "name4"}, props, "name", false, "Jeannette");
        UtilTest.assertEquals((String)"Bela", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name", true, "Jeannette");
        UtilTest.assertEquals((String)"Bela", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name2", true, "Jeannette");
        UtilTest.assertEquals((String)"Jeannette", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name2", true, null);
        UtilTest.assertNull((Object)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
    }

    public void testIgnoreBindAddress() {
        boolean retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertFalse((boolean)retval);
        System.setProperty("jgroups.ignore.bind_addr", "true");
        retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertTrue((boolean)retval);
        System.setProperty("jgroups.ignore.bind_addr", "true2");
        retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertFalse((boolean)retval);
        System.setProperty("jgroups.ignore.bind_addr", "false");
        retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertFalse((boolean)retval);
        System.getProperties().remove("jgroups.ignore.bind_addr");
        System.setProperty("ignore.bind.address", "false");
        retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertFalse((boolean)retval);
        System.getProperties().remove("jgroups.ignore.bind_addr");
        System.setProperty("ignore.bind.address", "true");
        retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertTrue((boolean)retval);
        System.setProperty("jgroups.ignore.bind_addr", "true");
        System.setProperty("ignore.bind.address", "true");
        retval = Util.isBindAddressPropertyIgnored();
        UtilTest.assertTrue((boolean)retval);
    }

    public void testPrintBytes() {
        long num = 1L;
        String s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1b", (String)s);
        num = 999L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"999b", (String)s);
        num = 1000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1KB", (String)s);
        num = 1001L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1KB", (String)s);
        num = 1010L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1.01KB", (String)s);
        num = 1543L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1.54KB", (String)s);
        num = 10000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"10KB", (String)s);
        num = 150000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"150KB", (String)s);
        num = 150023L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"150.02KB", (String)s);
        num = 1200000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1.2MB", (String)s);
        num = 150000000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"150MB", (String)s);
        num = 150030000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"150.03MB", (String)s);
        num = 1200000000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        UtilTest.assertEquals((String)"1.2GB", (String)s);
    }

    public void testObjectToFromByteBuffer() throws Exception {
        IpAddress addr = new IpAddress("localhost", 5000);
        ArrayList<String> list = new ArrayList<String>();
        list.add("Bela");
        list.add("Jeannette");
        byte[] buf = Util.objectToByteBuffer(addr);
        IpAddress addr2 = (IpAddress)Util.objectFromByteBuffer(buf);
        System.out.println("addr=" + addr + ", addr2=" + addr2);
        UtilTest.assertEquals((Object)addr, (Object)addr2);
        buf = Util.objectToByteBuffer(list);
        List list2 = (List)Util.objectFromByteBuffer(buf);
        System.out.println("list=" + list + ", list2=" + list2);
        UtilTest.assertEquals(list, (Object)list2);
        Object obj = null;
        buf = Util.objectToByteBuffer(obj);
        UtilTest.assertNotNull((Object)buf);
        UtilTest.assertTrue((buf.length > 0 ? 1 : 0) != 0);
        obj = Util.objectFromByteBuffer(buf);
        UtilTest.assertNull((Object)obj);
        Object[] values = new Object[]{Boolean.TRUE, Boolean.FALSE, new Byte(22), new Byte("2"), new Character('5'), new Double(3.14), new Float(352.3), new Integer(100), new Long(322649L), new Short(22), "Bela Ban"};
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            this.marshal(value);
        }
    }

    public void testObjectToByteArrayWithLargeString() throws Exception {
        this.marshalString(Short.MAX_VALUE);
    }

    public void testObjectToByteArrayWithLargeString2() throws Exception {
        this.marshalString(32667);
    }

    public void testObjectToByteArrayWithLargeString3() throws Exception {
        this.marshalString(32768);
    }

    public void testObjectToByteArrayWithLargeString4() throws Exception {
        this.marshalString(32867);
    }

    public void testObjectToByteArrayWithLargeString5() throws Exception {
        this.marshalString(132767);
    }

    private void marshalString(int size) throws Exception {
        byte[] tmp = new byte[size];
        String str = new String(tmp, 0, tmp.length);
        byte[] retval = Util.objectToByteBuffer(str);
        System.out.println("length=" + retval.length + " bytes");
        String obj = (String)Util.objectFromByteBuffer(retval);
        System.out.println("read " + obj.length() + " string");
    }

    void marshal(Object obj) throws Exception {
        byte[] buf = Util.objectToByteBuffer(obj);
        UtilTest.assertNotNull((Object)buf);
        UtilTest.assertTrue((buf.length > 0 ? 1 : 0) != 0);
        Object obj2 = Util.objectFromByteBuffer(buf);
        System.out.println("obj=" + obj + ", obj2=" + obj2 + " (type=" + obj.getClass().getName() + ", length=" + buf.length + " bytes)");
        UtilTest.assertEquals((Object)obj, (Object)obj2);
    }

    public void testWriteStreamable() throws IOException, IllegalAccessException, InstantiationException {
        Message m = new Message(null, null, (Serializable)((Object)"Hello"));
        ViewId vid = new ViewId(null, 12345L);
        ViewId vid2 = new ViewId(new IpAddress("127.0.0.1", 5555), 35623L);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(m, dos);
        Util.writeGenericStreamable(vid, dos);
        Util.writeGenericStreamable(vid2, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        Message m2 = (Message)Util.readGenericStreamable(dis);
        ViewId v3 = (ViewId)Util.readGenericStreamable(dis);
        ViewId v4 = (ViewId)Util.readGenericStreamable(dis);
        UtilTest.assertNotNull((Object)m2.getBuffer());
        UtilTest.assertEquals((int)m.getLength(), (int)m2.getLength());
        UtilTest.assertNotNull((Object)v3);
        UtilTest.assertEquals((Object)vid, (Object)v3);
        UtilTest.assertNotNull((Object)v4);
        UtilTest.assertEquals((Object)vid2, (Object)v4);
    }

    public void testWriteViewIdWithNullCoordinator() throws IOException, IllegalAccessException, InstantiationException {
        ViewId vid = new ViewId(null, 12345L);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(vid, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        ViewId v4 = (ViewId)Util.readGenericStreamable(dis);
        UtilTest.assertEquals((Object)vid, (Object)v4);
    }

    public void testWriteView() throws IOException, IllegalAccessException, InstantiationException {
        ViewId vid = new ViewId(null, 12345L);
        Vector<Address> members = new Vector<Address>();
        IpAddress a1 = new IpAddress("localhost", 1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 4444);
        IpAddress a4 = new IpAddress("www.google.com", 7777);
        members.add(a1);
        members.add(a2);
        members.add(a4);
        View v = new View(vid, members);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(v, dos);
        Util.writeStreamable(v, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        View v2 = (View)Util.readGenericStreamable(dis);
        UtilTest.assertEquals((Object)v, (Object)v2);
        v2 = (View)Util.readStreamable(View.class, dis);
        UtilTest.assertEquals((Object)v, (Object)v2);
    }

    public void testWriteString() throws IOException {
        String s1 = "Bela Ban";
        String s2 = "Michelle Ban";
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeString(s1, dos);
        Util.writeString(s2, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        String s3 = Util.readString(dis);
        String s4 = Util.readString(dis);
        UtilTest.assertEquals((String)s1, (String)s3);
        UtilTest.assertEquals((String)s2, (String)s4);
    }

    public void writeAddress() throws IOException, IllegalAccessException, InstantiationException {
        IpAddress a1 = new IpAddress("localhost", 1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 4444);
        IpAddress a3 = new IpAddress("thishostdoesnexist", 6666);
        IpAddress a4 = new IpAddress("www.google.com", 7777);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeAddress(a1, dos);
        Util.writeAddress(a2, dos);
        Util.writeAddress(a3, dos);
        Util.writeAddress(a4, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        UtilTest.assertEquals((Object)a1, (Object)Util.readAddress(dis));
        UtilTest.assertEquals((Object)a2, (Object)Util.readAddress(dis));
        UtilTest.assertEquals((Object)a3, (Object)Util.readAddress(dis));
        UtilTest.assertEquals((Object)a4, (Object)Util.readAddress(dis));
    }

    public void writeNullAddress() throws IOException, IllegalAccessException, InstantiationException {
        Address a1 = null;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeAddress(a1, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        UtilTest.assertNull((Object)Util.readAddress(dis));
    }

    public void testWriteByteBuffer() throws IOException {
        byte[] buf = new byte[1024];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeByteBuffer(buf, dos);
        dos.close();
        byte[] tmp = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(tmp);
        DataInputStream dis = new DataInputStream(instream);
        byte[] buf2 = Util.readByteBuffer(dis);
        UtilTest.assertNotNull((Object)buf2);
        UtilTest.assertEquals((int)buf.length, (int)buf2.length);
    }

    public void testMatch() {
        long[] a = new long[]{1L, 2L, 3L};
        long[] b = new long[]{2L, 3L, 4L};
        long[] c = null;
        long[] d = new long[]{1L, 2L, 3L, 4L};
        long[] e = new long[]{1L, 2L, 3L};
        UtilTest.assertTrue((boolean)Util.match(a, a));
        UtilTest.assertFalse((boolean)Util.match(a, b));
        UtilTest.assertFalse((boolean)Util.match(a, c));
        UtilTest.assertFalse((boolean)Util.match(a, d));
        UtilTest.assertTrue((boolean)Util.match(a, e));
        UtilTest.assertTrue((boolean)Util.match(c, c));
        UtilTest.assertFalse((boolean)Util.match(c, a));
    }

    public void testPickRandomElement() {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < 10; ++i) {
            v.add(new Integer(i));
        }
        for (int i = 0; i < 10000; ++i) {
            Integer el = (Integer)Util.pickRandomElement(v);
            UtilTest.assertTrue((el >= 0 && el < 10 ? 1 : 0) != 0);
        }
    }

    public void testAll() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("one");
        l.add("two");
        l.add("one");
        System.out.println("-- list is " + l);
        UtilTest.assertFalse((boolean)Util.all(l, "one"));
        l.remove("two");
        System.out.println("-- list is " + l);
        UtilTest.assertTrue((boolean)Util.all(l, "one"));
    }

    public void testParseCommaDelimitedString() {
        String input = "1,2,3,4,5,6,7,8,9,10 , 11, 12 ,13";
        List list = Util.parseCommaDelimitedStrings(input);
        System.out.println("list: " + list);
        UtilTest.assertEquals((int)13, (int)list.size());
        UtilTest.assertEquals((Object)"1", list.get(0));
        UtilTest.assertEquals((Object)"13", list.get(list.size() - 1));
    }

    public void testParseSemicolonDelimitedString() {
        String input = "one;two ; three; four ; five;six";
        List list = Util.parseStringList(input, ";");
        System.out.println("list: " + list);
        UtilTest.assertEquals((int)6, (int)list.size());
        UtilTest.assertEquals((Object)"one", list.get(0));
        UtilTest.assertEquals((Object)"six", list.get(list.size() - 1));
    }

    public void testParseSemicolonDelimitedString2() {
        String input = "  myID1::subID1 ; myID2::mySubID2; myID3 ;myID4::blaSubID4";
        List list = Util.parseStringList(input, ";");
        System.out.println("list: " + list);
        UtilTest.assertEquals((int)4, (int)list.size());
        UtilTest.assertEquals((Object)"myID1::subID1", list.get(0));
        UtilTest.assertEquals((Object)"myID4::blaSubID4", list.get(list.size() - 1));
    }

    public void testVariableSubstitution() {
        String val = "hello world";
        String replacement = Util.substituteVariable(val);
        UtilTest.assertEquals((String)val, (String)replacement);
        val = "my name is ${user.name}";
        replacement = Util.substituteVariable(val);
        UtilTest.assertNotSame((Object)val, (Object)replacement);
        UtilTest.assertFalse((boolean)val.equals(replacement));
        val = "my name is ${user.name} and ${user.name}";
        replacement = Util.substituteVariable(val);
        UtilTest.assertFalse((boolean)val.equals(replacement));
        UtilTest.assertEquals((int)-1, (int)replacement.indexOf("${"));
        val = "my name is ${unknown.var:Bela Ban}";
        replacement = Util.substituteVariable(val);
        UtilTest.assertTrue((replacement.indexOf("Bela Ban") >= 0 ? 1 : 0) != 0);
        UtilTest.assertEquals((int)-1, (int)replacement.indexOf("${"));
        val = "my name is ${unknown.var}";
        replacement = Util.substituteVariable(val);
        UtilTest.assertTrue((replacement.indexOf("${") >= 0 ? 1 : 0) != 0);
        val = "here is an invalid ${argument because it doesn't contains a closing bracket";
        try {
            replacement = Util.substituteVariable(val);
            UtilTest.fail((String)"should be an IllegalArgumentException");
        }
        catch (Throwable t) {
            UtilTest.assertEquals(IllegalArgumentException.class, t.getClass());
        }
    }

    public static Test suite() {
        return new TestSuite(UtilTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UtilTest.suite());
    }

    static {
        try {
            ClassConfigurator.getInstance(true);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
    }
}

