/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeScheduler
extends ScheduledThreadPoolExecutor {
    private static int TIMER_DEFAULT_NUM_THREADS = 3;
    protected static final Log log = LogFactory.getLog(TimeScheduler.class);

    public TimeScheduler() {
        this(TIMER_DEFAULT_NUM_THREADS);
    }

    public TimeScheduler(ThreadFactory factory) {
        super(TIMER_DEFAULT_NUM_THREADS, factory);
    }

    public TimeScheduler(int corePoolSize) {
        super(corePoolSize);
    }

    public String dumpTaskQueue() {
        return this.getQueue().toString();
    }

    public ScheduledFuture<?> scheduleWithDynamicInterval(Task task, boolean relative) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        TaskWrapper task_wrapper = new TaskWrapper(task);
        task_wrapper.doSchedule();
        return task_wrapper;
    }

    public ScheduledFuture<?> scheduleWithDynamicInterval(Task t) {
        return this.scheduleWithDynamicInterval(t, true);
    }

    public int size() {
        return this.getQueue().size();
    }

    public void start() {
    }

    public void stop() throws InterruptedException {
        List<Runnable> tasks = this.shutdownNow();
        for (Runnable task : tasks) {
            if (!(task instanceof Future)) continue;
            Future future = (Future)((Object)task);
            future.cancel(true);
        }
        this.getQueue().clear();
        this.awaitTermination(3000L, TimeUnit.MILLISECONDS);
    }

    static {
        try {
            String tmp = System.getProperty("jgroups.timer.num_threads");
            if (tmp != null) {
                TIMER_DEFAULT_NUM_THREADS = Integer.parseInt(tmp);
            }
        }
        catch (Exception e) {
            log.error((Object)"could not set number of timer threads", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskWrapper<V>
    implements Runnable,
    ScheduledFuture<V> {
        private final Task task;
        private ScheduledFuture<?> future;
        private boolean cancelled = false;

        public TaskWrapper(Task task) {
            this.task = task;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        @Override
        public void run() {
            try {
                if (this.cancelled) {
                    if (this.future != null) {
                        this.future.cancel(true);
                    }
                    return;
                }
                if (this.future != null && this.future.isCancelled()) {
                    return;
                }
                this.task.run();
            }
            catch (Throwable t) {
                log.error((Object)("failed running task " + this.task), t);
            }
            if (this.cancelled) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                return;
            }
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            this.doSchedule();
        }

        public void doSchedule() {
            long next_interval = this.task.nextInterval();
            if (next_interval <= 0L) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("task will not get rescheduled as interval is " + next_interval));
                }
                System.out.println("task will not get rescheduled as interval is " + next_interval);
            } else {
                this.future = TimeScheduler.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
                if (this.cancelled) {
                    this.future.cancel(true);
                }
            }
        }

        @Override
        public int compareTo(Delayed o) {
            long their_delay;
            long my_delay = this.future.getDelay(TimeUnit.MILLISECONDS);
            return my_delay < (their_delay = o.getDelay(TimeUnit.MILLISECONDS)) ? -1 : (my_delay > their_delay ? 1 : 0);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.future != null ? this.future.getDelay(unit) : -1L;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
            }
            return this.cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled || this.future != null && this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future == null || this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }

    public static interface Task
    extends Runnable {
        public long nextInterval();

        public void run();
    }
}

