/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadValveCounter {
    private ConcurrentHashMap<Long, IntHolder> threadCounter = new ConcurrentHashMap();

    public void pushThread() {
        Long tid = Thread.currentThread().getId();
        IntHolder counter = this.threadCounter.get(tid);
        if (counter == null) {
            counter = new IntHolder();
            this.threadCounter.put(tid, counter);
        }
        counter.add();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int popThread() {
        IntHolder counter = this.threadCounter.get(Thread.currentThread().getId());
        if (counter != null && counter.release() == 0) {
            this.threadCounter.remove(Thread.currentThread().getId());
            ConcurrentHashMap<Long, IntHolder> concurrentHashMap = this.threadCounter;
            synchronized (concurrentHashMap) {
                this.threadCounter.notifyAll();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        this.exemptCurrentThread();
        ConcurrentHashMap<Long, IntHolder> concurrentHashMap = this.threadCounter;
        synchronized (concurrentHashMap) {
            while (this.getCallCount() > 0) {
                try {
                    this.threadCounter.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exemptCurrentThread() {
        IntHolder counter = this.threadCounter.get(Thread.currentThread().getId());
        if (counter != null) {
            counter.clear();
        }
        ConcurrentHashMap<Long, IntHolder> concurrentHashMap = this.threadCounter;
        synchronized (concurrentHashMap) {
            this.threadCounter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCallCount() {
        ConcurrentHashMap<Long, IntHolder> concurrentHashMap = this.threadCounter;
        synchronized (concurrentHashMap) {
            Iterator<IntHolder> iter = this.threadCounter.values().iterator();
            int total = 0;
            while (iter.hasNext()) {
                total += iter.next().get();
            }
            return total;
        }
    }

    private static class IntHolder {
        private int counter = 0;

        private IntHolder() {
        }

        public void add() {
            ++this.counter;
        }

        public int get() {
            return this.counter;
        }

        public int release() {
            --this.counter;
            return this.counter;
        }

        public void clear() {
            this.counter = 0;
        }
    }
}

