package com.redhat.installer.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

/**
 * My code does not need documentation, fool!
 * @author Dustin Kut Moy Cheung
 */
public class ShortcutHelper implements PanelAction {

	/** Variables needed for standalone shorcuts */
    private static final String DOMAIN_OFFSET = "domain.port-offset";

    private static final String MANAGEMENT_NATIVE = "standalone.management-native";
    private static final String CONSOLE = "standalone.management-http";
    private static final String STANDALONE_HTTP = "standalone.http";

    private static final String PORT_VARIABLE = "standalone.native-management.with-offset";
    private static final String CONSOLE_VARIABLE = "standalone.management-http.with-offset";
    private static final String HTTP_VARIABLE = "standalone.http.with-offset";

    /** Variables needed for Domain Shortcuts */
    private static final String DOMAIN_CONSOLE = "domain.management-native";
    private static final String DOMAIN_CONSOLE_VARIABLE = "domain.management-http.number";

    private static final String DOMAIN_HTTP = "domain.management-http";
    private static final String DOMAIN_HTTP_VARIABLE = "domain.http.number";
    /**
     * @param handler Note, as per spec., if there isn't a GUI, handler is null
     */
    public void executeAction(final AutomatedInstallData idata, AbstractUIHandler handler) {

        String managementNative;
        String console;
        String offset;
        String standaloneHttp;

        int managementNativeNumber;
        int consoleNumber;
        int standaloneHttpNumber;

        int offsetNumber;
        int offsetManagementNative;
        int offsetConsole;
        int offsetStandaloneHttp;
        /**
         * So domain.port-offset and standalone.port-offset differ only in that
         * domain.port-offset will return the numerical value of the offset
         * wheread standalone.port-offset is in the format
         * ${some-text:offset_value}
         *
         */

        offset = idata.getVariable(DOMAIN_OFFSET);

        managementNative = getPortNumber(idata.getVariable(MANAGEMENT_NATIVE));
        console = getPortNumber(idata.getVariable(CONSOLE));
        standaloneHttp = getPortNumber(idata.getVariable(STANDALONE_HTTP));

        offsetNumber = getNumber(offset);

        managementNativeNumber = getNumber(managementNative);
        consoleNumber = getNumber(console);
        standaloneHttpNumber = getNumber(standaloneHttp);
        offsetManagementNative = managementNativeNumber + offsetNumber;
        offsetConsole = consoleNumber + offsetNumber;
        offsetStandaloneHttp = offsetNumber + standaloneHttpNumber;
        idata.setVariable(PORT_VARIABLE, "127.0.0.1:" + offsetManagementNative);
        idata.setVariable(CONSOLE_VARIABLE, "" + offsetConsole);
        idata.setVariable(HTTP_VARIABLE, "" + offsetStandaloneHttp);

        /** Getting Port Numbers For Domain Shortcuts */
        idata.setVariable(DOMAIN_CONSOLE_VARIABLE, "" + 
        			getPortNumber(idata.getVariable(DOMAIN_CONSOLE)));
        idata.setVariable(DOMAIN_HTTP_VARIABLE, "" + 
        			getPortNumber(idata.getVariable(DOMAIN_HTTP)));

    }
    private int getNumber(String txt)
    {
        try
        {
            return Integer.parseInt(txt);
        }
        catch (NumberFormatException e)
        {
            return 0;
        }
    }

    private String getPortNumber(final String txt)
    {
        if (txt.startsWith("$")
        &&  txt.contains(":")
        &&  txt.endsWith("}"))
        {
            return txt.substring(txt.indexOf(":") + 1,
                                 txt.indexOf("}"));
        }
        else
        {
            return txt;
        }
    }
    /**
     * There shouldn't be any need for configuration, since this is a dedicated class
     * @param configuration null if no configuration block for the action
     */
    public void initialize(PanelActionConfiguration configuration) {
        // I am the last dinosaur on earth.
    }
}
