package com.redhat.installer.postinstall;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.File;
import java.util.Properties;
import java.util.Set;

import org.apache.tools.ant.util.TeeOutputStream;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

public class LogIzPackVars {
	private static PrintStream log = null;
	
	// logs all of the izpack variables to the log file. ran at the end of the installation
	public static void run (AbstractUIProcessHandler handler, String[]args){
		AutomatedInstallData idata = AutomatedInstallData.getInstance();
		// this should be the same ref as the one in ServerCommands. perhaps convert to static ref
		// in a utility class later
		// anything any instance of this class does needs to be appended to the given file
		FileOutputStream logFile = null;
		try {
			// destroys any hope of usability of this class outside the installer.
			logFile = new FileOutputStream(idata.getInstallPath()+"/"+idata.getVariable("installation.logfile"),true);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		if (log == null) {
				log = new PrintStream(new TeeOutputStream(System.out, logFile));
		}
		
		// CommandContext uses System.out and System.err calls internally. Thus we must redirect System.out / System.err to the log file.
		// this is an unavoidable, dirty hack due to CommandContext.
		System.setOut(log);
		System.setErr(log);

		Properties allVars = idata.getVariables();

		Set<Object> keys = allVars.keySet();
		
		for (Object key : keys){
			String realKey = (String) key;
            String realValue = (String) allVars.get(key);
			if (realKey.toLowerCase().contains("password")
                    || realKey.toLowerCase().contains("pwd")
                    || realKey.toLowerCase().contains("pass") ){
				// don't print password fields
				continue; 
			} else if (realKey.toLowerCase().contains("system_sun_java_command")) {
                // don't print passwords when passed in as cmnd line args:
                log.println(realKey + " = " + obfuscateCmdLineVariablePasswords(realValue));
            }
            else {
				log.println(realKey + " = " + realValue);
			}
		}
        // TODO: this should be moved to its own PostInstall job. including it here is hacky
		String dialect = idata.getVariable("db.dialect");
		if (dialect != null){
			System.setProperty("db.dialect", dialect);
		}
		//logFile.close();
        //ProcessPanelHelper.printToPanel(handler, "IzPack variable state written to "+ idata.getInstallPath()+"/"+idata.getVariable("installation.logfile"),false);
        ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("LogIzPackVars.message") + " " + idata.getInstallPath()+File.separator+idata.getVariable("installation.logfile"),false);
	}

    /**
     * Given a comma separated list of key=value pairs, obfuscate the
     * values of all the keys that contain the words password or pwd in them.
     * @param values
     * @return
     */
    private static String obfuscateCmdLineVariablePasswords(String values) {
        String reg = "((P|p)(assword|wd)=)(.*?)(,|$)";
        String ret = values.replaceAll(reg, "$1********$5");
        return ret;
    }
}
