package com.redhat.installer.tests.validator;

import com.redhat.installer.tests.DataValidatorTester;
import com.redhat.installer.tests.MockLdapServer;
import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.validator.BaseDnValidator;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Created by thauser on 2/5/14.
 */
public class BaseDnValidatorTest extends DataValidatorTester {
    private static MockLdapServer ldapServer;

    @BeforeClass
    public static void specificInit() throws Exception {
        idata.langpack = TestUtils.createMockLangpack("Ldap.error2");
        ldapServer = new MockLdapServer(TestUtils.ldapWorkingFile);
        ldapServer.startServer();
    }

    @AfterClass
    public static void specificDestroy() throws Exception {
        ldapServer.stopServer();
    }

    @Before
    public void setUp() throws Exception {
        dv = new BaseDnValidator();
        idata.setVariable("ldap.url", TestUtils.ldapTestUrl);
        idata.setVariable("ldap.dn", TestUtils.ldapAdminDn);
        idata.setVariable("ldap.password", TestUtils.ldapAdminPassword);
    }

    @Test
    public void testExistingDn() throws Exception {
        ldapServer.addUser("cn=Jiggalow Smith,o=TestOrganization","jsmith","Jiggalow Smith", "Smith");
        idata.setVariable("ldap.basedn", "o=TestOrganization");
        assertOk();
    }

    @Test
    public void testNonExistingDn() throws Exception {
        ldapServer.addUser("cn=Jiggalow Smith,o=TestOrganization", "jsmith", "Jiggalow Smith", "Smith");
        idata.setVariable("ldap.basedn", "o=NonExistentOrganization");
        assertWarning();
    }





}
