package com.redhat.installer.tests.validator;

import com.redhat.installer.tests.DataValidatorTester;
import com.redhat.installer.tests.MockLdapServer;
import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.validator.LdapValidator;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Created by thauser on 2/4/14.
 */
public class LdapValidatorTest extends DataValidatorTester {
    private static MockLdapServer ldapServer;

    @BeforeClass
    public static void specificInit() throws Exception{
        idata.langpack = TestUtils.createMockLangpack("Ldap.error");
        ldapServer = new MockLdapServer(TestUtils.ldapWorkingFile);
        ldapServer.startServer();
    }

    @AfterClass
    public static void specificDestroy() throws Exception {
        ldapServer.stopServer();
    }

    @Before
    public void setUp() throws Exception {
        dv = new LdapValidator();
    }

    @Test
    public void testCorrectCredentials() throws Exception {
        idata.setVariable("ldap.url", TestUtils.ldapTestUrl);
        idata.setVariable("ldap.dn", TestUtils.ldapAdminDn);
        idata.setVariable("ldap.password", TestUtils.ldapAdminPassword);
        assertOk();
    }

    @Test
    public void testWrongPassword() throws Exception {
        idata.setVariable("ldap.url", TestUtils.ldapTestUrl);
        idata.setVariable("ldap.dn", TestUtils.ldapAdminDn);
        idata.setVariable("ldap.password", "incorrect");
        assertWarning();
    }

    @Test
    public void testWrongDn() throws Exception {
        idata.setVariable("ldap.url", TestUtils.ldapTestUrl);
        idata.setVariable("ldap.dn", "uid=totallywrong,ou=wrongagain");
        idata.setVariable("ldap.password", TestUtils.ldapAdminPassword);
        assertWarning();
    }

    @Test
    public void testWrongUrl() throws Exception {
        idata.setVariable("ldap.url", "ldap://wrongurl:1111");
        idata.setVariable("ldap.dn", TestUtils.ldapAdminDn);
        idata.setVariable("ldap.password", TestUtils.ldapAdminPassword);
        assertWarning();
    }


}
