package org.jboss.errai.security.client.local.res;

import java.lang.annotation.Annotation;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.api.interceptor.FeatureInterceptor;
import org.jboss.errai.common.client.api.interceptor.RemoteCallContext;
import org.jboss.errai.common.client.api.interceptor.RemoteCallInterceptor;
import org.jboss.errai.security.client.local.interceptors.ClientSecurityRoleInterceptor;
import org.jboss.errai.security.shared.api.annotation.RestrictedAccess;

@Dependent
@FeatureInterceptor(RestrictedAccess.class)
public class ClientInterceptorTestAssistant implements RemoteCallInterceptor<RemoteCallContext> {

  private final ClientSecurityRoleInterceptor interceptor;

  public static boolean active = false;

  @Inject
  public ClientInterceptorTestAssistant(final ClientSecurityRoleInterceptor interceptor) {
    this.interceptor = interceptor;
  }

  @Override
  public void aroundInvoke(final RemoteCallContext context) {
    if (active) {
      interceptCall(context);
    }
    else {
      context.proceed();
    }
  }

  private void interceptCall(final RemoteCallContext context) {
    /*
     * Since we can't guarantee the ordering of interceptors, we will call the interceptor ourselves
     * and then return if successful.
     */
    final RemoteCallContext contextWrapper = new RemoteCallContext() {

      @Override
      public Object proceed() {
        return null;
      }

      @Override
      public Annotation[] getTypeAnnotations() {
        return context.getTypeAnnotations();
      }

      @Override
      public String getMethodName() {
        return context.getMethodName();
      }

      @Override
      public Annotation[] getAnnotations() {
        return context.getAnnotations();
      }

      @Override
      public void proceed(RemoteCallback<?> callback, ErrorCallback<?> errorCallback) {
      }

      @Override
      public void proceed(RemoteCallback<?> callback) {
      }

      @SuppressWarnings("rawtypes")
      @Override
      public Class getReturnType() {
        return context.getReturnType();
      }
      
      
    };

    interceptor.aroundInvoke(contextWrapper);
    context.setResult(null);
  }

}
